/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.entity.UPSRelatedPS;
import org.dcm4chee.archive.entity.UPSReplacedPS;
import org.dcm4chee.archive.entity.UPSRequest;
import org.dcm4chee.archive.entity.UPSSubscription;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ups")
public class UPS
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 5358842743055077420L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="updated_time")
    private Date updatedTime;
    @Column(name="ups_iuid", nullable=false)
    private String sopInstanceUID;
    @Column(name="ups_tuid")
    private String transactionUID;
    @Column(name="adm_id")
    private String admissionID;
    @Column(name="adm_id_issuer_id")
    private String issuerOfAdmissionIDLocalNamespaceEntityID;
    @Column(name="adm_id_issuer_uid")
    private String issuerOfAdmissionIDUniversialEntityID;
    @Column(name="ups_label", nullable=false)
    private String procedureStepLabel;
    @Column(name="uwl_label", nullable=false)
    private String worklistLabel;
    @Column(name="ups_start_time", nullable=false)
    private Date scheduledStartDateTime;
    @Column(name="ups_compl_time")
    private Date expectedCompletionDateTime;
    @Column(name="ups_state")
    private int stateAsInt;
    @Column(name="ups_prior")
    private int priorityAsInt;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_ups_devclass", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="devclass_fk", referencedColumnName="pk")})
    private Set<Code> scheduledStationClassCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_ups_devname", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="devname_fk", referencedColumnName="pk")})
    private Set<Code> scheduledStationNameCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_ups_appcode", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="appcode_fk", referencedColumnName="pk")})
    private Set<Code> scheduledProcessingApplicationsCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_ups_devloc", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="devloc_fk", referencedColumnName="pk")})
    private Set<Code> scheduledStationGeographicLocationCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_ups_performer", joinColumns={@JoinColumn(name="ups_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="performer_fk", referencedColumnName="pk")})
    private Set<Code> scheduledHumanPerformerCodes;
    @OneToMany(mappedBy="ups", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<UPSRequest> refRequests;
    @OneToMany(mappedBy="ups", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<UPSRelatedPS> relatedProcedureSteps;
    @OneToMany(mappedBy="ups", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<UPSReplacedPS> replacedProcedureSteps;
    @OneToMany(mappedBy="ups", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<UPSSubscription> subscriptions;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="patient_fk")
    private Patient patient;

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public Date getScheduledStartDateTime() {
        return this.scheduledStartDateTime;
    }

    public String getTransactionUID() {
        return this.transactionUID;
    }

    public String getAdmissionID() {
        return this.admissionID;
    }

    public String getIssuerOfAdmissionIDLocalNamespaceEntityID() {
        return this.issuerOfAdmissionIDLocalNamespaceEntityID;
    }

    public String getIssuerOfAdmissionIDUniversialEntityID() {
        return this.issuerOfAdmissionIDUniversialEntityID;
    }

    public String getProcedureStepLabel() {
        return this.procedureStepLabel;
    }

    public String getWorklistLabel() {
        return this.worklistLabel;
    }

    public Date getExpectedCompletionDateTime() {
        return this.expectedCompletionDateTime;
    }

    public int getStateAsInt() {
        return this.stateAsInt;
    }

    public int getPriorityAsInt() {
        return this.priorityAsInt;
    }

    public Set<Code> getScheduledStationClassCodes() {
        return this.scheduledStationClassCodes;
    }

    public Set<Code> getScheduledStationNameCodes() {
        return this.scheduledStationNameCodes;
    }

    public Set<Code> getScheduledProcessingApplicationsCodes() {
        return this.scheduledProcessingApplicationsCodes;
    }

    public Set<Code> getScheduledStationGeographicLocationCodes() {
        return this.scheduledStationGeographicLocationCodes;
    }

    public Set<Code> getScheduledHumanPerformerCodes() {
        return this.scheduledHumanPerformerCodes;
    }

    public Set<UPSRequest> getRefRequests() {
        return this.refRequests;
    }

    public Set<UPSRelatedPS> getRelatedProcedureSteps() {
        return this.relatedProcedureSteps;
    }

    public Set<UPSReplacedPS> getReplacedProcedureSteps() {
        return this.replacedProcedureSteps;
    }

    public Set<UPSSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public String toString() {
        return "UPS[pk=" + this.pk + ", uid=" + this.sopInstanceUID + ", admissionID:" + this.admissionID + ", procedureStepLabel:" + this.procedureStepLabel + ", worklistLabel:" + this.worklistLabel + ", start=" + this.scheduledStartDateTime + ", state=" + this.stateAsInt + "]";
    }

    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        throw new RuntimeException("UPS.setAttributes() is not implemented!");
    }
}

