/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.PersonName;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.common.Availability;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.Issuer;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.entity.Series;
import org.dcm4chee.archive.exceptions.ConfigurationException;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="study")
public class Study
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -5851890695263668359L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="updated_time")
    private Date updatedTime;
    @Column(name="study_iuid", nullable=false)
    private String studyInstanceUID;
    @Column(name="study_id")
    private String studyID;
    @Column(name="study_datetime")
    private Date studyDateTime;
    @Column(name="accession_no")
    private String accessionNumber;
    private String referringPhysicianName;
    @Column(name="ref_phys_fn_sx")
    private String referringPhysicianFamilyNameSoundex;
    @Column(name="ref_phys_gn_sx")
    private String referringPhysicianGivenNameSoundex;
    private String referringPhysicianIdeographicName;
    private String referringPhysicianPhoneticName;
    private String studyDescription;
    @Column(name="study_custom1")
    private String studyCustomAttribute1;
    @Column(name="study_custom2")
    private String studyCustomAttribute2;
    @Column(name="study_custom3")
    private String studyCustomAttribute3;
    private byte[] encodedAttributes;
    @Column(name="num_series", nullable=false)
    private int numberOfStudyRelatedSeries;
    @Column(name="num_instances", nullable=false)
    private int numberOfStudyRelatedInstances;
    @Column(name="mods_in_study")
    private String modalitiesInStudy;
    @Column(name="cuids_in_study")
    private String sopClassesInStudy;
    @Column(name="retrieve_aets")
    private String retrieveAETs;
    @Column(name="ext_retr_aet")
    private String externalRetrieveAET;
    @Column(name="fileset_id")
    private String fileSetID;
    @Column(name="fileset_iuid")
    private String fileSetUID;
    @Column(name="availability", nullable=false)
    private Availability availability;
    @Column(name="study_status", nullable=false)
    private int studyStatus;
    @Column(name="study_status_id")
    private String studyStatusID;
    @Column(name="checked_time")
    private Timestamp timeOfLastConsistencyCheck;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_study_pcode", joinColumns={@JoinColumn(name="study_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="pcode_fk", referencedColumnName="pk")})
    private Set<Code> procedureCodes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="accno_issuer_fk")
    private Issuer issuerOfAccessionNumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="patient_fk")
    private Patient patient;
    @Column(name="patient_fk", insertable=false, updatable=false)
    private Long patientFk;
    @OneToMany(mappedBy="study", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<Series> series;

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String uid) {
        this.studyInstanceUID = uid;
    }

    public String getStudyID() {
        return this.studyID;
    }

    public void setStudyID(String studyID) {
        this.studyID = studyID;
    }

    public Date getStudyDateTime() {
        return this.studyDateTime;
    }

    public void setStudyDateTime(Date studyDateTime) {
        this.studyDateTime = studyDateTime;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public String getReferringPhysicianName() {
        return this.referringPhysicianName;
    }

    public String getReferringPhysicianFamilyNameSoundex() {
        return this.referringPhysicianFamilyNameSoundex;
    }

    public void setReferringPhysicianFamilyNameSoundex(String referringPhysicianFamilyNameSoundex) {
        this.referringPhysicianFamilyNameSoundex = referringPhysicianFamilyNameSoundex;
    }

    public String getReferringPhysicianGivenNameSoundex() {
        return this.referringPhysicianGivenNameSoundex;
    }

    public void setReferringPhysicianGivenNameSoundex(String referringPhysicianGivenNameSoundex) {
        this.referringPhysicianGivenNameSoundex = referringPhysicianGivenNameSoundex;
    }

    public String getReferringPhysicianIdeographicName() {
        return this.referringPhysicianIdeographicName;
    }

    public String getReferringPhysicianPhoneticName() {
        return this.referringPhysicianPhoneticName;
    }

    public String getStudyDescription() {
        return this.studyDescription;
    }

    public void setStudyDescription(String studyDescription) {
        this.studyDescription = studyDescription;
    }

    public String getStudyCustomAttribute1() {
        return this.studyCustomAttribute1;
    }

    public void setStudyCustomAttribute1(String studyCustomAttribute1) {
        this.studyCustomAttribute1 = studyCustomAttribute1;
    }

    public String getStudyCustomAttribute2() {
        return this.studyCustomAttribute2;
    }

    public void setStudyCustomAttribute2(String studyCustomAttribute2) {
        this.studyCustomAttribute2 = studyCustomAttribute2;
    }

    public String getStudyCustomAttribute3() {
        return this.studyCustomAttribute3;
    }

    public void setStudyCustomAttribute3(String studyCustomAttribute3) {
        this.studyCustomAttribute3 = studyCustomAttribute3;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public int getNumberOfStudyRelatedSeries() {
        return this.numberOfStudyRelatedSeries;
    }

    public void setNumberOfStudyRelatedSeries(int numberOfStudyRelatedSeries) {
        this.numberOfStudyRelatedSeries = numberOfStudyRelatedSeries;
    }

    public int getNumberOfStudyRelatedInstances() {
        return this.numberOfStudyRelatedInstances;
    }

    public void setNumberOfStudyRelatedInstances(int numberOfStudyRelatedInstances) {
        this.numberOfStudyRelatedInstances = numberOfStudyRelatedInstances;
    }

    public String getModalitiesInStudy() {
        return this.modalitiesInStudy;
    }

    public void setModalitiesInStudy(String modalitiesInStudy) {
        this.modalitiesInStudy = modalitiesInStudy;
    }

    public String getSopClassesInStudy() {
        return this.sopClassesInStudy;
    }

    public void setSopClassesInStudy(String sopClassesInStudy) {
        this.sopClassesInStudy = sopClassesInStudy;
    }

    public String getRetrieveAETs() {
        return this.retrieveAETs;
    }

    public void setRetrieveAETs(String retrieveAETs) {
        this.retrieveAETs = retrieveAETs;
    }

    public String getExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public void setExternalRetrieveAET(String externalRetrieveAET) {
        this.externalRetrieveAET = externalRetrieveAET;
    }

    public String getFileSetID() {
        return this.fileSetID;
    }

    public void setFileSetID(String fileSetID) {
        this.fileSetID = fileSetID;
    }

    public String getFileSetUID() {
        return this.fileSetUID;
    }

    public void setFileSetUID(String fileSetUID) {
        this.fileSetUID = fileSetUID;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    @Deprecated
    public String getStudyStatusID() {
        return this.studyStatusID;
    }

    @Deprecated
    public void setStudyStatusID(String studyStatusID) {
        this.studyStatusID = studyStatusID;
    }

    @Deprecated
    public int getStudyStatus() {
        return this.studyStatus;
    }

    @Deprecated
    public void setStudyStatus(int studyStatus) {
        this.studyStatus = studyStatus;
    }

    public Timestamp getTimeOfLastConsistencyCheck() {
        return this.timeOfLastConsistencyCheck;
    }

    public void setTimeOfLastConsistencyCheck(Timestamp timeOfLastConsistencyCheck) {
        this.timeOfLastConsistencyCheck = timeOfLastConsistencyCheck;
    }

    public Set<Code> getProcedureCodes() {
        return this.procedureCodes;
    }

    public void setProcedureCodes(Set<Code> procedureCodes) {
        this.procedureCodes = procedureCodes;
    }

    public Issuer getIssuerOfAccessionNumber() {
        return this.issuerOfAccessionNumber;
    }

    public void setIssuerOfAccessionNumber(Issuer issuerOfAccessionNumber) {
        this.issuerOfAccessionNumber = issuerOfAccessionNumber;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public Set<Series> getSeries() {
        return this.series;
    }

    public void setSeries(Set<Series> series) {
        this.series = series;
    }

    public String toString() {
        return "Study[pk=" + this.pk + ", uid=" + this.studyInstanceUID + ", id=" + this.studyID + ", accno=" + this.accessionNumber + ", date=" + this.studyDateTime + ", desc=" + this.studyDescription + ", mods=" + this.modalitiesInStudy + ", cuids=" + this.sopClassesInStudy + ", refphys=" + this.referringPhysicianName + ", numseries=" + this.numberOfStudyRelatedSeries + ", numinsts=" + this.numberOfStudyRelatedInstances + ", avail=" + (Object)((Object)this.availability) + ", aets=" + this.retrieveAETs + ", extaet=" + this.externalRetrieveAET + ", fsid=" + this.fileSetID + ", fsuid=" + this.fileSetUID + "]";
    }

    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public DicomObject getAttributes(boolean cfindrsp) {
        DicomObject dataset = DicomObjectUtils.decode(this.encodedAttributes);
        if (cfindrsp) {
            dataset.putInt(2101766, VR.IS, this.numberOfStudyRelatedSeries);
            dataset.putInt(2101768, VR.IS, this.numberOfStudyRelatedInstances);
            dataset.putString(524385, VR.CS, this.modalitiesInStudy);
            dataset.putString(524386, VR.UI, this.sopClassesInStudy);
            if (this.fileSetUID != null && this.fileSetID != null) {
                dataset.putString(8913216, VR.UI, this.fileSetUID);
                dataset.putString(8913200, VR.SH, this.fileSetID);
            }
            if (this.retrieveAETs != null || this.externalRetrieveAET != null) {
                dataset.putString(524372, VR.AE, this.externalRetrieveAET == null ? this.retrieveAETs : (this.retrieveAETs == null ? this.externalRetrieveAET : this.retrieveAETs + '\\' + this.externalRetrieveAET));
            }
            dataset.putString(524374, VR.CS, this.availability.name());
        }
        return dataset;
    }

    public void setAttributes(DicomObject attrs) {
        this.studyInstanceUID = attrs.getString(0x20000D);
        this.studyID = attrs.getString(0x200010, "");
        this.studyDateTime = attrs.getDate(524320, 524336);
        this.accessionNumber = attrs.getString(524368, "");
        PersonName pn = new PersonName(attrs.getString(524432));
        this.referringPhysicianName = pn.componentGroupString(0, false).toUpperCase();
        this.referringPhysicianIdeographicName = pn.componentGroupString(1, false);
        this.referringPhysicianPhoneticName = pn.componentGroupString(2, false);
        if (AttributeFilter.isSoundexEnabled()) {
            this.referringPhysicianFamilyNameSoundex = AttributeFilter.toSoundex(pn, 0, "*");
            this.referringPhysicianGivenNameSoundex = AttributeFilter.toSoundex(pn, 1, "*");
        }
        this.studyDescription = attrs.getString(528432, "");
        AttributeFilter filter = AttributeFilter.getStudyAttributeFilter();
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            try {
                this.setField(filter.getField(fieldTags[i]), attrs.getString(fieldTags[i], ""));
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        this.encodedAttributes = DicomObjectUtils.encode(filter.filter(attrs), filter.getTransferSyntaxUID());
    }

    private void setField(String field, String value) {
        try {
            Method m = Study.class.getMethod("set" + Character.toUpperCase(field.charAt(0)) + field.substring(1), String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public Long getPatientFk() {
        return this.patientFk;
    }
}

