/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.PersonName;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.common.Availability;
import org.dcm4chee.archive.common.StorageStatus;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.Instance;
import org.dcm4chee.archive.entity.MPPS;
import org.dcm4chee.archive.entity.RequestAttributes;
import org.dcm4chee.archive.entity.Study;
import org.dcm4chee.archive.exceptions.ConfigurationException;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="series")
@NamedQuery(name="Series.findByIUID", query="select object(s) from Series s where seriesInstanceUID = :iuid")
public class Series
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -5882522097745649285L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="updated_time")
    private Date updatedTime;
    @Column(name="series_iuid", nullable=false)
    private String seriesInstanceUID;
    @Column(name="series_no")
    private String seriesNumber;
    @Column(name="series_desc")
    private String seriesDescription;
    @Column(name="modality")
    private String modality;
    private String institutionalDepartmentName;
    private String institutionName;
    @Column(name="station_name")
    private String stationName;
    @Column(name="body_part")
    private String bodyPartExamined;
    @Column(name="laterality")
    private String laterality;
    private String performingPhysicianName;
    @Column(name="perf_phys_fn_sx")
    private String performingPhysicianFamilyNameSoundex;
    @Column(name="perf_phys_gn_sx")
    private String performingPhysicianGivenNameSoundex;
    private String performingPhysicianIdeographicName;
    private String performingPhysicianPhoneticName;
    @Column(name="pps_start")
    private Date performedProcedureStepStartDateTime;
    @Column(name="pps_iuid")
    private String performedProcedureStepInstanceUID;
    @Column(name="series_custom1")
    private String seriesCustomAttribute1;
    @Column(name="series_custom2")
    private String seriesCustomAttribute2;
    @Column(name="series_custom3")
    private String seriesCustomAttribute3;
    private byte[] encodedAttributes;
    @Column(name="num_instances", nullable=false)
    private int numberOfSeriesRelatedInstances;
    @Column(name="src_aet")
    private String sourceAET;
    @Column(name="retrieve_aets")
    private String retrieveAETs;
    @Column(name="ext_retr_aet")
    private String externalRetrieveAET;
    @Column(name="fileset_iuid")
    private String fileSetUID;
    @Column(name="fileset_id")
    private String fileSetID;
    @Column(name="availability", nullable=false)
    private Availability availability;
    @Column(name="series_status", nullable=false)
    private StorageStatus storageStatus;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="inst_code_fk")
    private Code institutionCode;
    @OneToMany(mappedBy="series", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<RequestAttributes> requestAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="mpps_fk")
    private MPPS modalityPerformedProcedureStep;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="study_fk")
    private Study study;
    @OneToMany(mappedBy="series", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<Instance> instances;

    public String getPerformingPhysicianFamilyNameSoundex() {
        return this.performingPhysicianFamilyNameSoundex;
    }

    public void setPerformingPhysicianFamilyNameSoundex(String performingPhysicianFamilyNameSoundex) {
        this.performingPhysicianFamilyNameSoundex = performingPhysicianFamilyNameSoundex;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public String getModality() {
        return this.modality;
    }

    public String getInstitutionalDepartmentName() {
        return this.institutionalDepartmentName;
    }

    public String getInstitutionName() {
        return this.institutionName;
    }

    public String getStationName() {
        return this.stationName;
    }

    public String getBodyPartExamined() {
        return this.bodyPartExamined;
    }

    public String getLaterality() {
        return this.laterality;
    }

    public String getPerformingPhysicianName() {
        return this.performingPhysicianName;
    }

    public String getPerformingPhysicianGivenNameSoundex() {
        return this.performingPhysicianGivenNameSoundex;
    }

    public void setPerformingPhysicianGivenNameSoundex(String performingPhysicianGivenNameSoundex) {
        this.performingPhysicianGivenNameSoundex = performingPhysicianGivenNameSoundex;
    }

    public String getPerformingPhysicianIdeographicName() {
        return this.performingPhysicianIdeographicName;
    }

    public String getPerformingPhysicianPhoneticName() {
        return this.performingPhysicianPhoneticName;
    }

    public Date getPerformedProcedureStepStartDateTime() {
        return this.performedProcedureStepStartDateTime;
    }

    public String getPerformedProcedureStepInstanceUID() {
        return this.performedProcedureStepInstanceUID;
    }

    public String getSeriesCustomAttribute1() {
        return this.seriesCustomAttribute1;
    }

    public void setSeriesCustomAttribute1(String value) {
        this.seriesCustomAttribute1 = value;
    }

    public String getSeriesCustomAttribute2() {
        return this.seriesCustomAttribute2;
    }

    public void setSeriesCustomAttribute2(String value) {
        this.seriesCustomAttribute2 = value;
    }

    public String getSeriesCustomAttribute3() {
        return this.seriesCustomAttribute3;
    }

    public void setSeriesCustomAttribute3(String value) {
        this.seriesCustomAttribute3 = value;
    }

    public int getNumberOfSeriesRelatedInstances() {
        return this.numberOfSeriesRelatedInstances;
    }

    public void setNumberOfSeriesRelatedInstances(int numberOfSeriesRelatedInstances) {
        this.numberOfSeriesRelatedInstances = numberOfSeriesRelatedInstances;
    }

    public String getSourceAET() {
        return this.sourceAET;
    }

    public String getRetrieveAETs() {
        return this.retrieveAETs;
    }

    public void setRetrieveAETs(String retrieveAETs) {
        this.retrieveAETs = retrieveAETs;
    }

    public String getExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public void setExternalRetrieveAET(String externalRetrieveAET) {
        this.externalRetrieveAET = externalRetrieveAET;
    }

    public String getFileSetUID() {
        return this.fileSetUID;
    }

    public void setFileSetUID(String fileSetUID) {
        this.fileSetUID = fileSetUID;
    }

    public String getFileSetID() {
        return this.fileSetID;
    }

    public void setFileSetID(String fileSetID) {
        this.fileSetID = fileSetID;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    public StorageStatus getStorageStatus() {
        return this.storageStatus;
    }

    public void setStorageStatus(StorageStatus storageStatus) {
        this.storageStatus = storageStatus;
    }

    public Code getInstitutionCode() {
        return this.institutionCode;
    }

    public void setInstitutionCode(Code institutionCode) {
        this.institutionCode = institutionCode;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Set<RequestAttributes> getRequestAttributes() {
        return this.requestAttributes;
    }

    public void setRequestAttributes(Set<RequestAttributes> requestAttributes) {
        this.requestAttributes = requestAttributes;
    }

    public MPPS getModalityPerformedProcedureStep() {
        return this.modalityPerformedProcedureStep;
    }

    public void setModalityPerformedProcedureStep(MPPS modalityPerformedProcedureStep) {
        this.modalityPerformedProcedureStep = modalityPerformedProcedureStep;
    }

    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    public Set<Instance> getInstances() {
        return this.instances;
    }

    public String toString() {
        return "Series[pk=" + this.pk + ", uid=" + this.seriesInstanceUID + ", serno=" + this.seriesNumber + ", desc=" + this.seriesDescription + ", mod=" + this.modality + ", station=" + this.stationName + ", department=" + this.institutionalDepartmentName + ", institution=" + this.institutionName + ", srcaet=" + this.sourceAET + ", bodypart=" + this.bodyPartExamined + ", laterality=" + this.laterality + ", performer=" + this.performingPhysicianName + ", start=" + this.performedProcedureStepStartDateTime + ", ppsuid=" + this.performedProcedureStepInstanceUID + ", numinsts=" + this.numberOfSeriesRelatedInstances + ", status=" + (Object)((Object)this.storageStatus) + ", avail=" + (Object)((Object)this.availability) + ", aets=" + this.retrieveAETs + ", extaet=" + this.externalRetrieveAET + ", fsid=" + this.fileSetID + ", fsuid=" + this.fileSetUID + "]";
    }

    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public DicomObject getAttributes(boolean cfindrsp) {
        DicomObject dataset = DicomObjectUtils.decode(this.encodedAttributes);
        if (cfindrsp) {
            dataset.putInt(2101769, VR.IS, this.numberOfSeriesRelatedInstances);
            if (this.fileSetUID != null && this.fileSetID != null) {
                dataset.putString(8913216, VR.UI, this.fileSetUID);
                dataset.putString(8913200, VR.SH, this.fileSetID);
            }
            if (this.retrieveAETs != null || this.externalRetrieveAET != null) {
                dataset.putString(524372, VR.AE, this.externalRetrieveAET == null ? this.retrieveAETs : (this.retrieveAETs == null ? this.externalRetrieveAET : this.retrieveAETs + '\\' + this.externalRetrieveAET));
            }
            dataset.putString(524374, VR.CS, this.availability.name());
        }
        return dataset;
    }

    public void setAttributes(DicomObject attrs) {
        this.seriesInstanceUID = attrs.getString(0x20000E);
        this.seriesNumber = attrs.getString(0x200011, "");
        this.seriesDescription = attrs.getString(528446, "");
        this.modality = attrs.getString(524384, "");
        this.institutionalDepartmentName = attrs.getString(528448, "");
        this.institutionName = attrs.getString(524416, "");
        this.stationName = attrs.getString(528400, "");
        String srcAET = attrs.getString(attrs.resolveTag(4390932, "dcm4che/archive"));
        if (srcAET != null && srcAET.trim().length() > 1) {
            this.sourceAET = srcAET;
        }
        this.bodyPartExamined = attrs.getString(1572885, "");
        this.laterality = attrs.getString(0x200060, "");
        PersonName pn = new PersonName(attrs.getString(528464));
        this.performingPhysicianName = pn.componentGroupString(0, false).toUpperCase();
        this.performingPhysicianIdeographicName = pn.componentGroupString(1, false);
        this.performingPhysicianPhoneticName = pn.componentGroupString(2, false);
        if (AttributeFilter.isSoundexEnabled()) {
            this.performingPhysicianFamilyNameSoundex = AttributeFilter.toSoundex(pn, 0, "*");
            this.performingPhysicianGivenNameSoundex = AttributeFilter.toSoundex(pn, 1, "*");
        }
        this.performedProcedureStepStartDateTime = attrs.getDate(0x400244, 4194885);
        this.performedProcedureStepInstanceUID = attrs.getString(new int[]{528657, 0, 528725});
        AttributeFilter filter = AttributeFilter.getSeriesAttributeFilter();
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            try {
                this.setField(filter.getField(fieldTags[i]), attrs.getString(fieldTags[i], ""));
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        this.encodedAttributes = DicomObjectUtils.encode(filter.filter(attrs), filter.getTransferSyntaxUID());
    }

    private void setField(String field, String value) {
        try {
            Method m = Series.class.getMethod("set" + Character.toUpperCase(field.charAt(0)) + field.substring(1), String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

