/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.PersonName;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Issuer;
import org.dcm4chee.archive.entity.Series;

@Entity
@Table(name="series_req")
public class RequestAttributes
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -5693026277386978780L;
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="study_iuid")
    private String studyInstanceUID;
    @Column(name="req_proc_id")
    private String requestedProcedureID;
    @Column(name="sps_id")
    private String scheduledProcedureStepID;
    private String requestingService;
    private String requestingPhysician;
    @Column(name="req_phys_fn_sx")
    private String requestingPhysicianFamilyNameSoundex;
    @Column(name="req_phys_gn_sx")
    private String requestingPhysicianGivenNameSoundex;
    private String requestingPhysicianIdeographicName;
    private String requestingPhysicianPhoneticName;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="series_fk")
    private Series series;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="accno_issuer_fk")
    private Issuer issuerOfAccessionNumber;

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public String getScheduledProcedureStepID() {
        return this.scheduledProcedureStepID;
    }

    public String getRequestingService() {
        return this.requestingService;
    }

    public String getRequestingPhysician() {
        return this.requestingPhysician;
    }

    public String getRequestingPhysicianIdeographicName() {
        return this.requestingPhysicianIdeographicName;
    }

    public String getRequestingPhysicianPhoneticName() {
        return this.requestingPhysicianPhoneticName;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public String getRequestingPhysicianFamilyNameSoundex() {
        return this.requestingPhysicianFamilyNameSoundex;
    }

    public void setRequestingPhysicianFamilyNameSoundex(String requestingPhysicianFamilyNameSoundex) {
        this.requestingPhysicianFamilyNameSoundex = requestingPhysicianFamilyNameSoundex;
    }

    public String getRequestingPhysicianGivenNameSoundex() {
        return this.requestingPhysicianGivenNameSoundex;
    }

    public void setRequestingPhysicianGivenNameSoundex(String requestingPhysicianGivenNameSoundex) {
        this.requestingPhysicianGivenNameSoundex = requestingPhysicianGivenNameSoundex;
    }

    public Issuer getIssuerOfAccessionNumber() {
        return this.issuerOfAccessionNumber;
    }

    public void setIssuerOfAccessionNumber(Issuer issuerOfAccessionNumber) {
        this.issuerOfAccessionNumber = issuerOfAccessionNumber;
    }

    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        this.series = series;
    }

    public String toString() {
        return "RequestAttributes[pk=" + this.pk + ", suid=" + this.studyInstanceUID + ", rpid=" + this.requestedProcedureID + ", spsid=" + this.scheduledProcedureStepID + "]";
    }

    public void setAttributes(DicomObject attrs) {
        this.studyInstanceUID = attrs.getString(0x20000D, "");
        this.requestedProcedureID = attrs.getString(0x401001, "");
        this.scheduledProcedureStepID = attrs.getString(0x400009, "");
        this.requestingService = attrs.getString(3280947, "");
        PersonName pn = new PersonName(attrs.getString(3280946));
        this.requestingPhysician = pn.componentGroupString(0, false).toUpperCase();
        this.requestingPhysicianIdeographicName = pn.componentGroupString(1, false);
        this.requestingPhysicianPhoneticName = pn.componentGroupString(2, false);
        if (AttributeFilter.isSoundexEnabled()) {
            this.requestingPhysicianFamilyNameSoundex = AttributeFilter.toSoundex(pn, 0, "*");
            this.requestingPhysicianGivenNameSoundex = AttributeFilter.toSoundex(pn, 1, "*");
        }
    }
}

