/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.PrivatePatient;
import org.dcm4chee.archive.entity.PrivateSeries;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="priv_study")
@NamedQuery(name="PrivateStudy.findByIUID", query="select object(ps) from PrivateStudy ps where studyInstanceUID = :iuid")
public class PrivateStudy
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -7571163230633648191L;
    @Column(name="priv_type", nullable=false)
    private int privateType;
    @Column(name="study_iuid", nullable=false)
    private String studyInstanceUID;
    @Column(name="accession_no")
    private String accessionNumber;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="patient_fk")
    private PrivatePatient patient;
    @OneToMany(mappedBy="study", fetch=FetchType.LAZY)
    private Set<PrivateSeries> series;

    public int getPrivateType() {
        return this.privateType;
    }

    public void setPrivateType(int privateType) {
        this.privateType = privateType;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public PrivatePatient getPatient() {
        return this.patient;
    }

    public void setPatient(PrivatePatient patient) {
        this.patient = patient;
    }

    public Set<PrivateSeries> getSeries() {
        return this.series;
    }

    public String toString() {
        return "PrivateStudy[pk=" + this.pk + ", uid=" + this.studyInstanceUID + ", accno=" + this.accessionNumber + "]";
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.studyInstanceUID = attrs.getString(0x20000D);
        this.accessionNumber = attrs.getString(524368);
        this.encodedAttributes = DicomObjectUtils.encode(attrs, null);
    }
}

