/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.PrivateInstance;
import org.dcm4chee.archive.entity.PrivateStudy;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="priv_series")
@NamedQuery(name="PrivateSeries.findByIUID", query="select object(pi) from PrivateSeries pi where seriesInstanceUID = :iuid")
public class PrivateSeries
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -8261618983812488376L;
    @Column(name="priv_type", nullable=false)
    private int privateType;
    @Column(name="series_iuid", nullable=false)
    private String seriesInstanceUID;
    @Column(name="src_aet")
    private String sourceAET;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="study_fk", nullable=false)
    private PrivateStudy study;
    @OneToMany(mappedBy="series", fetch=FetchType.LAZY)
    private Set<PrivateInstance> instances;

    public int getPrivateType() {
        return this.privateType;
    }

    public void setPrivateType(int privateType) {
        this.privateType = privateType;
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String getSourceAET() {
        return this.sourceAET;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public PrivateStudy getStudy() {
        return this.study;
    }

    public void setStudy(PrivateStudy study) {
        this.study = study;
    }

    public Set<PrivateInstance> getInstances() {
        return this.instances;
    }

    public String toString() {
        return "PrivateSeries[pk=" + this.pk + ", uid=" + this.seriesInstanceUID + ", srcaet=" + this.sourceAET + "]";
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.seriesInstanceUID = attrs.getString(0x20000E);
        this.sourceAET = attrs.getString(attrs.resolveTag(4390932, "dcm4che/archive"));
        this.encodedAttributes = DicomObjectUtils.encode(attrs, null);
    }
}

