/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.PersonName;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.PrivateStudy;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="priv_patient")
@NamedQuery(name="PrivatePatient.findByIdAndIssuer", query="select object(p) from PrivatePatient p where patientID = :patId and issuerOfPatientID = :issuer")
public class PrivatePatient
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 943058791913251357L;
    @Column(name="priv_type", nullable=false)
    private int privateType;
    @Column(name="pat_id")
    private String patientID;
    @Column(name="pat_id_issuer")
    private String issuerOfPatientID;
    @Column(name="pat_name")
    private String patientName;
    private byte[] encodedAttributes;
    @OneToMany(mappedBy="patient", fetch=FetchType.LAZY)
    private Set<PrivateStudy> studies;

    public int getPrivateType() {
        return this.privateType;
    }

    public void setPrivateType(int privateType) {
        this.privateType = privateType;
    }

    public String getPatientID() {
        return this.patientID;
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Set<PrivateStudy> getStudies() {
        return this.studies;
    }

    public void setStudies(Set<PrivateStudy> studies) {
        this.studies = studies;
    }

    public String toString() {
        return "PrivatePatient[pk=" + this.pk + ", pid=" + (this.issuerOfPatientID != null ? this.patientID + "^^^" + this.issuerOfPatientID : this.patientID) + ", name=" + this.patientName + "]";
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.patientID = attrs.getString(0x100020, "");
        this.issuerOfPatientID = attrs.getString(0x100021, "");
        PersonName pn = new PersonName(attrs.getString(0x100010));
        this.patientName = pn.componentGroupString(0, false).toUpperCase();
        this.encodedAttributes = DicomObjectUtils.encode(attrs, null);
    }
}

