/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.PrivateFile;
import org.dcm4chee.archive.entity.PrivateSeries;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="priv_instance")
public class PrivateInstance
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -7577387511052455446L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="priv_type", nullable=false)
    private int privateType;
    @Column(name="sop_iuid", nullable=false)
    private String sopInstanceUID;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="series_fk")
    private PrivateSeries series;
    @OneToMany(mappedBy="instance", fetch=FetchType.LAZY)
    private Set<PrivateFile> files;

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public int getPrivateType() {
        return this.privateType;
    }

    public void setPrivateType(int privateType) {
        this.privateType = privateType;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public PrivateSeries getSeries() {
        return this.series;
    }

    public void setSeries(PrivateSeries series) {
        this.series = series;
    }

    public Set<PrivateFile> getFiles() {
        return this.files;
    }

    public String toString() {
        return "PrivateInstance[pk=" + this.pk + ", uid=" + this.sopInstanceUID + "]";
    }

    @PrePersist
    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.sopInstanceUID = attrs.getString(524312);
        this.encodedAttributes = DicomObjectUtils.encode(attrs, "1.2.840.10008.1.2.1.99");
    }
}

