/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.PersonName;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.GPPPS;
import org.dcm4chee.archive.entity.GPSPS;
import org.dcm4chee.archive.entity.MPPS;
import org.dcm4chee.archive.entity.MWLItem;
import org.dcm4chee.archive.entity.OtherPatientID;
import org.dcm4chee.archive.entity.Study;
import org.dcm4chee.archive.entity.UPS;
import org.dcm4chee.archive.exceptions.ConfigurationException;
import org.dcm4chee.archive.util.DicomObjectUtils;
import org.hibernate.annotations.Cascade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="patient")
public class Patient
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -1348274766865261645L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="updated_time")
    private Date updatedTime;
    @Column(name="pat_id")
    private String patientID;
    @Column(name="pat_id_issuer")
    private String issuerOfPatientID;
    private String patientName;
    @Column(name="pat_fn_sx")
    private String patientFamilyNameSoundex;
    @Column(name="pat_gn_sx")
    private String patientGivenNameSoundex;
    private String patientIdeographicName;
    private String patientPhoneticName;
    @Column(name="pat_birthdate")
    private String patientBirthDate;
    @Column(name="pat_sex")
    private String patientSex;
    @Column(name="pat_custom1")
    private String patientCustomAttribute1;
    @Column(name="pat_custom2")
    private String patientCustomAttribute2;
    @Column(name="pat_custom3")
    private String patientCustomAttribute3;
    private byte[] encodedAttributes;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="rel_pat_other_pid", joinColumns={@JoinColumn(name="patient_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="other_pid_fk", referencedColumnName="pk")})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<OtherPatientID> otherPatientIDs;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="merge_fk")
    private Patient mergedWith;
    @OneToMany(mappedBy="mergedWith", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<Patient> previous;
    @OneToMany(mappedBy="patient", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<Study> studies;
    @OneToMany(mappedBy="patient", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<MWLItem> modalityWorklistItems;
    @OneToMany(mappedBy="patient", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<MPPS> modalityPerformedProcedureSteps;
    @OneToMany(mappedBy="patient", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<GPSPS> generalPurposeScheduledProcedureSteps;
    @OneToMany(mappedBy="patient", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<GPPPS> generalPurposePerformedProcedureSteps;
    @OneToMany(mappedBy="patient", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<UPS> unifiedProcedureSteps;

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getPatientID() {
        return this.patientID;
    }

    public void setPatientID(String patientID) {
        this.patientID = patientID;
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public void setIssuerOfPatientID(String issuer) {
        this.issuerOfPatientID = issuer;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public void setPatientName(String name) {
        this.patientName = name;
    }

    public String getPatientFamilyNameSoundex() {
        return this.patientFamilyNameSoundex;
    }

    public void setPatientFamilyNameSoundex(String patientFamilyNameSoundex) {
        this.patientFamilyNameSoundex = patientFamilyNameSoundex;
    }

    public String getPatientGivenNameSoundex() {
        return this.patientGivenNameSoundex;
    }

    public void setPatientGivenNameSoundex(String patientGivenNameSoundex) {
        this.patientGivenNameSoundex = patientGivenNameSoundex;
    }

    public String getPatientIdeographicName() {
        return this.patientIdeographicName;
    }

    public void setPatientIdeographicName(String name) {
        this.patientIdeographicName = name;
    }

    public String getPatientPhoneticName() {
        return this.patientPhoneticName;
    }

    public void setPatientPhoneticName(String name) {
        this.patientPhoneticName = name;
    }

    public String getPatientBirthDate() {
        return this.patientBirthDate;
    }

    public void setPatientBirthDate(String dob) {
        this.patientBirthDate = dob;
    }

    public String getPatientSex() {
        return this.patientSex;
    }

    public void setPatientSex(String patientSex) {
        this.patientSex = patientSex;
    }

    public String getPatientCustomAttribute1() {
        return this.patientCustomAttribute1;
    }

    public void setPatientCustomAttribute1(String attr) {
        this.patientCustomAttribute1 = attr;
    }

    public String getPatientCustomAttribute2() {
        return this.patientCustomAttribute2;
    }

    public void setPatientCustomAttribute2(String attr) {
        this.patientCustomAttribute2 = attr;
    }

    public String getPatientCustomAttribute3() {
        return this.patientCustomAttribute3;
    }

    public void setPatientCustomAttribute3(String attr) {
        this.patientCustomAttribute3 = attr;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Set<OtherPatientID> getOtherPatientIDs() {
        return this.otherPatientIDs;
    }

    public void setOtherPatientIDs(Set<OtherPatientID> otherPatientIDs) {
        this.otherPatientIDs = otherPatientIDs;
    }

    public Patient getMergedWith() {
        return this.mergedWith;
    }

    public void setMergedWith(Patient mergedWith) {
        this.mergedWith = mergedWith;
    }

    public Set<Patient> getPrevious() {
        return this.previous;
    }

    public void setPrevious(Set<Patient> previous) {
        this.previous = previous;
    }

    public Set<Study> getStudies() {
        return this.studies;
    }

    public void setStudies(Set<Study> studies) {
        this.studies = studies;
    }

    public Set<MWLItem> getModalityWorklistItems() {
        return this.modalityWorklistItems;
    }

    public void setModalityWorklistItems(Set<MWLItem> modalityWorklistItems) {
        this.modalityWorklistItems = modalityWorklistItems;
    }

    public Set<MPPS> getModalityPerformedProcedureSteps() {
        return this.modalityPerformedProcedureSteps;
    }

    public void setModalityPerformedProcedureSteps(Set<MPPS> mpps) {
        this.modalityPerformedProcedureSteps = mpps;
    }

    public Set<GPSPS> getGeneralPurposeScheduledProcedureSteps() {
        return this.generalPurposeScheduledProcedureSteps;
    }

    public void setGeneralPurposeScheduledProcedureSteps(Set<GPSPS> gpsps) {
        this.generalPurposeScheduledProcedureSteps = gpsps;
    }

    public Set<GPPPS> getGeneralPurposePerformedProcedureSteps() {
        return this.generalPurposePerformedProcedureSteps;
    }

    public void setGeneralPurposePerformedProcedureSteps(Set<GPPPS> gppps) {
        this.generalPurposePerformedProcedureSteps = gppps;
    }

    public Set<UPS> getUnifiedProcedureSteps() {
        return this.unifiedProcedureSteps;
    }

    public String toString() {
        return "Patient[pk=" + this.pk + ", pid=" + (this.issuerOfPatientID != null ? this.patientID + "^^^" + this.issuerOfPatientID : this.patientID) + ", name=" + this.patientName + ", birthdate=" + this.patientBirthDate + ", sex=" + this.patientSex + "]";
    }

    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.patientID = attrs.getString(0x100020, "");
        this.issuerOfPatientID = attrs.getString(0x100021, "");
        PersonName pn = new PersonName(attrs.getString(0x100010));
        this.patientName = pn.componentGroupString(0, false).toUpperCase();
        this.patientIdeographicName = pn.componentGroupString(1, false);
        this.patientPhoneticName = pn.componentGroupString(2, false);
        if (AttributeFilter.isSoundexEnabled()) {
            this.patientFamilyNameSoundex = AttributeFilter.toSoundex(pn, 0, "*");
            this.patientGivenNameSoundex = AttributeFilter.toSoundex(pn, 1, "*");
        }
        this.patientBirthDate = Patient.normalizeDA(attrs.getString(0x100030));
        this.patientSex = attrs.getString(0x100040, "");
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            try {
                this.setField(filter.getField(fieldTags[i]), attrs.getString(fieldTags[i], ""));
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        this.encodedAttributes = DicomObjectUtils.encode(filter.filter(attrs), filter.getTransferSyntaxUID());
    }

    private static String normalizeDA(String s) {
        if (s == null) {
            return null;
        }
        String trim = s.trim();
        int l = trim.length();
        if (l == 0) {
            return null;
        }
        if (l == 10 && trim.charAt(4) == '-' && trim.charAt(7) == '-') {
            StringBuilder sb = new StringBuilder(8);
            sb.append(trim.substring(0, 4));
            sb.append(trim.substring(5, 7));
            sb.append(trim.substring(8));
            return sb.toString();
        }
        return trim;
    }

    public OtherPatientID getOtherPatientIDForIssuer(String issuer) {
        if (this.otherPatientIDs == null || this.otherPatientIDs.size() == 0) {
            return null;
        }
        for (OtherPatientID opid : this.otherPatientIDs) {
            if (!issuer.equals(opid.getIssuerOfPatientID())) continue;
            return opid;
        }
        return null;
    }

    public String getPatientIDForIssuer(String issuer) {
        if (issuer == null || issuer.length() == 0) {
            return this.patientID;
        }
        if (this.issuerOfPatientID != null && this.issuerOfPatientID.equals(issuer)) {
            return this.patientID;
        }
        if (this.otherPatientIDs == null || this.otherPatientIDs.size() == 0) {
            return null;
        }
        for (OtherPatientID opid : this.otherPatientIDs) {
            if (!issuer.equals(opid.getIssuerOfPatientID())) continue;
            return opid.getPatientID();
        }
        return null;
    }

    private void setField(String field, String value) {
        try {
            Method m = Patient.class.getMethod("set" + Character.toUpperCase(field.charAt(0)) + field.substring(1), String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

