/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Patient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="other_pid")
@NamedQuery(name="OtherPatientID.findByPatientIdAndIssuer", query="select opid from OtherPatientID opid where patientID = :pid and issuerOfPatientID = :issuer")
public class OtherPatientID
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -7983218873187437331L;
    @Column(name="pat_id", nullable=false)
    private String patientID;
    @Column(name="pat_id_issuer", nullable=false)
    private String issuerOfPatientID;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_pat_other_pid", joinColumns={@JoinColumn(name="other_pid_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="patient_fk", referencedColumnName="pk")})
    private Set<Patient> patients;

    public String getPatientID() {
        return this.patientID;
    }

    public void setPatientID(String patientID) {
        this.patientID = patientID;
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public void setIssuerOfPatientID(String issuerOfPatientID) {
        this.issuerOfPatientID = issuerOfPatientID;
    }

    public Set<Patient> getPatients() {
        return this.patients;
    }

    public void setPatients(Set<Patient> patients) {
        this.patients = patients;
    }

    public String toString() {
        return this.issuerOfPatientID != null ? this.patientID + "^^^" + this.issuerOfPatientID : this.patientID;
    }

    public void setAttributes(DicomObject attrs) {
        this.patientID = attrs.getString(0x100020);
        this.issuerOfPatientID = attrs.getString(0x100021);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (int)(this.pk ^ this.pk >>> 32);
        hashCode = 31 * hashCode + (this.patientID == null ? 0 : this.patientID.hashCode());
        hashCode = 31 * hashCode + (this.issuerOfPatientID == null ? 0 : this.issuerOfPatientID.hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        OtherPatientID castedObj = (OtherPatientID)o;
        return this.pk == castedObj.pk && (this.patientID == null ? castedObj.patientID == null : this.patientID.equals(castedObj.patientID)) && (this.issuerOfPatientID == null ? castedObj.issuerOfPatientID == null : this.issuerOfPatientID.equals(castedObj.issuerOfPatientID));
    }
}

