/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.PersonName;
import org.dcm4chee.archive.common.SPSStatus;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.util.DicomObjectUtils;

@Entity
@Table(name="mwl_item")
public class MWLItem
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 5655030469102270878L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="updated_time")
    private Date updatedTime;
    @Column(name="sps_id")
    private String scheduledProcedureStepID;
    @Column(name="req_proc_id", nullable=false)
    private String requestedProcedureID;
    @Column(name="study_iuid", nullable=false)
    private String studyInstanceUID;
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="modality", nullable=false)
    private String modality;
    @Column(name="station_aet", nullable=false)
    private String scheduledStationAET;
    @Column(name="station_name")
    private String scheduledStationName;
    @Column(name="start_datetime", nullable=false)
    private Date startDateTime;
    private String scheduledPerformingPhysicianName;
    @Column(name="perf_phys_fn_sx")
    private String scheduledPerformingFamilyNameSoundex;
    @Column(name="perf_phys_gn_sx")
    private String scheduledPerformingGivenNameSoundex;
    private String scheduledPerformingPhysicianIdeographicName;
    private String scheduledPerformingPhysicianPhoneticName;
    @Column(name="sps_status")
    private SPSStatus status;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="patient_fk")
    private Patient patient;

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getScheduledProcedureStepID() {
        return this.scheduledProcedureStepID;
    }

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public String getModality() {
        return this.modality;
    }

    public String getScheduledStationAET() {
        return this.scheduledStationAET;
    }

    public String getScheduledStationName() {
        return this.scheduledStationName;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public String getScheduledPerformingPhysicianName() {
        return this.scheduledPerformingPhysicianName;
    }

    public String getScheduledPerformingFamilyNameSoundex() {
        return this.scheduledPerformingFamilyNameSoundex;
    }

    public void setScheduledPerformingFamilyNameSoundex(String scheduledPerformingFamilyNameSoundex) {
        this.scheduledPerformingFamilyNameSoundex = scheduledPerformingFamilyNameSoundex;
    }

    public String getScheduledPerformingGivenNameSoundex() {
        return this.scheduledPerformingGivenNameSoundex;
    }

    public void setScheduledPerformingGivenNameSoundex(String scheduledPerformingGivenNameSoundex) {
        this.scheduledPerformingGivenNameSoundex = scheduledPerformingGivenNameSoundex;
    }

    public String getScheduledPerformingPhysicianIdeographicName() {
        return this.scheduledPerformingPhysicianIdeographicName;
    }

    public String getScheduledPerformingPhysicianPhoneticName() {
        return this.scheduledPerformingPhysicianPhoneticName;
    }

    public SPSStatus getStatus() {
        return this.status;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public String toString() {
        return "MWLItem[pk=" + this.pk + ", spsid=" + this.scheduledProcedureStepID + ", rpid=" + this.requestedProcedureID + ", suid=" + this.studyInstanceUID + ", accno=" + this.accessionNumber + ", modality=" + this.modality + ", aet=" + this.scheduledStationAET + ", station=" + this.scheduledStationName + ", performer=" + this.scheduledPerformingPhysicianName + ", start=" + this.startDateTime + ", status=" + (Object)((Object)this.status) + "]";
    }

    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        String status;
        DicomObject spsItem = attrs.getNestedDicomObject(0x400100);
        if (spsItem == null) {
            throw new IllegalArgumentException("Missing Scheduled Procedure Step Sequence (0040,0100) Item");
        }
        this.scheduledProcedureStepID = spsItem.getString(0x400009);
        this.requestedProcedureID = attrs.getString(0x401001);
        this.studyInstanceUID = attrs.getString(0x20000D);
        this.accessionNumber = attrs.getString(524368);
        this.scheduledStationAET = spsItem.getString(0x400001);
        this.scheduledStationName = spsItem.getString(0x400010, "");
        this.modality = spsItem.getString(524384);
        this.startDateTime = spsItem.getDate(0x400002, 0x400003);
        PersonName pn = new PersonName(attrs.getString(0x400006));
        this.scheduledPerformingPhysicianName = pn.componentGroupString(0, false).toUpperCase();
        this.scheduledPerformingPhysicianIdeographicName = pn.componentGroupString(1, false);
        this.scheduledPerformingPhysicianPhoneticName = pn.componentGroupString(2, false);
        if (AttributeFilter.isSoundexEnabled()) {
            this.scheduledPerformingFamilyNameSoundex = AttributeFilter.toSoundex(pn, 0, "*");
            this.scheduledPerformingGivenNameSoundex = AttributeFilter.toSoundex(pn, 1, "*");
        }
        if ((status = spsItem.getString(0x400020)) != null) {
            this.status = SPSStatus.valueOf(status);
        }
        this.encodedAttributes = DicomObjectUtils.encode(AttributeFilter.getExcludePatientAttributeFilter().filter(attrs), "1.2.840.10008.1.2.1.99");
    }
}

