/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.common.PPSStatus;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.entity.Series;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="mpps")
public class MPPS
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -599495313070741738L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="updated_time")
    private Date updatedTime;
    @Column(name="mpps_iuid", unique=true, nullable=false)
    private String sopInstanceUID;
    @Column(name="pps_start")
    private Date startDateTime;
    @Column(name="station_aet")
    private String performedStationAET;
    @Column(name="modality")
    private String modality;
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="mpps_status", nullable=false)
    private PPSStatus status;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="drcode_fk")
    private Code discontinuationReasonCode;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="patient_fk")
    private Patient patient;
    @OneToMany(mappedBy="modalityPerformedProcedureStep", fetch=FetchType.LAZY)
    private Set<Series> series;

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public String getPerformedStationAET() {
        return this.performedStationAET;
    }

    public String getModality() {
        return this.modality;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public PPSStatus getStatus() {
        return this.status;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Code getDiscontinuationReasonCode() {
        return this.discontinuationReasonCode;
    }

    public void setDiscontinuationReasonCode(Code discontinuationReasonCode) {
        this.discontinuationReasonCode = discontinuationReasonCode;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public Set<Series> getSeries() {
        return this.series;
    }

    public void setSeries(Set<Series> series) {
        this.series = series;
    }

    public String toString() {
        return "MPPS[pk=" + this.pk + ", iuid=" + this.sopInstanceUID + ", status=" + (Object)((Object)this.status) + ", accno=" + this.accessionNumber + ", start=" + this.startDateTime + ", mod=" + this.modality + ", aet=" + this.performedStationAET + "]";
    }

    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.sopInstanceUID = attrs.getString(524312);
        this.startDateTime = attrs.getDate(0x400244, 4194885);
        this.performedStationAET = attrs.getString(4194881);
        this.modality = attrs.getString(524384);
        this.accessionNumber = attrs.getString(new int[]{4194928, 0, 524368});
        if (this.accessionNumber == null) {
            this.accessionNumber = attrs.getString(524368);
        }
        this.status = PPSStatus.valueOf(attrs.getString(4194898).replace(' ', '_'));
        this.encodedAttributes = DicomObjectUtils.encode(AttributeFilter.getExcludePatientAttributeFilter().filter(attrs), "1.2.840.10008.1.2.1.99");
    }
}

