/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.common.Availability;
import org.dcm4chee.archive.common.StorageStatus;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.ContentItem;
import org.dcm4chee.archive.entity.File;
import org.dcm4chee.archive.entity.Media;
import org.dcm4chee.archive.entity.Series;
import org.dcm4chee.archive.entity.VerifyingObserver;
import org.dcm4chee.archive.exceptions.ConfigurationException;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="instance")
@NamedQuery(name="Instance.findByIUID", query="select object(i) from Instance i where sopInstanceUID = :iuid")
public class Instance
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -924140016923828861L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="updated_time")
    private Date updatedTime;
    @Column(name="sop_iuid", nullable=false)
    private String sopInstanceUID;
    @Column(name="sop_cuid", nullable=false)
    private String sopClassUID;
    @Column(name="inst_no")
    private String instanceNumber;
    @Column(name="content_datetime")
    private Date contentDateTime;
    @Column(name="sr_complete")
    private String completionFlag;
    @Column(name="sr_verified")
    private String verificationFlag;
    @Column(name="inst_custom1")
    private String instanceCustomAttribute1;
    @Column(name="inst_custom2")
    private String instanceCustomAttribute2;
    @Column(name="inst_custom3")
    private String instanceCustomAttribute3;
    private byte[] encodedAttributes;
    @Column(name="retrieve_aets")
    private String retrieveAETs;
    @Column(name="ext_retr_aet")
    private String externalRetrieveAET;
    @Column(name="availability", nullable=false)
    private Availability availability;
    @Column(name="inst_status", nullable=false)
    private StorageStatus storageStatus;
    @Column(name="archived", nullable=false)
    private boolean archived;
    @Column(name="all_attrs", nullable=false)
    private boolean allAttributes;
    @Column(name="commitment", nullable=false)
    private boolean storageComitted;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="srcode_fk")
    private Code conceptNameCode;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinColumn(name="media_fk")
    private Media media;
    @OneToMany(mappedBy="instance", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<VerifyingObserver> verifyingObservers;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="series_fk")
    private Series series;
    @OneToMany(mappedBy="instance", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private List<File> files;
    @OneToMany(mappedBy="instance", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<ContentItem> contentItems;

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public Date getContentDateTime() {
        return this.contentDateTime;
    }

    public String getCompletionFlag() {
        return this.completionFlag;
    }

    public String getVerificationFlag() {
        return this.verificationFlag;
    }

    public String getInstanceCustomAttribute1() {
        return this.instanceCustomAttribute1;
    }

    public void setInstanceCustomAttribute1(String value) {
        this.instanceCustomAttribute1 = value;
    }

    public String getInstanceCustomAttribute2() {
        return this.instanceCustomAttribute2;
    }

    public void setInstanceCustomAttribute2(String value) {
        this.instanceCustomAttribute2 = value;
    }

    public String getInstanceCustomAttribute3() {
        return this.instanceCustomAttribute3;
    }

    public void setInstanceCustomAttribute3(String value) {
        this.instanceCustomAttribute3 = value;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public String getRetrieveAETs() {
        return this.retrieveAETs;
    }

    public void setRetrieveAETs(String retrieveAETs) {
        this.retrieveAETs = retrieveAETs;
    }

    public String getExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public void setExternalRetrieveAET(String externalRetrieveAET) {
        this.externalRetrieveAET = externalRetrieveAET;
    }

    public Availability getAvailability() {
        return this.availability;
    }

    public void setAvailability(Availability availability) {
        this.availability = availability;
    }

    public StorageStatus getStorageStatus() {
        return this.storageStatus;
    }

    public void setStorageStatus(StorageStatus storageStatus) {
        this.storageStatus = storageStatus;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public boolean isAllAttributes() {
        return this.allAttributes;
    }

    public void setAllAttributes(boolean allAttributes) {
        this.allAttributes = allAttributes;
    }

    public boolean isStorageComitted() {
        return this.storageComitted;
    }

    public void setStorageComitted(boolean storageComitted) {
        this.storageComitted = storageComitted;
    }

    public Code getConceptNameCode() {
        return this.conceptNameCode;
    }

    public void setConceptNameCode(Code conceptNameCode) {
        this.conceptNameCode = conceptNameCode;
    }

    public Media getMedia() {
        return this.media;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public Set<VerifyingObserver> getVerifyingObservers() {
        return this.verifyingObservers;
    }

    public void setVerifyingObservers(Set<VerifyingObserver> verifyingObservers) {
        this.verifyingObservers = verifyingObservers;
    }

    public Series getSeries() {
        return this.series;
    }

    public void setSeries(Series series) {
        this.series = series;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public Set<ContentItem> getContentItems() {
        return this.contentItems;
    }

    public String toString() {
        return "Instance[pk=" + this.pk + ", iuid=" + this.sopInstanceUID + ", cuid=" + this.sopClassUID + ", instno=" + this.instanceNumber + ", time=" + this.contentDateTime + (this.completionFlag != null ? ", completion=" + this.completionFlag : "") + (this.verificationFlag != null ? ", verification=" + this.verificationFlag : "") + ", allattrs=" + this.allAttributes + ", comitted=" + this.storageComitted + ", status=" + (Object)((Object)this.storageStatus) + ", avail=" + (Object)((Object)this.availability) + ", aets=" + this.retrieveAETs + ", extaet=" + this.externalRetrieveAET + "]";
    }

    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public DicomObject getAttributes(boolean cfindrsp) {
        DicomObject dataset = DicomObjectUtils.decode(this.encodedAttributes);
        if (cfindrsp) {
            if (this.media != null) {
                dataset.putString(8913216, VR.UI, this.media.getFileSetUID());
                dataset.putString(8913200, VR.SH, this.media.getFileSetID());
            }
            if (this.retrieveAETs != null || this.externalRetrieveAET != null) {
                dataset.putString(524372, VR.AE, this.externalRetrieveAET == null ? this.retrieveAETs : (this.retrieveAETs == null ? this.externalRetrieveAET : this.retrieveAETs + '\\' + this.externalRetrieveAET));
            }
            dataset.putString(524374, VR.CS, this.availability.name());
        }
        return dataset;
    }

    public void setAttributes(DicomObject attrs) {
        this.sopInstanceUID = attrs.getString(524312);
        this.sopClassUID = attrs.getString(524310);
        this.instanceNumber = attrs.getString(2097171, "");
        this.contentDateTime = attrs.getDate(524323, 524339);
        this.completionFlag = attrs.getString(4236433, "");
        this.verificationFlag = attrs.getString(4236435, "");
        AttributeFilter filter = AttributeFilter.getInstanceAttributeFilter(this.sopClassUID);
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            try {
                this.setField(filter.getField(fieldTags[i]), attrs.getString(fieldTags[i], ""));
                continue;
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        this.encodedAttributes = DicomObjectUtils.encode(filter.filter(attrs), filter.getTransferSyntaxUID());
    }

    private void setField(String field, String value) {
        try {
            Method m = Instance.class.getMethod("set" + Character.toUpperCase(field.charAt(0)) + field.substring(1), String.class);
            m.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }
}

