/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.common.HangingProtocolLevel;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.HPDefinition;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="hp")
public class HangingProtocol
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -450985503561915871L;
    @Column(name="hp_iuid", nullable=false)
    private String sopInstanceUID;
    @Column(name="hp_cuid")
    private String sopClassUID;
    private String name;
    @Column(name="hp_level")
    private HangingProtocolLevel level;
    @Column(name="num_priors")
    private int numberOfPriorsReferenced;
    private String userGroupName;
    @Column(name="num_screens")
    private int numberOfScreens;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="user_fk")
    private Code userIDCode;
    @OneToMany(mappedBy="hangingProtocol", fetch=FetchType.LAZY)
    private Set<HPDefinition> definitions;

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getName() {
        return this.name;
    }

    public HangingProtocolLevel getLevel() {
        return this.level;
    }

    public int getNumberOfPriorsReferenced() {
        return this.numberOfPriorsReferenced;
    }

    public String getUserGroupName() {
        return this.userGroupName;
    }

    public int getNumberOfScreens() {
        return this.numberOfScreens;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Code getUserIDCode() {
        return this.userIDCode;
    }

    public void setUserIDCode(Code userIDCode) {
        this.userIDCode = userIDCode;
    }

    public Set<HPDefinition> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Set<HPDefinition> definitions) {
        this.definitions = definitions;
    }

    public String toString() {
        return "HangingProtocol[pk=" + this.pk + ", iuid=" + this.sopInstanceUID + ", cuid=" + this.sopClassUID + ", name=" + this.name + ", level=" + (Object)((Object)this.level) + ", userGroupName=" + this.userGroupName + ", priors=" + this.numberOfPriorsReferenced + ", screens=" + this.numberOfScreens + "]";
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.sopInstanceUID = attrs.getString(524312);
        this.sopClassUID = attrs.getString(524310);
        this.name = attrs.getString(0x720002);
        this.level = HangingProtocolLevel.valueOf(attrs.getString(7471110));
        this.numberOfPriorsReferenced = attrs.getInt(7471124);
        this.userGroupName = attrs.getString(7471120);
        this.numberOfScreens = attrs.getInt(7471360);
        this.encodedAttributes = DicomObjectUtils.encode(attrs, "1.2.840.10008.1.2.1.99");
    }
}

