/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.HangingProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="hpdef")
public class HPDefinition
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 608638906765588946L;
    @Column(name="modality")
    private String modality;
    @Column(name="laterality")
    private String laterality;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_hpdef_region", joinColumns={@JoinColumn(name="hpdef_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="region_fk", referencedColumnName="pk")})
    private Set<Code> anatomicRegionCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_hpdef_proc", joinColumns={@JoinColumn(name="hpdef_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="proc_fk", referencedColumnName="pk")})
    private Set<Code> procedureCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_hpdef_reason", joinColumns={@JoinColumn(name="hpdef_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="reason_fk", referencedColumnName="pk")})
    private Set<Code> reasonforRequestedCodes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="hp_fk")
    private HangingProtocol hangingProtocol;

    public String getModality() {
        return this.modality;
    }

    public String getLaterality() {
        return this.laterality;
    }

    public Set<Code> getAnatomicRegionCodes() {
        return this.anatomicRegionCodes;
    }

    public void setAnatomicRegionCodes(Set<Code> anatomicRegionCodes) {
        this.anatomicRegionCodes = anatomicRegionCodes;
    }

    public Set<Code> getProcedureCodes() {
        return this.procedureCodes;
    }

    public void setProcedureCodes(Set<Code> procedureCodes) {
        this.procedureCodes = procedureCodes;
    }

    public Set<Code> getReasonforRequestedCodes() {
        return this.reasonforRequestedCodes;
    }

    public void setReasonforRequestedCodes(Set<Code> reasonforRequestedCodes) {
        this.reasonforRequestedCodes = reasonforRequestedCodes;
    }

    public HangingProtocol getHangingProtocol() {
        return this.hangingProtocol;
    }

    public void setHangingProtocol(HangingProtocol hangingProtocol) {
        this.hangingProtocol = hangingProtocol;
    }

    public String toString() {
        return "HPDefinition[pk=" + this.pk + ", modality=" + this.modality + ", laterality=" + this.laterality + "]" + this.hangingProtocol;
    }

    public void setAttributes(DicomObject attrs) {
        this.modality = attrs.getString(524384);
        this.laterality = attrs.getString(0x200060);
    }
}

