/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.PersonName;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.GPSPS;

@Entity
@Table(name="gpsps_perf")
public class GPSPSPerformer
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -7557539606659982634L;
    private String humanPerformerName;
    @Column(name="hum_perf_fn_sx")
    private String humanPerformerFamilyNameSoundex;
    @Column(name="hum_perf_gn_sx")
    private String humanPerformerGivenNameSoundex;
    private String humanPerformerIdeographicName;
    private String humanPerformerPhoneticName;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="gpsps_fk")
    private GPSPS gpsps;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="code_fk")
    private Code code;

    public String getHumanPerformerName() {
        return this.humanPerformerName;
    }

    public String getHumanPerformerFamilyNameSoundex() {
        return this.humanPerformerFamilyNameSoundex;
    }

    public void setHumanPerformerFamilyNameSoundex(String humanPerformerFamilyNameSoundex) {
        this.humanPerformerFamilyNameSoundex = humanPerformerFamilyNameSoundex;
    }

    public String getHumanPerformerGivenNameSoundex() {
        return this.humanPerformerGivenNameSoundex;
    }

    public void setHumanPerformerGivenNameSoundex(String humanPerformerGivenNameSoundex) {
        this.humanPerformerGivenNameSoundex = humanPerformerGivenNameSoundex;
    }

    public String getHumanPerformerIdeographicName() {
        return this.humanPerformerIdeographicName;
    }

    public String getHumanPerformerPhoneticName() {
        return this.humanPerformerPhoneticName;
    }

    public GPSPS getGpsps() {
        return this.gpsps;
    }

    public void setGpsps(GPSPS gpsps) {
        this.gpsps = gpsps;
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
    }

    public String toString() {
        return "GPSPSPerformer[pk=" + this.getPk() + ", name=" + this.humanPerformerName + ", code=" + this.code + "]";
    }

    public void setAttributes(DicomObject attrs) {
        PersonName pn = new PersonName(attrs.getString(4210743));
        this.humanPerformerName = pn.componentGroupString(0, false).toUpperCase();
        this.humanPerformerIdeographicName = pn.componentGroupString(1, false);
        this.humanPerformerPhoneticName = pn.componentGroupString(2, false);
        if (AttributeFilter.isSoundexEnabled()) {
            this.humanPerformerFamilyNameSoundex = AttributeFilter.toSoundex(pn, 0, "*");
            this.humanPerformerGivenNameSoundex = AttributeFilter.toSoundex(pn, 1, "*");
        }
    }
}

