/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.common.GPSPSPriority;
import org.dcm4chee.archive.common.GPSPSStatus;
import org.dcm4chee.archive.common.InputAvailabilityFlag;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.archive.entity.GPPPS;
import org.dcm4chee.archive.entity.GPSPSPerformer;
import org.dcm4chee.archive.entity.GPSPSRequest;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="gpsps")
public class GPSPS
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 4800913651614346013L;
    @Column(name="gpsps_iuid", nullable=false)
    private String sopInstanceUID;
    @Column(name="gpsps_tuid")
    private String transactionUID;
    @Column(name="start_datetime", nullable=false)
    private Date startDateTime;
    @Column(name="end_datetime")
    private Date expectedCompletionDateTime;
    @Column(name="gpsps_status")
    private GPSPSStatus status;
    @Column(name="gpsps_prior")
    private GPSPSPriority priority;
    @Column(name="in_availability")
    private InputAvailabilityFlag inputAvailability;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="patient_fk")
    private Patient patient;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="code_fk")
    private Code scheduledWorkItemCode;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_gpsps_appcode", joinColumns={@JoinColumn(name="appcode_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="gpsps_fk", referencedColumnName="pk")})
    private Set<Code> scheduledProcessingApplicationsCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_gpsps_devname", joinColumns={@JoinColumn(name="devname_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="gpsps_fk", referencedColumnName="pk")})
    private Set<Code> scheduledStationNameCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_gpsps_devclass", joinColumns={@JoinColumn(name="devclass_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="gpsps_fk", referencedColumnName="pk")})
    private Set<Code> scheduledStationClassCodes;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="rel_gpsps_devloc", joinColumns={@JoinColumn(name="devloc_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="gpsps_fk", referencedColumnName="pk")})
    private Set<Code> scheduledStationGeographicLocationCodes;
    @OneToMany(mappedBy="gpsps", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<GPSPSRequest> referencedRequests;
    @OneToMany(mappedBy="gpsps", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<GPSPSPerformer> scheduledHumanPerformers;
    @ManyToMany(mappedBy="scheduledProcedureSteps", fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    private Set<GPPPS> performedProcedureSteps;

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getTransactionUID() {
        return this.transactionUID;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public Date getExpectedCompletionDateTime() {
        return this.expectedCompletionDateTime;
    }

    public GPSPSStatus getStatus() {
        return this.status;
    }

    public GPSPSPriority getPriority() {
        return this.priority;
    }

    public InputAvailabilityFlag getInputAvailability() {
        return this.inputAvailability;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public Code getScheduledWorkItemCode() {
        return this.scheduledWorkItemCode;
    }

    public void setScheduledWorkItemCode(Code scheduledWorkItemCode) {
        this.scheduledWorkItemCode = scheduledWorkItemCode;
    }

    public Set<Code> getScheduledProcessingApplicationsCodes() {
        return this.scheduledProcessingApplicationsCodes;
    }

    public void setScheduledProcessingApplicationsCodes(Set<Code> scheduledProcessingApplicationsCodes) {
        this.scheduledProcessingApplicationsCodes = scheduledProcessingApplicationsCodes;
    }

    public Set<Code> getScheduledStationNameCodes() {
        return this.scheduledStationNameCodes;
    }

    public void setScheduledStationNameCodes(Set<Code> scheduledStationNameCodes) {
        this.scheduledStationNameCodes = scheduledStationNameCodes;
    }

    public Set<Code> getScheduledStationClassCodes() {
        return this.scheduledStationClassCodes;
    }

    public void setScheduledStationClassCodes(Set<Code> codes) {
        this.scheduledStationClassCodes = codes;
    }

    public Set<Code> getScheduledStationGeographicLocationCodes() {
        return this.scheduledStationGeographicLocationCodes;
    }

    public void setScheduledStationGeographicLocationCodes(Set<Code> codes) {
        this.scheduledStationGeographicLocationCodes = codes;
    }

    public Set<GPSPSRequest> getReferencedRequests() {
        return this.referencedRequests;
    }

    public void setReferencedRequests(Set<GPSPSRequest> referencedRequests) {
        this.referencedRequests = referencedRequests;
    }

    public Set<GPSPSPerformer> getScheduledHumanPerformers() {
        return this.scheduledHumanPerformers;
    }

    public void setScheduledHumanPerformers(Set<GPSPSPerformer> scheduledHumanPerformers) {
        this.scheduledHumanPerformers = scheduledHumanPerformers;
    }

    public Set<GPPPS> getPerformedProcedureSteps() {
        return this.performedProcedureSteps;
    }

    public String toString() {
        return "GPSPS[pk=" + this.pk + ", iuid=" + this.sopInstanceUID + ", transuid=" + this.transactionUID + ", status=" + (Object)((Object)this.status) + ", start=" + this.startDateTime + ", complete=" + this.expectedCompletionDateTime + ", priority=" + (Object)((Object)this.priority) + ", input=" + (Object)((Object)this.inputAvailability) + "]";
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.sopInstanceUID = attrs.getString(524312);
        this.startDateTime = attrs.getDate(0x404005);
        this.expectedCompletionDateTime = attrs.getDate(0x404011);
        this.status = GPSPSStatus.valueOf(attrs.getString(0x404001).replace(' ', '_'));
        this.priority = GPSPSPriority.valueOf(attrs.getString(0x404003));
        this.inputAvailability = InputAvailabilityFlag.valueOf(attrs.getString(0x404020));
        this.encodedAttributes = DicomObjectUtils.encode(AttributeFilter.getExcludePatientAttributeFilter().filter(attrs), "1.2.840.10008.1.2.1.99");
    }
}

