/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.common.PPSStatus;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.GPSPS;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.util.DicomObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="gppps")
public class GPPPS
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 5358842743055077420L;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="updated_time")
    private Date updatedTime;
    @Column(name="pps_iuid", nullable=false)
    private String sopInstanceUID;
    @Column(name="pps_start")
    private Date startDateTime;
    @Column(name="pps_status", nullable=false)
    private PPSStatus status;
    private byte[] encodedAttributes;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="patient_fk")
    private Patient patient;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE})
    @JoinTable(name="rel_gpsps_gppps", joinColumns={@JoinColumn(name="gppps_fk", referencedColumnName="pk")}, inverseJoinColumns={@JoinColumn(name="gpsps_fk", referencedColumnName="pk")})
    private Set<GPSPS> scheduledProcedureSteps;

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public PPSStatus getStatus() {
        return this.status;
    }

    public byte[] getEncodedAttributes() {
        return this.encodedAttributes;
    }

    public Set<GPSPS> getScheduledProcedureSteps() {
        return this.scheduledProcedureSteps;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public String toString() {
        return "GPPPS[pk=" + this.pk + ", uid=" + this.sopInstanceUID + ", start=" + this.startDateTime + ", status=" + (Object)((Object)this.status) + "]";
    }

    public void onPrePersist() {
        this.createdTime = new Date();
    }

    public void onPreUpdate() {
        this.updatedTime = new Date();
    }

    public DicomObject getAttributes() {
        return DicomObjectUtils.decode(this.encodedAttributes);
    }

    public void setAttributes(DicomObject attrs) {
        this.sopInstanceUID = attrs.getString(524312);
        this.startDateTime = attrs.getDate(0x400244, 4194885);
        this.status = PPSStatus.valueOf(attrs.getString(0x404002).replace(' ', '_'));
        this.encodedAttributes = DicomObjectUtils.encode(AttributeFilter.getExcludePatientAttributeFilter().filter(attrs), "1.2.840.10008.1.2.1.99");
    }
}

