/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.entity.BaseEntity;

@Entity
@Table(name="code")
public class Code
extends BaseEntity
implements Serializable {
    private static final String NOT_A_CODE_STRING = "Not a Code String! '(<code_value>, <code_scheme_designator>[;<code_scheme_version],<code_meaning>):";
    private static final long serialVersionUID = 3626021926959276349L;
    @Column(name="code_value", nullable=false)
    private String codeValue;
    @Column(name="code_designator", nullable=false)
    private String codingSchemeDesignator;
    @Column(name="code_version")
    private String codingSchemeVersion;
    private String codeMeaning;

    public Code() {
    }

    public Code(String c) {
        int pos2;
        int pos1 = c.indexOf(44);
        int posEnd = c.lastIndexOf(41);
        if (c.charAt(0) != '(' || posEnd == -1 || pos1 == -1 || pos1 > posEnd) {
            throw new IllegalArgumentException(NOT_A_CODE_STRING + c);
        }
        this.codeValue = c.substring(1, pos1).trim();
        if ((pos2 = c.indexOf(44, ++pos1)) == -1) {
            throw new IllegalArgumentException(NOT_A_CODE_STRING + c);
        }
        int pos3 = c.indexOf(59, pos1);
        if (pos3 == -1) {
            this.codingSchemeDesignator = c.substring(pos1, pos2).trim();
            this.codingSchemeVersion = null;
        } else {
            this.codingSchemeDesignator = c.substring(pos1, pos3).trim();
            this.codingSchemeVersion = c.substring(++pos3, pos2).trim();
        }
        pos2 = c.indexOf(34, pos2);
        if (pos2 == -1) {
            throw new IllegalArgumentException(NOT_A_CODE_STRING + c);
        }
        posEnd = c.lastIndexOf(34);
        if (posEnd < ++pos2) {
            throw new IllegalArgumentException(NOT_A_CODE_STRING + c);
        }
        this.codeMeaning = c.substring(pos2, posEnd).trim();
    }

    public Code(DicomObject codeItem) {
        this.codeValue = codeItem.getString(524544);
        this.codingSchemeDesignator = codeItem.getString(524546);
        this.codingSchemeVersion = codeItem.getString(524547);
        this.codeMeaning = codeItem.getString(524548);
    }

    public String getCodeValue() {
        return this.codeValue;
    }

    public String getCodingSchemeDesignator() {
        return this.codingSchemeDesignator;
    }

    public String getCodingSchemeVersion() {
        return this.codingSchemeVersion;
    }

    public String getCodeMeaning() {
        return this.codeMeaning;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('(').append(this.codeValue).append(", ").append(this.codingSchemeDesignator);
        if (this.codingSchemeVersion != null) {
            sb.append(';').append(this.codingSchemeVersion);
        }
        sb.append(", \"").append(this.codeMeaning).append("\")");
        return sb.toString();
    }

    public void setAttributes(DicomObject attrs) {
        this.codeValue = attrs.getString(524544);
        this.codingSchemeDesignator = attrs.getString(524546);
        this.codingSchemeVersion = attrs.getString(524547);
        this.codeMeaning = attrs.getString(524548);
    }

    public DicomObject toCodeItem() {
        BasicDicomObject codeItem = new BasicDicomObject();
        codeItem.putString(524544, VR.SH, this.getCodeValue());
        codeItem.putString(524546, VR.SH, this.getCodingSchemeDesignator());
        if (this.getCodingSchemeVersion() != null) {
            codeItem.putString(524547, VR.SH, this.getCodingSchemeVersion());
        }
        codeItem.putString(524548, VR.LO, this.getCodeMeaning());
        return codeItem;
    }
}

