/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.dcm4chee.archive.entity.BaseEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ae")
@NamedQuery(name="AE.findByTitle", query="select ae from AE ae where title = :title")
public class AE
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -3132017392325052134L;
    @Column(name="aet", nullable=false)
    private String title;
    @Column(name="hostname", nullable=false)
    private String hostName;
    @Column(name="port", nullable=false)
    private int port = 11112;
    @Column(name="cipher_suites")
    private String cipherSuites;
    @Column(name="pat_id_issuer")
    private String issuerOfPatientID;
    @Column(name="acc_no_issuer")
    private String issuerOfAccessionNumber;
    @Column(name="user_id")
    private String userID;
    @Column(name="passwd")
    private String password;
    @Column(name="fs_group_id")
    private String fileSystemGroupID;
    @Column(name="ae_desc")
    private String description;
    @Column(name="station_name")
    private String stationName;
    @Column(name="institution")
    private String institution;
    @Column(name="department")
    private String department;
    @Column(name="installed")
    private boolean installed;
    @Column(name="wado_url")
    private String wadoURL;
    @Column(name="ae_group")
    private String aeGroup;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public List<String> getCipherSuites() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.cipherSuites != null && this.cipherSuites.trim().length() > 0) {
            int pos0 = 0;
            for (int i = 0; i < 3; ++i) {
                int pos1 = this.cipherSuites.indexOf(44, pos0);
                if (pos1 == -1) {
                    l.add(this.cipherSuites.substring(pos0));
                    break;
                }
                l.add(this.cipherSuites.substring(pos0, pos1));
                pos0 = ++pos1;
            }
        }
        return l;
    }

    public void setCipherSuites(List<String> suites) {
        StringBuilder sb = new StringBuilder();
        for (String s : suites) {
            if (s == null) continue;
            sb.append(s).append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            this.cipherSuites = sb.toString();
        } else {
            this.cipherSuites = null;
        }
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public void setIssuerOfPatientID(String issuerOfPatientID) {
        this.issuerOfPatientID = issuerOfPatientID;
    }

    public String getIssuerOfAccessionNumber() {
        return this.issuerOfAccessionNumber;
    }

    public void setIssuerOfAccessionNumber(String issuer) {
        this.issuerOfAccessionNumber = issuer;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFileSystemGroupID() {
        return this.fileSystemGroupID;
    }

    public void setFileSystemGroupID(String fileSystemGroupID) {
        this.fileSystemGroupID = fileSystemGroupID;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setWadoURL(String wadoURL) {
        this.wadoURL = wadoURL;
    }

    public String getWadoURL() {
        return this.wadoURL;
    }

    public void setAeGroup(String aeGroup) {
        this.aeGroup = aeGroup;
    }

    public String getAeGroup() {
        return this.aeGroup;
    }

    public String getStationName() {
        return this.stationName;
    }

    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public String toString() {
        return this.getProtocol() + "://" + this.title + '@' + this.hostName + ':' + this.port;
    }

    private String getProtocol() {
        if (this.cipherSuites == null || this.cipherSuites.length() == 0) {
            return "dicom";
        }
        if ("SSL_RSA_WITH_NULL_SHA".equals(this.cipherSuites)) {
            return "dicom-tls.nodes";
        }
        if ("SSL_RSA_WITH_3DES_EDE_CBC_SHA".equals(this.cipherSuites)) {
            return "dicom-tls.3des";
        }
        if ("TLS_RSA_WITH_AES_128_CBC_SHA,SSL_RSA_WITH_3DES_EDE_CBC_SHA".equals(this.cipherSuites)) {
            return "dicom-tls.aes";
        }
        return "dicom-tls";
    }
}

