/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.license.ae;

import java.io.Serializable;
import java.util.List;
import java.util.ServiceLoader;
import org.dcm4chee.web.common.license.ae.spi.AELicenseProviderSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AELicenseProviderManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AELicenseProviderSPI provider;
    private static Logger log = LoggerFactory.getLogger(AELicenseProviderManager.class);

    private AELicenseProviderManager(String aetLicenseProviderName) {
        for (AELicenseProviderSPI p : ServiceLoader.load(AELicenseProviderSPI.class)) {
            if (aetLicenseProviderName != null && !aetLicenseProviderName.equals(p.getName())) continue;
            this.provider = p;
            break;
        }
        if (this.provider == null) {
            log.warn("No AELicenseProvider found for name: {}", (Object)aetLicenseProviderName);
            this.provider = new NOPLicenseProvider();
        }
        log.debug("Selected AELicenseProvider: {}", (Object)this.provider.getName());
    }

    public static AELicenseProviderManager get(String aetLicenseProviderName) {
        return new AELicenseProviderManager(aetLicenseProviderName);
    }

    public AELicenseProviderSPI getProvider() {
        return this.provider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NOPLicenseProvider
    implements AELicenseProviderSPI {
        private static final long serialVersionUID = 1L;

        private NOPLicenseProvider() {
        }

        @Override
        public String getName() {
            return "NOPLicenseProvider";
        }

        @Override
        public boolean allowAETCreation(String type) {
            return !"TEST".equals(type);
        }

        @Override
        public List<String> getAETypes(List<String> types) {
            return types;
        }

        @Override
        public boolean allowFeature(String name) {
            return true;
        }
    }
}

