/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.cache;

import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.cache.TreeCache;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.tm.TransactionManagerLocator;

public class DeployedTreeCacheProvider
implements CacheProvider {
    private static final Logger log = Logger.getLogger(DeployedTreeCacheProvider.class);
    public static final String OBJECT_NAME_PROP = "hibernate.treecache.objectName";
    public static final String DEFAULT_OBJECT_NAME = "jboss.cache:service=HibernateTreeCache";
    private org.jboss.cache.TreeCache deployedTreeCache;

    public void start(Properties properties) throws CacheException {
        TreeCacheMBean mbean;
        ObjectName objectName;
        String configObjectName = properties.getProperty(OBJECT_NAME_PROP, DEFAULT_OBJECT_NAME);
        try {
            objectName = new ObjectName(configObjectName);
        }
        catch (Throwable t) {
            throw new CacheException("Malformed TreeCache ObjectName");
        }
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            mbean = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, (ObjectName)objectName, (MBeanServer)server);
        }
        catch (Throwable t) {
            log.warn((Object)("Unable to locate TreeCache MBean under object name [" + configObjectName + "]"), t);
            throw new CacheException("Unable to locate TreeCache MBean under object name [" + configObjectName + "]");
        }
        this.deployedTreeCache = mbean.getInstance();
    }

    public void stop() {
        this.deployedTreeCache = null;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public Cache buildCache(String name, Properties properties) throws CacheException {
        TransactionManager tm = TransactionManagerLocator.getInstance().locate();
        return new TreeCache(this.deployedTreeCache, name, tm);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }
}

