/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.secure;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.components.SecureComponentHelper;
import org.apache.wicket.security.hive.authorization.Permission;
import org.apache.wicket.security.hive.authorization.permissions.ComponentPermission;
import org.apache.wicket.security.swarm.actions.SwarmAction;
import org.apache.wicket.security.swarm.strategies.SwarmStrategy;
import org.dcm4chee.web.common.secure.ComponentHiveKey;
import org.dcm4chee.web.common.secure.SecurityBehavior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedSwarmStrategy
extends SwarmStrategy {
    private static final long serialVersionUID = 1L;

    public ExtendedSwarmStrategy(Object hiveQueen) {
        super(hiveQueen);
    }

    public ExtendedSwarmStrategy(Class<? extends ISecureComponent> secureClass, Object hiveQueen) {
        super(secureClass, hiveQueen);
    }

    public boolean isComponentAuthorized(Component component, WaspAction action) {
        if (this.containsBehavior(component, SecurityBehavior.class)) {
            return this.hasPermission((Permission)new ComponentPermission(this.buildHiveKey(component), (WaspAction)((SwarmAction)action)));
        }
        return this.hasPermission((Permission)new ComponentPermission(component, (WaspAction)((SwarmAction)action)));
    }

    private String buildHiveKey(Component component) {
        if (component == null) {
            throw new SecurityException(((Object)((Object)this)).getClass() + ": Specified component is null");
        }
        MarkupContainer markupContainer = this.findLowestSecureContainer(component);
        String alias = SecureComponentHelper.alias(markupContainer.getClass());
        String relative = (String)((Object)component.getMetaData((MetaDataKey)new ComponentHiveKey(String.class)));
        if (relative == null || "".equals(relative)) {
            return alias;
        }
        return alias + ":" + relative;
    }

    private MarkupContainer findLowestSecureContainer(Component component) {
        final MarkupContainer[] lowestSecureParent = new MarkupContainer[1];
        component.visitParents(MarkupContainer.class, (Component.IVisitor)new Component.IVisitor<Component>(){

            public Object component(Component component) {
                if (component instanceof ISecureComponent) {
                    lowestSecureParent[0] = (MarkupContainer)component;
                    return Component.IVisitor.STOP_TRAVERSAL;
                }
                return null;
            }
        });
        if (null == lowestSecureParent[0]) {
            try {
                lowestSecureParent[0] = component.getPage();
            }
            catch (IllegalStateException e) {
                throw new SecurityException(((Object)((Object)this)).getClass() + ": Unable to create alias for component: " + component, e);
            }
        }
        MarkupContainer markupContainer = lowestSecureParent[0];
        return markupContainer;
    }

    private boolean containsBehavior(Component component, Class<SecurityBehavior> clazz) {
        List behaviors = component.getBehaviors();
        for (IBehavior object : behaviors) {
            if (!object.getClass().isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

