/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.model;

import java.util.Date;
import org.apache.wicket.model.IModel;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.ElementDictionary;
import org.dcm4che2.data.VR;
import org.dcm4che2.data.VRMap;
import org.dcm4chee.web.common.model.CompoundDateTimeModel;
import org.dcm4chee.web.common.model.DateModel;
import org.dcm4chee.web.common.model.SimpleDateModel;
import org.dcm4chee.web.common.model.StringModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DicomElementModel<E>
implements IModel<E> {
    protected static ElementDictionary dict = ElementDictionary.getDictionary();
    protected static VRMap vrMap = VRMap.getVRMap();
    private static final long serialVersionUID = 0L;
    protected DicomObject dcmObj;
    protected int vrCode;

    protected DicomElementModel(DicomObject dcmObj, int tag) {
        this.dcmObj = dcmObj;
        DicomElement el = dcmObj.get(tag);
        this.vrCode = el != null ? el.vr().code() : vrMap.vrOf(tag).code();
    }

    protected DicomElementModel(DicomObject dcmObj, int[] tagPath) {
        this.dcmObj = dcmObj;
        this.vrCode = DicomElementModel.getVRof(dcmObj, tagPath).code();
    }

    public static VR getVRof(DicomObject dcmObj, int[] tagPath) {
        if ((tagPath.length & 1) == 0) {
            return VR.DT;
        }
        DicomElement el = dcmObj.get(tagPath);
        return el != null ? el.vr() : vrMap.vrOf(tagPath[tagPath.length - 1]);
    }

    public VR getVR() {
        return VR.valueOf((int)this.vrCode);
    }

    public static DicomElementModel<?> get(DicomObject dcmObj, int[] tagPath) {
        VR vr = DicomElementModel.getVRof(dcmObj, tagPath);
        if (vr == VR.DA || vr == VR.DT) {
            return DicomElementModel.newDateModel(dcmObj, tagPath);
        }
        return DicomElementModel.newStringModel(dcmObj, tagPath);
    }

    public static DicomElementModel<String> newStringModel(DicomObject dcmObj, int[] tagPath) {
        return new StringModel(dcmObj, tagPath);
    }

    public static DicomElementModel<Date> newDateModel(DicomObject dcmObj, int[] tagPath) {
        if (tagPath.length == 1) {
            return new SimpleDateModel(dcmObj, tagPath[0]);
        }
        if (tagPath.length == 2) {
            return new CompoundDateTimeModel(dcmObj, tagPath[0], tagPath[1]);
        }
        return new DateModel(dcmObj, tagPath);
    }

    public void detach() {
    }
}

