/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup.modal;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessages;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.dcm4chee.web.common.markup.modal.AutoOpenModalWindow;

public class FeedbackMessageWindow
extends AutoOpenModalWindow {
    private static final long serialVersionUID = 1L;
    private transient List<FeedbackMessage> messages;

    public FeedbackMessageWindow(String id) {
        super(id);
        this.initContent();
    }

    protected void initContent() {
        this.messages = new ArrayList<FeedbackMessage>();
        this.setInitialWidth(400);
        this.setInitialHeight(300);
        this.setTitle("FeedbackWindow");
        this.setContent((Component)new MessageWindowPanel("content"));
    }

    protected boolean needAutoOpen() {
        FeedbackMessages fbMessages = this.getSession().getFeedbackMessages();
        boolean hasMsg = false;
        for (FeedbackMessage fbMsg : fbMessages) {
            if (fbMsg.getReporter() == null || fbMsg.isRendered()) continue;
            hasMsg = true;
            this.messages.add(fbMsg);
        }
        return hasMsg;
    }

    public class MessageWindowPanel
    extends Panel {
        private static final long serialVersionUID = 0L;

        public MessageWindowPanel(String id) {
            super(id);
            this.add(new Component[]{new FeedbackPanel("feedback")});
            this.add(new Component[]{new AjaxFallbackLink<String>("close", (IModel)new ResourceModel("closeBtn")){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    FeedbackMessageWindow.this.close(target);
                }
            }.add(new Component[]{new Label("closeLabel", (IModel)new ResourceModel("closeBtn"))})});
        }

        public boolean isVisible() {
            return true;
        }
    }
}

