/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup.modal;

import java.lang.reflect.Field;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AutoOpenModalWindow
extends ModalWindow {
    private static final long serialVersionUID = 1L;
    private boolean renderScript;
    private transient Field showField;
    private static Logger log = LoggerFactory.getLogger(AutoOpenModalWindow.class);

    public AutoOpenModalWindow(String id) {
        super(id);
        this.add(new IBehavior[]{new AutoOpenBehaviour()});
    }

    public void renderHead(HtmlHeaderContainer container) {
        super.renderHead(container);
        if (this.needAutoOpen() && !this.isShown()) {
            Component c = this.get("content:close");
            container.getHeaderResponse().renderOnLoadJavascript("self.focus();var elem=document.getElementById('" + c.getMarkupId() + "');elem.focus()");
        }
        container.getHeaderResponse().renderOnDomReadyJavascript("Wicket.Window.unloadConfirmation = false");
    }

    protected void onBeforeRender() {
        if (this.needAutoOpen() && !this.isShown()) {
            this.renderScript = true;
            this.show();
            super.onBeforeRender();
            this.show();
        } else {
            super.onBeforeRender();
        }
    }

    protected abstract boolean needAutoOpen();

    public void show(AjaxRequestTarget target) {
        super.show(target);
        target.focusComponent(this.get("content:close"));
    }

    private void show() {
        try {
            if (this.showField == null) {
                try {
                    this.showField = ModalWindow.class.getDeclaredField("shown");
                    this.showField.setAccessible(true);
                }
                catch (Exception e) {
                    log.error("Failed to initialize shown Field from ModalWindow!");
                }
            }
            this.showField.set((Object)this, true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private class AutoOpenBehaviour
    extends AbstractBehavior
    implements IHeaderContributor {
        private static final long serialVersionUID = 1L;

        private AutoOpenBehaviour() {
        }

        public void renderHead(IHeaderResponse response) {
            if (AutoOpenModalWindow.this.renderScript) {
                try {
                    String script = AutoOpenModalWindow.this.getWindowOpenJavascript();
                    response.renderOnDomReadyJavascript(script);
                }
                catch (Exception e) {
                    log.error("Error render Header with 'WindowOpenJavascript'");
                }
                AutoOpenModalWindow.this.renderScript = false;
            }
        }
    }
}

