/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.datetime.DateConverter;
import org.apache.wicket.datetime.StyleDateConverter;
import org.apache.wicket.datetime.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.dcm4chee.web.common.markup.TimeField;
import org.dcm4chee.web.common.util.DateUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDateTimeField
extends FormComponentPanel<Date>
implements AbstractTextComponent.ITextFormatProvider {
    private static final long serialVersionUID = 1L;
    private boolean max;
    private DateTextField dateField;
    private TimeField timeField;
    private boolean withoutTime;
    private static Logger log = LoggerFactory.getLogger(SimpleDateTimeField.class);

    public SimpleDateTimeField(String id, IModel<Date> model) {
        super(id, model);
        this.setType(Date.class);
        this.dateField = new DateTextField("dateField", (IModel)new DateModel(this), (DateConverter)new StyleDateConverter("S-", false){
            private static final long serialVersionUID = 1L;

            protected DateTimeFormatter getFormat() {
                String pattern = DateUtils.getDatePattern(this.getComponent());
                return DateTimeFormat.forPattern((String)pattern).withLocale(this.getLocale()).withPivotYear(2000);
            }
        });
        this.dateField.add(new IBehavior[]{new DatePicker(){
            private static final long serialVersionUID = 1L;

            protected boolean enableMonthYearSelection() {
                return true;
            }
        }});
        this.add(new Component[]{this.dateField});
        this.timeField = new TimeField("timeField", new TimeModel(this)){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return !SimpleDateTimeField.this.withoutTime;
            }
        };
        this.add(new Component[]{this.timeField});
    }

    public SimpleDateTimeField(String id, IModel<Date> model, boolean max) {
        this(id, model);
        this.max = max;
    }

    public SimpleDateTimeField setWithoutTime(boolean b) {
        this.withoutTime = b;
        return this;
    }

    DateTextField getDateField() {
        return this.dateField;
    }

    public TimeField getTimeField() {
        return this.timeField;
    }

    public boolean isWithoutTime() {
        return this.withoutTime;
    }

    public void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (tag.getAttribute("class") == null) {
            tag.put("class", (CharSequence)"dateTimeField");
        }
    }

    public String getInput() {
        return this.dateField.getInput() + ", " + this.timeField.getInput();
    }

    protected void convertInput() {
        Date d = (Date)this.dateField.getConvertedInput();
        Date t = (Date)this.timeField.getConvertedInput();
        if (d == null) {
            if (t != null) {
                this.timeField.setConvertedInput(null);
            }
            this.setConvertedInput(null);
        } else {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(d);
            if (t == null) {
                DateUtils.setTimeToMinOrMax(cal, this.max);
                this.timeField.getModel().setObject((Object)cal.getTime());
                this.timeField.setConvertedInput(cal.getTime());
            } else {
                GregorianCalendar calT = new GregorianCalendar();
                calT.setTime(t);
                if (this.max && calT.get(11) == 0 && calT.get(12) == 0 && calT.get(13) == 0) {
                    DateUtils.setTimeToMinOrMax(cal, true);
                } else {
                    int h = calT.get(11);
                    int m = calT.get(12);
                    cal.set(11, h);
                    cal.set(12, m);
                    if (h == 23 && m == 59) {
                        cal.set(13, 59);
                        cal.set(14, 999);
                    } else {
                        cal.set(13, calT.get(13));
                        cal.set(14, calT.get(14));
                    }
                }
            }
            this.setConvertedInput(cal.getTime());
        }
        log.debug("Converted Input:{}", this.getConvertedInput());
    }

    public Component addToDateField(IBehavior ... behaviors) {
        this.dateField.add(behaviors);
        return this;
    }

    public Component addToTimeField(IBehavior ... behaviors) {
        this.timeField.add(behaviors);
        return this;
    }

    public String getTextFormat() {
        return DateUtils.getDatePattern((Component)this);
    }

    private class TimeModel
    extends DateModel {
        private static final long serialVersionUID = 1L;

        public TimeModel(SimpleDateTimeField tf) {
            super(tf);
        }

        public void setObject(Date object) {
            IModel model = this.tf.getModel();
            Date oldDate = (Date)model.getObject();
            if (oldDate == null) {
                if (object != null) {
                    model.setObject((Object)object);
                }
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime(oldDate);
                if (object != null) {
                    Calendar newCal = Calendar.getInstance();
                    newCal.setTime(object);
                    cal.set(11, newCal.get(11));
                    cal.set(12, newCal.get(12));
                    cal.set(13, 0);
                    cal.set(14, 0);
                } else {
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                }
                model.setObject((Object)cal.getTime());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateModel
    implements IModel<Date> {
        private static final long serialVersionUID = 1L;
        protected SimpleDateTimeField tf;

        public DateModel(SimpleDateTimeField tf) {
            this.tf = tf;
        }

        public Date getObject() {
            return (Date)this.tf.getModelObject();
        }

        public void setObject(Date object) {
            if (object != null) {
                IModel model = this.tf.getModel();
                Date oldDate = (Date)model.getObject();
                if (oldDate == null) {
                    model.setObject((Object)object);
                } else {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(oldDate);
                    Calendar newCal = Calendar.getInstance();
                    newCal.setTime(object);
                    cal.set(1, newCal.get(1));
                    cal.set(2, newCal.get(2));
                    cal.set(5, newCal.get(5));
                    model.setObject((Object)cal.getTime());
                }
            }
        }

        public void detach() {
        }
    }
}

