/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup;

import org.apache.wicket.IPageMap;
import org.apache.wicket.Page;
import org.apache.wicket.PageMap;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.link.PopupSettings;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PopupLink
extends Link<Object> {
    private static final long serialVersionUID = 1L;
    private String popupPageName = "popupPage";
    private int popupHeight = 300;
    private int popupWidth = 500;
    private int popupDisplayFlag = 12;
    private static Logger log = LoggerFactory.getLogger(PopupLink.class);

    public PopupLink(String id, String popupPageName) {
        super(id);
        this.init(popupPageName);
    }

    public PopupLink(String id, IModel<Object> model, String pageMapName) {
        super(id, model);
        this.init(pageMapName);
    }

    public PopupLink(String id, Page targetPageInstance, String targetPageName) {
        this(id, targetPageName);
    }

    public void setPopupHeight(int popupHeight) {
        this.popupHeight = popupHeight;
    }

    public void setPopupWidth(int popupWidth) {
        this.popupWidth = popupWidth;
    }

    public void setPopupDisplayFlags(int popupDisplayFlag) {
        this.popupDisplayFlag = popupDisplayFlag;
    }

    public void setPopupDisplayFlag(int flag, boolean b) {
        this.popupDisplayFlag = b ? this.popupDisplayFlag | flag : this.popupDisplayFlag & ~flag;
    }

    private void init(String pageMapName) {
        if (this.popupPageName != null) {
            this.popupPageName = pageMapName;
        }
        MultiPopupSettings popupSettings = new MultiPopupSettings(PageMap.forName((String)this.popupPageName));
        super.setPopupSettings((PopupSettings)popupSettings);
        this.add(new IBehavior[]{new MultiPopupBehaviour()});
    }

    private class MultiPopupBehaviour
    extends AbstractBehavior
    implements IHeaderContributor {
        private static final long serialVersionUID = 1L;

        private MultiPopupBehaviour() {
        }

        public void renderHead(IHeaderResponse response) {
            try {
                response.renderJavascript((CharSequence)"var popup_count=1;", "PopupLink");
            }
            catch (Exception e) {
                log.error("Error render Header with 'PopupLink Javascript'");
            }
        }
    }

    private class MultiPopupSettings
    extends PopupSettings {
        private static final long serialVersionUID = 1L;

        public MultiPopupSettings(IPageMap pageMap) {
            super(pageMap);
        }

        public String getPopupJavaScript() {
            String windowTitle = PopupLink.this.popupPageName;
            windowTitle = windowTitle.replaceAll("\\W", "_");
            StringBuffer script = new StringBuffer("var w = window.open('" + PopupLink.this.getURL() + "', '").append(windowTitle).append("_'+popup_count, '");
            script.append("scrollbars=").append(this.flagToString(8));
            script.append(",location=").append(this.flagToString(1));
            script.append(",menuBar=").append(this.flagToString(2));
            script.append(",resizable=").append(this.flagToString(4));
            script.append(",status=").append(this.flagToString(16));
            script.append(",toolbar=").append(this.flagToString(32));
            if (PopupLink.this.popupWidth != -1) {
                script.append(",width=").append(PopupLink.this.popupWidth);
            }
            if (PopupLink.this.popupHeight != -1) {
                script.append(",height=").append(PopupLink.this.popupHeight);
            }
            script.append("'); if(w.blur) w.focus(); popup_count++; return false;");
            return script.toString();
        }

        private String flagToString(int flag) {
            return (PopupLink.this.popupDisplayFlag & flag) != 0 ? "yes" : "no";
        }
    }
}

