/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.dcm4chee.web.common.util.DateUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeLabel
extends Label {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat df = new SimpleDateFormat("HH:mm");
    private boolean withoutTime;

    public DateTimeLabel(String id) {
        super(id);
    }

    public DateTimeLabel(String id, String label) {
        super(id, label);
    }

    public DateTimeLabel(String id, IModel<Date> model) {
        super(id, model);
    }

    public DateTimeLabel setWithoutTime(boolean b) {
        this.withoutTime = b;
        return this;
    }

    public IConverter getConverter(Class<?> type) {
        return new IConverter(){
            private static final long serialVersionUID = 1L;

            public Object convertToObject(String value, Locale locale) {
                throw new UnsupportedOperationException();
            }

            public String convertToString(Object value, Locale locale) {
                if (value == null) {
                    return null;
                }
                Date d = (Date)value;
                String pattern = DateTimeLabel.this.getTextFormat();
                DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern).withLocale(DateTimeLabel.this.getLocale()).withPivotYear(2000);
                return DateTimeLabel.this.withoutTime ? dtf.print(d.getTime()) : dtf.print(d.getTime()) + " " + DateTimeLabel.this.df.format(d);
            }
        };
    }

    public String getTextFormat() {
        return DateUtils.getDatePattern((Component)this);
    }
}

