/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.markup;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.StringValidator;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.web.common.behaviours.MarkInvalidBehaviour;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.dcm4chee.web.common.markup.PatientNameField;
import org.dcm4chee.web.common.markup.SimpleDateTimeField;
import org.dcm4chee.web.common.markup.TimeField;
import org.dcm4chee.web.common.model.DicomElementModel;
import org.dcm4chee.web.common.util.DateUtils;
import org.dcm4chee.web.common.validators.UIDValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseForm
extends Form<Object> {
    private static final long serialVersionUID = 0L;
    public static final String LABEL_ID_EXTENSION = ".label";
    private String resourceIdPrefix;
    private WebMarkupContainer parent;
    private boolean rendered;
    MarkInvalidBehaviour markInvalidBehaviour = new MarkInvalidBehaviour();

    public BaseForm(String id) {
        super(id);
    }

    public BaseForm(String id, IModel<Object> model) {
        super(id, model);
    }

    public void setResourceIdPrefix(String resourceIdPrefix) {
        this.resourceIdPrefix = resourceIdPrefix;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        if (!this.rendered) {
            this.visitChildren(new FormVisitor());
            this.rendered = true;
        }
    }

    public void clearParent() {
        this.parent = null;
    }

    public WebMarkupContainer createAjaxParent(String id) {
        Component[] componentArray = new Component[1];
        this.parent = new WebMarkupContainer(id);
        componentArray[0] = this.parent;
        super.add(componentArray);
        this.parent.setOutputMarkupId(true);
        this.parent.setOutputMarkupPlaceholderTag(true);
        return this.parent;
    }

    public MarkupContainer addComponent(Component child) {
        if (this.parent == null) {
            super.add(new Component[]{child});
        } else {
            this.parent.add(new Component[]{child});
        }
        return this;
    }

    public TextField<String> addLabeledTextField(String id) {
        TextField tf = new TextField(id);
        this.addInternalLabel(id);
        this.addComponent((Component)tf);
        return tf;
    }

    public TextField<Integer> addLabeledNumberTextField(String id) {
        TextField tf = new TextField(id);
        this.addInternalLabel(id);
        this.addComponent((Component)tf);
        return tf;
    }

    public TextField<String> addTextField(String id, final IModel<Boolean> enabledModel, boolean addLabel) {
        TextField<String> tf = new TextField<String>(id){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled() {
                return enabledModel == null ? true : (Boolean)enabledModel.getObject();
            }
        };
        if (addLabel) {
            this.addInternalLabel(id);
        }
        this.addComponent((Component)tf);
        return tf;
    }

    public PatientNameField addPatientNameField(String id, IModel<String> model, boolean useFnGn, final IModel<Boolean> enabledModel, boolean addLabel) {
        PatientNameField tf = new PatientNameField(id, model, useFnGn){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled() {
                return enabledModel == null ? true : (Boolean)enabledModel.getObject();
            }
        };
        if (addLabel) {
            this.addInternalLabel(id);
        }
        this.addComponent((Component)tf);
        return tf;
    }

    public SimpleDateTimeField addDateTimeField(String id, IModel<Date> model, IModel<Boolean> enabledModel, boolean max, boolean addLabel) {
        SimpleDateTimeField dtf = this.getSimpleDateTimeField(id, model, enabledModel, max);
        if (addLabel) {
            this.addInternalLabel(id);
        }
        this.addComponent((Component)dtf);
        return dtf;
    }

    public SimpleDateTimeField getSimpleDateTimeField(String id, IModel<Date> model, final IModel<Boolean> enabledModel, boolean max) {
        final SimpleDateTimeField dtf = new SimpleDateTimeField(id, model, max){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled() {
                return enabledModel == null ? true : (Boolean)enabledModel.getObject();
            }
        };
        dtf.getDateField().add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new StringResourceModel(this.toResourceKey(id) + ".date.tooltip", (Component)this, (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return DateUtils.getDatePattern((Component)dtf);
            }
        }))});
        dtf.getTimeField().add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new StringResourceModel(this.toResourceKey(id) + ".time.tooltip", (Component)this, null))});
        return dtf;
    }

    public SimpleDateTimeField getDateTextField(String id, IModel<Date> model, String tooltipPrefix, final IModel<Boolean> enabledModel) {
        SimpleDateTimeField dtf = new SimpleDateTimeField(id, model){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled() {
                return enabledModel == null ? true : (Boolean)enabledModel.getObject();
            }
        };
        dtf.setWithoutTime(true);
        if (tooltipPrefix != null) {
            dtf.getDateField().add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new StringResourceModel((this.resourceIdPrefix != null ? this.resourceIdPrefix : "") + tooltipPrefix + id + ".date.tooltip", (Component)this, (IModel)new PropertyModel((Object)dtf, "textFormat")))});
        }
        dtf.add(new IBehavior[]{this.markInvalidBehaviour});
        return dtf;
    }

    public DropDownChoice<?> addLabeledDropDownChoice(String id, IModel<Object> model, List<String> values) {
        DropDownChoice ch = model == null ? new DropDownChoice(id, values) : new DropDownChoice(id, model, values);
        this.addInternalLabel(id);
        this.addComponent((Component)ch);
        return ch;
    }

    public DropDownChoice addDropDownChoice(String id, IModel<?> model, IModel<? extends List<? extends Object>> choices, final IModel<Boolean> enabledModel, boolean addLabel) {
        DropDownChoice ch;
        Object object = ch = model == null ? new DropDownChoice<Object>(id, choices){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled() {
                return enabledModel == null ? true : (Boolean)enabledModel.getObject();
            }
        } : new DropDownChoice(id, model, choices){
            private static final long serialVersionUID = 1L;

            public boolean isEnabled() {
                return enabledModel == null ? true : (Boolean)enabledModel.getObject();
            }
        };
        if (addLabel) {
            this.addInternalLabel(id);
        }
        this.addComponent((Component)ch);
        return ch;
    }

    public CheckBox addLabeledCheckBox(String id, IModel<Boolean> model) {
        CheckBox chk = model == null ? new CheckBox(id) : new CheckBox(id, model);
        this.addInternalLabel(id);
        this.addComponent((Component)chk);
        return chk;
    }

    public Label addInternalLabel(String id) {
        String labelId = id + LABEL_ID_EXTENSION;
        return this.addLabel(labelId);
    }

    public Label addLabel(String id) {
        Label l = new Label(id, (IModel)new ResourceModel(this.toResourceKey(id)));
        this.addComponent((Component)l);
        return l;
    }

    private String toResourceKey(String id) {
        StringBuffer resourceKey = new StringBuffer(id);
        if (this.parent != null) {
            resourceKey.insert(0, ".");
            resourceKey.insert(0, this.parent.getId());
        }
        if (this.resourceIdPrefix != null) {
            resourceKey.insert(0, this.resourceIdPrefix);
        }
        return resourceKey.toString();
    }

    public static void addInvalidComponentsToAjaxRequestTarget(final AjaxRequestTarget target, Form<?> form) {
        Component.IVisitor<Component> visitor = new Component.IVisitor<Component>(){

            public Object component(Component c) {
                FormComponent fc;
                if (c instanceof FormComponent && !(fc = (FormComponent)c).isValid()) {
                    target.addComponent((Component)fc);
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        };
        form.visitChildren((Component.IVisitor)visitor);
    }

    public static void addFormComponentsToAjaxRequestTarget(final AjaxRequestTarget target, Form<?> form) {
        Component.IVisitor<Component> visitor = new Component.IVisitor<Component>(){

            public Object component(Component c) {
                if (c.getOutputMarkupId()) {
                    target.addComponent(c);
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        };
        form.visitChildren((Component.IVisitor)visitor);
    }

    public boolean componentHasNoTooltip(Component c) {
        for (IBehavior b : c.getBehaviors()) {
            if (!(b instanceof TooltipBehaviour)) continue;
            return false;
        }
        return true;
    }

    public FormComponent<?> getDicomObjectField(String id, DicomObject dcmObj, int[] tagPath) {
        Object fc;
        VR vr = DicomElementModel.getVRof(dcmObj, tagPath);
        if (vr == VR.DA) {
            fc = this.getDateTextField(id, DicomElementModel.newDateModel(dcmObj, tagPath), null, null);
        } else if (vr == VR.DT) {
            fc = this.getSimpleDateTimeField(id, DicomElementModel.newDateModel(dcmObj, tagPath), null, false);
        } else if (vr == VR.TM) {
            fc = new TimeField(id, DicomElementModel.newDateModel(dcmObj, tagPath));
        } else {
            final String tfClass = vr == VR.IS || vr == VR.AE || vr == VR.SH || vr == VR.CS ? "textFieldSH" : "textFieldLO";
            TextField<String> fct = new TextField<String>(id, DicomElementModel.newStringModel(dcmObj, tagPath)){
                private static final long serialVersionUID = 1L;

                public void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("class", (CharSequence)tfClass);
                }
            };
            fct.add(this.getDicomTextValidator(vr));
            fc = fct;
        }
        if (fc instanceof AbstractTextComponent.ITextFormatProvider) {
            fc.add(new IBehavior[]{new TooltipBehaviour("dcmfield.", "format", (IModel<?>)new PropertyModel(fc, "textFormat"))});
        }
        return fc;
    }

    private IValidator<String> getDicomTextValidator(VR vr) {
        if (vr == VR.AE || vr == VR.SH || vr == VR.CS) {
            return new StringValidator.MaximumLengthValidator(16);
        }
        if (vr == VR.UI) {
            return new UIDValidator();
        }
        if (vr == VR.LO || vr == VR.PN) {
            return new StringValidator.MaximumLengthValidator(64);
        }
        if (vr == VR.ST) {
            return new StringValidator.MaximumLengthValidator(1024);
        }
        if (vr == VR.LT) {
            return new StringValidator.MaximumLengthValidator(10240);
        }
        if (vr == VR.IS) {
            return new StringValidator.MaximumLengthValidator(12);
        }
        if (vr == VR.UT) {
            return new StringValidator.MaximumLengthValidator(Integer.MAX_VALUE);
        }
        return new StringValidator.MaximumLengthValidator(64);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FormVisitor
    implements Component.IVisitor<Component>,
    Serializable {
        private static final long serialVersionUID = 0L;

        FormVisitor() {
        }

        public Object component(Component c) {
            if (BaseForm.this.componentHasNoTooltip(c)) {
                c.add(new IBehavior[]{new TooltipBehaviour(BaseForm.this.resourceIdPrefix, c.getId()).setGenerateComponentTreePrefix()});
            }
            if (c instanceof FormComponent) {
                c.add(new IBehavior[]{BaseForm.this.markInvalidBehaviour});
                c.setOutputMarkupId(true);
            }
            return Component.IVisitor.CONTINUE_TRAVERSAL;
        }
    }
}

