/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.login;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.security.authentication.LoginException;
import org.apache.wicket.security.hive.authentication.DefaultSubject;
import org.apache.wicket.security.hive.authentication.Subject;
import org.apache.wicket.security.hive.authentication.UsernamePasswordContext;
import org.dcm4chee.web.common.delegate.BaseCfgDelegate;
import org.dcm4chee.web.common.delegate.BaseMBeanDelegate;
import org.dcm4chee.web.common.login.LoginContextSecurityHelper;
import org.dcm4chee.web.common.secure.SecureSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebLoginContext
extends UsernamePasswordContext {
    protected static Logger log = LoggerFactory.getLogger(BaseMBeanDelegate.class);

    public WebLoginContext() {
    }

    public WebLoginContext(String username, String password) {
        super(username, password);
    }

    protected Subject getSubject(String username, String password) throws LoginException {
        DefaultSubject subject;
        LoginContext context;
        SecureSession secureSession;
        String rolesGroupName;
        WebApplication app = (WebApplication)RequestCycle.get().getApplication();
        String webApplicationPolicy = app.getInitParameter("webApplicationPolicy");
        if (webApplicationPolicy == null) {
            webApplicationPolicy = "dcm4chee";
        }
        if ((rolesGroupName = app.getInitParameter("rolesGroupName")) == null) {
            rolesGroupName = "Roles";
        }
        LoginCallbackHandler handler = new LoginCallbackHandler(username, password);
        try {
            secureSession = (SecureSession)RequestCycle.get().getSession();
            secureSession.setManageUsers(BaseCfgDelegate.getInstance().getManageUsers());
            context = new LoginContext(webApplicationPolicy, handler);
            context.login();
            secureSession.setUsername(username);
        }
        catch (Exception e) {
            log.warn("Login failed. Reason: " + e.getMessage());
            throw new LoginException();
        }
        if (!this.readHiveFile()) {
            return null;
        }
        try {
            subject = LoginContextSecurityHelper.mapSwarmSubject(context.getSubject(), null);
            if (!LoginContextSecurityHelper.checkLoginAllowed(subject)) {
                ((SecureSession)RequestCycle.get().getSession()).invalidate();
                log.warn("Failed to authorize subject for login, denied. See 'LoginAllowedRolename' parameter in web.xml.");
            }
            secureSession.extendedLogin(username, password, (Subject)subject);
        }
        catch (Exception e) {
            log.error("Login failed for user " + username, (Throwable)e);
            ((SecureSession)RequestCycle.get().getSession()).invalidate();
            subject = new DefaultSubject();
        }
        return subject;
    }

    private boolean readHiveFile() {
        try {
            ((SecureSession)RequestCycle.get().getSession()).setAllSwarmPrincipals(LoginContextSecurityHelper.readSwarmPrincipals());
            return true;
        }
        catch (Exception e) {
            log.error("Exception (error processing hive file): " + e.getMessage());
            ((SecureSession)RequestCycle.get().getSession()).invalidate();
            return false;
        }
    }

    private class LoginCallbackHandler
    implements CallbackHandler {
        private String user;
        private String passwd;

        public LoginCallbackHandler(String user, String passwd) {
            this.user = user;
            this.passwd = passwd;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.user);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    ((PasswordCallback)cb).setPassword(this.passwd.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(cb, "Callback not supported! (only Name and Password Callback are supported)");
            }
        }
    }
}

