/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.login;

import java.io.InputStream;
import java.util.PropertyResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginResources {
    protected static Logger log = LoggerFactory.getLogger(LoginResources.class);
    PropertyResourceBundle prb;

    public LoginResources() {
        this.setLocale("en");
    }

    public void setLocale(String locale) {
        try {
            InputStream resource = this.getClass().getResourceAsStream("locale/login_" + locale + ".properties");
            if (resource == null) {
                log.warn("Could not get locale " + locale + " for login page");
                return;
            }
            this.prb = new PropertyResourceBundle(resource);
        }
        catch (Exception e) {
            log.error("Error processing locale " + locale + " for login page: ", (Throwable)e);
        }
    }

    public String getBrowser_title() {
        return this.prb.getString("login.browser_title");
    }

    public String getLoginLabel() {
        return this.prb.getString("login.loginLabel");
    }

    public String getUsername() {
        return this.prb.getString("login.username");
    }

    public String getPassword() {
        return this.prb.getString("login.password");
    }

    public String getSubmit() {
        return this.prb.getString("login.submit");
    }

    public String getReset() {
        return this.prb.getString("login.reset");
    }

    public String getLoginFailed() {
        return this.prb.getString("login.loginFailed");
    }
}

