/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.behaviours;

import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableTableRowBehaviour
extends AjaxEventBehavior {
    private static final long serialVersionUID = 1L;
    private IModel<Boolean> model;
    private CheckBox chkBox;
    private String unselectedClass;
    private String selectedClass;

    private SelectableTableRowBehaviour(String unselectedClass, String selectedClass) {
        super("onclick");
        this.unselectedClass = unselectedClass;
        this.selectedClass = selectedClass;
    }

    public SelectableTableRowBehaviour(IModel<Boolean> model, String unselectedClass, String selectedClass) {
        this(unselectedClass, selectedClass);
        this.model = model;
    }

    public SelectableTableRowBehaviour(CheckBox chkBox, String unselectedClass, String selectedClass) {
        this(unselectedClass, selectedClass);
        this.chkBox = chkBox;
        chkBox.setOutputMarkupId(true);
    }

    protected void onEvent(AjaxRequestTarget target) {
        this.model.setObject((Object)((Boolean)this.model.getObject() == false ? 1 : 0));
        target.addComponent(this.getComponent());
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.model == null) {
            this.model = this.chkBox.getModel();
        }
        if (((Boolean)this.model.getObject()).booleanValue()) {
            if (this.selectedClass != null) {
                tag.put("class", (CharSequence)this.selectedClass);
            }
        } else if (this.unselectedClass != null) {
            tag.put("class", (CharSequence)this.unselectedClass);
        }
    }

    protected CharSequence getPreconditionScript() {
        return "if (event == null || !event.ctrlKey) return false;var t = (event.target) ? event.target : (event.srcElement) ? event.srcElement : null;if (t.nodeType == 3) t = t.parentNode; return t.nodeName == 'TD' || t.nodeName == 'SPAN'";
    }
}

