/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.behaviours;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextField;

public class FocusOnLoadBehaviour
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    private Component component;
    private FocusStrategy focusStrategy;

    public FocusOnLoadBehaviour() {
    }

    public FocusOnLoadBehaviour(FocusStrategy strategy) {
        this.focusStrategy = strategy;
    }

    public static FocusOnLoadBehaviour newSimpleFocusBehaviour() {
        FocusOnLoadBehaviour fb = new FocusOnLoadBehaviour();
        fb.focusStrategy = fb.new SimpleFocusStrategy();
        return fb;
    }

    public static FocusOnLoadBehaviour newFocusAndSelectBehaviour() {
        FocusOnLoadBehaviour fb = new FocusOnLoadBehaviour();
        fb.focusStrategy = fb.new FocusAndSelectTextStrategy();
        return fb;
    }

    public void bind(Component component) {
        this.component = component;
        if (this.focusStrategy == null) {
            if (component instanceof FormComponent) {
                this.focusStrategy = new EmptyFocusStrategy();
            } else if (component instanceof Form) {
                this.focusStrategy = new FirstEmptyTextfieldFocusStrategy();
            }
        }
        component.setOutputMarkupId(true);
    }

    public void renderHead(IHeaderResponse headerResponse) {
        super.renderHead(headerResponse);
        this.focusStrategy.focus(headerResponse, this.component);
    }

    public boolean isTemporary() {
        return false;
    }

    private boolean setFocusOnEmpty(IHeaderResponse headerResponse, Component c) {
        Object o = c.getDefaultModelObject();
        if (o == null || o.toString().length() < 1) {
            headerResponse.renderOnLoadJavascript(this.getJavaScriptString(c));
            return true;
        }
        return false;
    }

    private String getJavaScriptString(Component c) {
        return "self.focus();var elem=document.getElementById('" + c.getMarkupId() + "');elem.focus()";
    }

    public class FirstEmptyTextfieldFocusStrategy
    implements FocusStrategy {
        private static final long serialVersionUID = 1L;

        public void focus(IHeaderResponse headerResponse, Component fc) {
            Form form = (Form)fc;
            for (int i = 0; i < form.size(); ++i) {
                Component c = form.get(i);
                if (!(c instanceof TextField) || !FocusOnLoadBehaviour.this.setFocusOnEmpty(headerResponse, c)) continue;
                c.setOutputMarkupId(true);
                break;
            }
        }
    }

    public class FocusAndSelectTextStrategy
    implements FocusStrategy {
        private static final long serialVersionUID = 1L;

        public void focus(IHeaderResponse headerResponse, Component c) {
            if (c instanceof TextField) {
                headerResponse.renderOnLoadJavascript(FocusOnLoadBehaviour.this.getJavaScriptString(c) + ";elem.select()");
            }
        }
    }

    public class EmptyFocusStrategy
    implements FocusStrategy {
        private static final long serialVersionUID = 1L;

        public void focus(IHeaderResponse headerResponse, Component c) {
            FocusOnLoadBehaviour.this.setFocusOnEmpty(headerResponse, c);
        }
    }

    public class SimpleFocusStrategy
    implements FocusStrategy {
        private static final long serialVersionUID = 1L;

        public void focus(IHeaderResponse headerResponse, Component c) {
            headerResponse.renderOnLoadJavascript(FocusOnLoadBehaviour.this.getJavaScriptString(c));
        }
    }

    public static interface FocusStrategy
    extends Serializable {
        public void focus(IHeaderResponse var1, Component var2);
    }
}

