/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.dcm4che2.util.StringUtils;
import org.dcm4chee.web.common.base.ExternalWebApp;
import org.dcm4chee.web.common.base.ExternalWebAppGroupPanel;
import org.dcm4chee.web.common.base.ExternalWebAppPanel;
import org.dcm4chee.web.common.delegate.BaseCfgDelegate;
import org.dcm4chee.web.common.login.LoginContextSecurityHelper;
import org.dcm4chee.web.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalWebApplications
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CFG_FILE_NAME = "external_webapps.cfg";
    private List<String> jaasRoles;
    private List<ExternalWebApp> applications = new ArrayList<ExternalWebApp>();
    private static Logger log = LoggerFactory.getLogger(ExternalWebApplications.class);

    public ExternalWebApplications() {
        this.jaasRoles = LoginContextSecurityHelper.getJaasRoles();
    }

    public List<ExternalWebApp> getExternalWebAppPanels() {
        File cfgPath = FileUtils.resolve(new File(BaseCfgDelegate.getInstance().getWebConfigPath()));
        File cfgFile = new File(cfgPath, CFG_FILE_NAME);
        if (cfgFile.isFile()) {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(cfgFile));
                HashMap<String, ExternalWebAppGroupPanel> grpPanels = new HashMap<String, ExternalWebAppGroupPanel>();
                while ((line = br.readLine()) != null) {
                    if (line.charAt(0) == '#') continue;
                    int pos1 = line.indexOf(61);
                    String appTitle = line.substring(0, pos1++);
                    int pos2 = line.indexOf(124, pos1);
                    String grpTitle = line.substring(pos1, pos2++);
                    pos1 = pos2;
                    pos2 = line.indexOf(124, pos1);
                    if (!this.hasRole(line.substring(pos1, pos2++))) continue;
                    pos1 = pos2;
                    pos2 = line.indexOf(124, pos1);
                    int height = Integer.parseInt(line.substring(pos1, pos2++));
                    String url = line.substring(pos2);
                    Model titleModel = new Model((Serializable)((Object)appTitle));
                    if (grpTitle.length() < 1) {
                        this.applications.add(new ExternalWebAppPanel("panel", url, (IModel<String>)titleModel, height));
                        continue;
                    }
                    ExternalWebAppGroupPanel grpPanel = (ExternalWebAppGroupPanel)grpPanels.get(grpTitle);
                    if (grpPanel == null) {
                        grpPanel = new ExternalWebAppGroupPanel("panel", (IModel<String>)new Model((Serializable)((Object)grpTitle)));
                        grpPanels.put(grpTitle, grpPanel);
                        this.applications.add(grpPanel);
                    }
                    grpPanel.addModule(new ExternalWebAppPanel("panel", url, (IModel<String>)titleModel, height), (IModel<String>)titleModel);
                }
            }
            catch (Exception x) {
                log.error("Failed to read config file:" + cfgFile, (Throwable)x);
            }
        }
        log.debug("ExternalWebAppPanels:{}", this.applications);
        return this.applications;
    }

    private boolean hasRole(String rolesStr) {
        String[] roles = StringUtils.split((String)rolesStr, (char)',');
        for (int i = 0; i < roles.length; ++i) {
            if (!this.jaasRoles.contains(roles[i])) continue;
            return true;
        }
        return false;
    }
}

