/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.validation;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.wsf.common.IOUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaExtractor {
    private static Logger log = Logger.getLogger(SchemaExtractor.class);
    private File xsdFile;

    public URL getSchemaUrl(URL wsdlURL) throws IOException {
        QName typesQName;
        Element root = DOMUtils.parse(wsdlURL.openStream());
        Element typesEl = DOMUtils.getFirstChildElement((Node)root, typesQName = new QName(root.getNamespaceURI(), "types"));
        if (typesEl == null) {
            log.warn((Object)("Cannot find element: " + typesQName));
            return null;
        }
        QName schemaQName = new QName("http://www.w3.org/2001/XMLSchema", "schema");
        List<Element> schemaElements = DOMUtils.getChildElementsAsList((Node)typesEl, schemaQName);
        if (schemaElements.size() == 0) {
            log.warn((Object)("Cannot find element: " + schemaQName));
            return null;
        }
        if (schemaElements.size() > 1) {
            log.warn((Object)"Multiple schema elements not supported.");
        }
        Element schemaElement = schemaElements.get(0);
        File tmpdir = IOUtils.createTempDirectory();
        this.xsdFile = File.createTempFile("jbossws_schema", ".xsd", tmpdir);
        this.xsdFile.deleteOnExit();
        OutputStreamWriter outwr = new OutputStreamWriter(new FileOutputStream(this.xsdFile));
        DOMWriter domWriter = new DOMWriter(outwr);
        domWriter.setPrettyprint(true);
        domWriter.print(schemaElement);
        outwr.close();
        return this.xsdFile.toURL();
    }

    public void close() {
        if (this.xsdFile != null) {
            this.xsdFile.delete();
            this.xsdFile = null;
        }
    }
}

