/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.common.webview.link;

import java.io.Serializable;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import org.dcm4chee.web.common.webview.link.spi.WebviewerLinkProviderSPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebviewerLinkProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    private WebviewerLinkProviderSPI provider;
    private boolean testDummy;
    private static Logger log = LoggerFactory.getLogger(WebviewerLinkProvider.class);

    public WebviewerLinkProvider(String webviewerName) {
        Iterator<WebviewerLinkProviderSPI> iter = ServiceRegistry.lookupProviders(WebviewerLinkProviderSPI.class);
        while (iter.hasNext()) {
            WebviewerLinkProviderSPI p = iter.next();
            log.debug("----------------------------------------");
            log.debug("Found WebviewerLinkProvider: {}", (Object)p.getName());
            log.debug("----------------------------------------");
            if (webviewerName != null && !webviewerName.equals(p.getName())) continue;
            this.provider = p;
            break;
        }
        if (this.provider == null) {
            this.testDummy = "TEST".equals(webviewerName);
            log.warn("No WebviewerLinkProvider found for name: {}", (Object)webviewerName);
            this.provider = new DummyProvider();
        }
        log.debug("Selected WebviewerLinkProvider: {}", (Object)this.provider.getName());
    }

    public String getName() {
        return this.provider.getName();
    }

    public void setBaseUrl(String baseUrl) {
        this.provider.setBaseURL(baseUrl);
    }

    public boolean supportPatientLevel() {
        return this.provider.supportPatientLevel();
    }

    public boolean supportStudyLevel() {
        return this.provider.supportStudyLevel();
    }

    public boolean supportSeriesLevel() {
        return this.provider.supportSeriesLevel();
    }

    public boolean supportInstanceLevel() {
        return this.provider.supportInstanceLevel();
    }

    public boolean supportPresentationState() {
        return this.provider.supportPresentationState();
    }

    public boolean supportKeySelectionObject() {
        return this.provider.supportKeySelectionObject();
    }

    public boolean supportStructuredReport() {
        return this.provider.supportStructuredReport();
    }

    public String getUrlForPatient(String patientId, String issuer) {
        return this.provider.getUrlForPatient(patientId, issuer);
    }

    public String getUrlForStudy(String studyIuid) {
        return this.provider.getUrlForStudy(studyIuid);
    }

    public String getUrlForSeries(String seriesIuid) {
        return this.provider.getUrlForSeries(seriesIuid);
    }

    public String getUrlForInstance(String sopIuid) {
        return this.provider.getUrlForInstance(sopIuid);
    }

    public String getUrlForPresentationState(String iuid) {
        return this.provider.getUrlForPresentationState(iuid);
    }

    public String getUrlForKeyObjectSelection(String iuid) {
        return this.provider.getUrlForKeyObjectSelection(iuid);
    }

    public String getUrlForStructuredReport(String iuid) {
        return this.provider.getUrlForStructuredReport(iuid);
    }

    private class DummyProvider
    extends WebviewerLinkProviderSPI {
        private static final long serialVersionUID = 1L;

        private DummyProvider() {
        }

        public String getName() {
            return "DUMMY";
        }

        public String getUrlForInstance(String sopIuid) {
            return WebviewerLinkProvider.this.testDummy ? "/TEST_WEBVIEWER?instance" : null;
        }

        public String getUrlForKeyObjectSelection(String iuid) {
            return WebviewerLinkProvider.this.testDummy ? "/TEST_WEBVIEWER?key_object_selection" : null;
        }

        public String getUrlForPatient(String patientId, String issuer) {
            return WebviewerLinkProvider.this.testDummy ? "/TEST_WEBVIEWER?patient" : null;
        }

        public String getUrlForPresentationState(String iuid) {
            return WebviewerLinkProvider.this.testDummy ? "/TEST_WEBVIEWER?presentation_state" : null;
        }

        public String getUrlForStructuredReport(String iuid) {
            return WebviewerLinkProvider.this.testDummy ? "/TEST_WEBVIEWER?structured_report" : null;
        }

        public String getUrlForSeries(String seriesIuid) {
            return WebviewerLinkProvider.this.testDummy ? "/TEST_WEBVIEWER?series" : null;
        }

        public String getUrlForStudy(String studyIuid) {
            return WebviewerLinkProvider.this.testDummy ? "/TEST_WEBVIEWER?study" : null;
        }

        public boolean supportInstanceLevel() {
            return WebviewerLinkProvider.this.testDummy;
        }

        public boolean supportKeySelectionObject() {
            return WebviewerLinkProvider.this.testDummy;
        }

        public boolean supportPatientLevel() {
            return WebviewerLinkProvider.this.testDummy;
        }

        public boolean supportPresentationState() {
            return WebviewerLinkProvider.this.testDummy;
        }

        public boolean supportSeriesLevel() {
            return WebviewerLinkProvider.this.testDummy;
        }

        public boolean supportStudyLevel() {
            return WebviewerLinkProvider.this.testDummy;
        }

        public boolean supportStructuredReport() {
            return WebviewerLinkProvider.this.testDummy;
        }
    }
}

