/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.socketfactory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import org.jboss.remoting.socketfactory.SocketCreationListener;

public class CreationListenerServerSocket
extends ServerSocket {
    private ServerSocket serverSocket;
    private SocketCreationListener listener;

    public CreationListenerServerSocket(ServerSocket serverSocket, SocketCreationListener listener) throws IOException {
        this.serverSocket = serverSocket;
        this.listener = listener;
    }

    public SocketCreationListener getListener() {
        return this.listener;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setListener(SocketCreationListener listener) {
        this.listener = listener;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void bind(SocketAddress endpoint) throws IOException {
        this.serverSocket.bind(endpoint);
    }

    public void bind(SocketAddress endpoint, int backlog) throws IOException {
        this.serverSocket.bind(endpoint, backlog);
    }

    public Socket accept() throws IOException {
        Socket socket = this.serverSocket.accept();
        this.listener.socketCreated(socket, this.serverSocket);
        return socket;
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }

    public boolean equals(Object obj) {
        return this.serverSocket.equals(obj);
    }

    public ServerSocketChannel getChannel() {
        return this.serverSocket.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.serverSocket.getInetAddress();
    }

    public int getLocalPort() {
        return this.serverSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.serverSocket.getLocalSocketAddress();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.serverSocket.getReceiveBufferSize();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.serverSocket.getReuseAddress();
    }

    public int getSoTimeout() throws IOException {
        return this.serverSocket.getSoTimeout();
    }

    public int hashCode() {
        return this.serverSocket.hashCode();
    }

    public boolean isBound() {
        return this.serverSocket.isBound();
    }

    public boolean isClosed() {
        return this.serverSocket.isClosed();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.serverSocket.setReceiveBufferSize(size);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.serverSocket.setReuseAddress(on);
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.serverSocket.setSoTimeout(timeout);
    }

    public String toString() {
        return this.serverSocket.toString();
    }
}

