/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.net.DcmServiceException;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.Priority;
import org.dcm4chex.archive.common.UPSState;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.BaseDSQueryCmd;
import org.dcm4chex.archive.ejb.jdbc.Match;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

public class UPSQueryCmd
extends BaseDSQueryCmd {
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    private static final String[] FROM = new String[]{"UPS"};
    private static final String[] SELECT = new String[]{"Patient.encodedAttributes", "UPS.encodedAttributes"};
    private static final String ITEM_CODE = "item_code";

    public UPSQueryCmd(Dataset keys, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue) throws SQLException, DcmServiceException {
        super(keys, true, noMatchForNoValue, transactionIsolationLevel);
        AttributeFilter patAttrFilter = AttributeFilter.getPatientAttributeFilter();
        this.defineColumnTypes(new int[]{blobAccessType, blobAccessType});
        if (!keys.contains(524293)) {
            keys.putCS(524293);
        }
        this.sqlBuilder.setSelect(SELECT);
        this.sqlBuilder.setFrom(FROM);
        this.sqlBuilder.setLeftJoin(this.getLeftJoin());
        this.sqlBuilder.addListOfUidMatch(null, "UPS.sopInstanceUID", false, keys.getStrings(524312));
        String s = keys.getString(7606272);
        if (s != null) {
            this.sqlBuilder.addIntValueMatch(null, "UPS.stateAsInt", false, UPSState.toInt((String)s));
        }
        if ((s = keys.getString(7606784)) != null) {
            this.sqlBuilder.addIntValueMatch(null, "UPS.priorityAsInt", false, Priority.toInt((String)s));
        }
        this.sqlBuilder.addWildCardMatch(null, "UPS.procedureStepLabel", false, keys.getStrings(7606788));
        this.sqlBuilder.addWildCardMatch(null, "UPS.worklistLabel", false, keys.getStrings(7606786));
        this.sqlBuilder.addRangeMatch(null, "UPS.scheduledStartDateTime", false, keys.getDateRange(0x404005));
        this.sqlBuilder.addRangeMatch(null, "UPS.expectedCompletionDateTime", this.type2, keys.getDateRange(0x404011));
        this.sqlBuilder.addCodeMatch(ITEM_CODE, keys.getItem(4210712));
        this.addNestedCodeMatch(0x404004, new String[]{"UPS.pk", "rel_ups_appcode.ups_fk"}, new String[]{"rel_ups_appcode", "Code"}, new String[]{"rel_ups_appcode.appcode_fk", "Code.pk"});
        this.addNestedCodeMatch(4210725, new String[]{"UPS.pk", "rel_ups_devname.ups_fk"}, new String[]{"rel_ups_devname", "Code"}, new String[]{"rel_ups_devname.devname_fk", "Code.pk"});
        this.addNestedCodeMatch(4210726, new String[]{"UPS.pk", "rel_ups_devclass.ups_fk"}, new String[]{"rel_ups_devclass", "Code"}, new String[]{"rel_ups_devclass.devclass_fk", "Code.pk"});
        this.addNestedCodeMatch(4210727, new String[]{"UPS.pk", "rel_ups_devloc.ups_fk"}, new String[]{"rel_ups_devloc", "Code"}, new String[]{"rel_ups_devloc.devloc_fk", "Code.pk"});
        this.addNestedCodeMatch(0x404034, 0x404009, new String[]{"UPS.pk", "rel_ups_performer.ups_fk"}, new String[]{"rel_ups_performer", "Code"}, new String[]{"rel_ups_performer.performer_fk", "Code.pk"});
        this.addRefRequestMatch();
        this.sqlBuilder.addRefSOPMatch(new String[]{"UPS.pk", "UPSRelatedPS.ups_fk"}, "UPSRelatedPS", "UPSRelatedPS.refSOPClassUID", "UPSRelatedPS.refSOPInstanceUID", keys.getItem(7606816), this.type2);
        this.sqlBuilder.addWildCardMatch(null, "UPS.admissionID", this.type2, keys.getStrings(3670032));
        Dataset issuer = keys.getItem(3670036);
        if (issuer != null) {
            this.sqlBuilder.addSingleValueMatch(null, "UPS.issuerOfAdmissionIDLocalNamespaceEntityID", this.type2, issuer.getString(4194353));
            this.sqlBuilder.addSingleValueMatch(null, "UPS.issuerOfAdmissionIDUniversalEntityID", this.type2, issuer.getString(4194354));
        }
        if (this.sqlBuilder.addWildCardMatch(null, "Patient.patientId", this.type2, patAttrFilter.getStrings(keys, 0x100020)) != null) {
            this.sqlBuilder.addSingleValueMatch(null, "Patient.issuerOfPatientId", this.type2, patAttrFilter.getString(keys, 0x100021));
        }
        if (fuzzyMatchingOfPN) {
            try {
                this.sqlBuilder.addPNFuzzyMatch(new String[]{"Patient.patientFamilyNameSoundex", "Patient.patientGivenNameSoundex"}, this.type2, keys.getString(0x100010));
            }
            catch (IllegalArgumentException ex) {
                throw new DcmServiceException(43264, ex.getMessage() + ": " + keys.get(0x100010));
            }
        } else {
            this.sqlBuilder.addPNMatch(new String[]{"Patient.patientName", "Patient.patientIdeographicName", "Patient.patientPhoneticName"}, this.type2, patAttrFilter.isICase(0x100010), keys.getString(0x100010));
        }
        this.sqlBuilder.addRangeMatch(null, "Patient.patientBirthDate", this.type2, keys.getString(0x100030));
        this.sqlBuilder.addWildCardMatch(null, "Patient.patientSex", this.type2, patAttrFilter.getStrings(keys, 0x100040));
    }

    private void addRefRequestMatch() {
        Dataset item = this.keys.getItem(4236144);
        if (item == null || item.isEmpty()) {
            return;
        }
        SqlBuilder subQuery = new SqlBuilder();
        subQuery.setSelect1();
        String[] from = new String[]{"UPSRequest"};
        subQuery.setFrom(from);
        subQuery.addFieldValueMatch(null, "UPS.pk", false, null, "UPSRequest.ups_fk");
        boolean universalMatch = subQuery.addWildCardMatch(null, "UPSRequest.requestedProcedureId", this.type2, item.getStrings(0x401001)) == null;
        universalMatch = subQuery.addWildCardMatch(null, "UPSRequest.accessionNumber", this.type2, item.getStrings(524368)) == null && universalMatch;
        universalMatch = subQuery.addWildCardMatch(null, "UPSRequest.confidentialityCode", this.type2, item.getStrings(4198408)) == null && universalMatch;
        boolean bl = universalMatch = subQuery.addWildCardMatch(null, "UPSRequest.requestingService", this.type2, item.getStrings(3280947)) == null && universalMatch;
        if (universalMatch) {
            return;
        }
        if (!this.type2) {
            this.sqlBuilder.addCorrelatedSubquery(subQuery);
        } else {
            SqlBuilder subQuery2 = new SqlBuilder();
            subQuery2.setSelect1();
            subQuery2.setFrom(from);
            subQuery2.addFieldValueMatch(null, "UPS.pk", false, null, "UPSRequest.ups_fk");
            Match.Subquery match2 = new Match.Subquery(subQuery2, null, null);
            Match.Node notNode = new Match.Node(null, true);
            notNode.addMatch(match2);
            Match.Node orMatch = this.sqlBuilder.addNodeMatch(" OR", false);
            orMatch.addMatch(new Match.Subquery(subQuery, null, null));
            orMatch.addMatch(notNode);
        }
    }

    private void addNestedCodeMatch(int tag, String[] parentRelation, String[] tables, String[] relations) {
        this.addNestedCodeMatch(this.keys.getItem(tag), parentRelation, tables, relations);
    }

    private void addNestedCodeMatch(int tag1, int tag2, String[] parentRelation, String[] tables, String[] relations) {
        Dataset item = this.keys.getItem(tag1);
        if (item != null) {
            this.addNestedCodeMatch(item.getItem(tag2), parentRelation, tables, relations);
        }
    }

    private void addNestedCodeMatch(Dataset item, String[] parentRelation, String[] tables, String[] relations) {
        this.sqlBuilder.addNestedCodeMatch(parentRelation, tables, relations, item, this.type2);
    }

    private String[] getLeftJoin() {
        int index = 4;
        boolean workitem = SqlBuilder.isCodeMatch(this.keys.getItem(4210712));
        if (workitem) {
            index += 4;
        }
        String[] leftJoin = new String[index];
        leftJoin[0] = "Patient";
        leftJoin[1] = null;
        leftJoin[2] = "UPS.patient_fk";
        leftJoin[3] = "Patient.pk";
        index = 4;
        if (workitem) {
            leftJoin[index++] = "Code";
            leftJoin[index++] = ITEM_CODE;
            leftJoin[index++] = "UPS.code_fk";
            leftJoin[index++] = "Code.pk";
        }
        return leftJoin;
    }

    public Dataset getDataset() throws SQLException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(1), (Dataset)ds);
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(2), (Dataset)ds);
        this.adjustDataset(ds, this.keys);
        return ds.subSet(this.keys);
    }
}

