/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.PersonName;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlBuilder {
    public static final boolean TYPE1 = false;
    public static final boolean TYPE2 = true;
    public static final String DESC = " DESC";
    public static final String ASC = " ASC";
    public static final String WHERE = " WHERE ";
    public static final String AND = " AND ";
    private static final String DATE_FORMAT = "''yyyy-MM-dd HH:mm:ss.SSS''";
    private static final String ORA_DATE_FORMAT = "'TO_TIMESTAMP('''yyyy-MM-dd HH:mm:ss.SSS'','''YYYY-MM-DD HH24:MI:SS.FF''')";
    private static final String[] ONE = new String[]{"1"};
    private String[] select;
    private String[] from;
    private String[] aliases;
    private String[] leftJoin;
    private String[] relations;
    private ArrayList<Match> matches = new ArrayList();
    private ArrayList<String> orderby = new ArrayList();
    private int limit = 0;
    private int offset = 0;
    private String whereOrAnd = " WHERE ";
    private boolean distinct = false;
    private boolean subQueryMode = false;
    private boolean matchNotSupported = false;

    SqlBuilder() {
    }

    private static int getDatabase() {
        return JdbcProperties.getInstance().getDatabase();
    }

    public final void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public final void setSubQueryMode(boolean subQuery) {
        this.subQueryMode = subQuery;
    }

    public void setSelect(String[] fields) {
        this.select = JdbcProperties.getInstance().getProperties(fields);
    }

    public void setFieldNamesForSelect(String[] fields) {
        this.select = fields;
    }

    public void setSelect1() {
        this.select = ONE;
    }

    public void setSelectCount(String[] fields, boolean distinct) {
        StringBuffer sb = new StringBuffer();
        sb.append("count(");
        if (distinct) {
            sb.append("DISTINCT ");
        }
        JdbcProperties jdbcProps = JdbcProperties.getInstance();
        if (fields == null || fields.length < 1) {
            sb.append('*');
        } else {
            sb.append(jdbcProps.getProperty(fields[0]));
            for (int i = 1; i < fields.length; ++i) {
                sb.append(',').append(jdbcProps.getProperty(fields[i]));
            }
        }
        sb.append(')');
        this.select = new String[]{sb.toString()};
    }

    public void setFrom(String[] entities) {
        JdbcProperties jp = JdbcProperties.getInstance();
        this.from = jp.getProperties(entities);
    }

    public void setAliases(String[] aliases) {
        if (aliases != null) {
            if (aliases.length != this.from.length) {
                throw new IllegalArgumentException("aliases.length != from.length");
            }
            if (this.relations != null) {
                throw new IllegalStateException("relations != null");
            }
        }
        this.aliases = aliases;
    }

    public void setSubquery(SqlBuilder subQuery) {
        this.from = new String[]{"(" + subQuery.getSql() + ")"};
    }

    public void setLeftJoin(String[] leftJoin) {
        if (leftJoin == null) {
            this.leftJoin = null;
            return;
        }
        if (leftJoin.length % 4 != 0) {
            throw new IllegalArgumentException("" + Arrays.asList(leftJoin));
        }
        this.leftJoin = JdbcProperties.getInstance().getProperties(leftJoin);
        int n = leftJoin.length / 4;
        for (int i = 0; i < n; ++i) {
            int i4 = 4 * i;
            String alias = this.leftJoin[i4 + 1];
            if (alias == null) continue;
            String col = this.leftJoin[i4 + 3];
            this.leftJoin[i4 + 3] = alias + col.substring(col.indexOf(46));
        }
    }

    public void addOrderBy(String field, String order) {
        this.orderby.add(JdbcProperties.getInstance().getProperty(field) + order);
    }

    public final void setLimit(int limit) {
        this.limit = Math.max(0, limit);
    }

    public final void setOffset(int offset) {
        this.offset = Math.max(0, offset);
    }

    public void setRelations(String[] relations) {
        if (relations == null) {
            this.relations = null;
            return;
        }
        if (this.aliases != null) {
            throw new IllegalArgumentException("aliases != null");
        }
        if ((relations.length & 1) != 0) {
            throw new IllegalArgumentException("relations[" + relations.length + "]");
        }
        this.relations = JdbcProperties.getInstance().getProperties(relations);
    }

    protected ArrayList<Match> getMatches() {
        return this.matches;
    }

    protected void setMatches(ArrayList<Match> matches) {
        if (matches == null) {
            this.matches.clear();
        } else {
            this.matches = matches;
        }
    }

    private Match addMatch(Match match) {
        if (match.isUniveralMatch()) {
            return null;
        }
        this.matches.add(match);
        return match;
    }

    public Match addNULLValueMatch(String alias, String field, boolean inverter) {
        return this.addMatch(new Match.NULLValue(alias, field, inverter));
    }

    public Match addIntValueMatch(String alias, String field, boolean type2, int value) {
        return this.addMatch(new Match.IntValue(alias, field, type2, value));
    }

    public Match addListOfIntMatch(String alias, String field, boolean type2, int[] values) {
        return this.addMatch(new Match.ListOfInt(alias, field, type2, values));
    }

    public Match addSingleValueMatch(String alias, String field, boolean type2, String value) {
        return this.addMatch(new Match.SingleValue(alias, field, type2, value));
    }

    public Match addFieldValueMatch(String alias1, String field1, boolean type2, String alias2, String field2) {
        return this.addMatch(new Match.FieldValue(alias1, field1, type2, alias2, field2));
    }

    public Match addLiteralMatch(String alias, String field, boolean type2, String literal) {
        return this.addMatch(new Match.AppendLiteral(alias, field, type2, literal));
    }

    public Match addBooleanMatch(String alias, String field, boolean type2, boolean value) {
        return this.addMatch(this.getBooleanMatch(alias, field, type2, value));
    }

    public Match getBooleanMatch(String alias, String field, boolean type2, boolean value) {
        return new Match.AppendLiteral(alias, field, type2, this.toBooleanLiteral(value));
    }

    private String toBooleanLiteral(boolean value) {
        switch (SqlBuilder.getDatabase()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return value ? " != 0" : " = 0";
            }
        }
        return value ? " = true" : " = false";
    }

    public Match addListOfUidMatch(String alias, String field, boolean type2, String[] uids) {
        return this.addListOfStringMatch(alias, field, type2, uids);
    }

    public Match addListOfStringMatch(String alias, String field, boolean type2, String[] vals) {
        return this.addMatch(new Match.ListOfString(alias, field, type2, vals));
    }

    public Match addWildCardMatch(String alias, String field, boolean type2, String wc) {
        if (wc == null || wc.length() == 0 || wc.equals("*")) {
            return null;
        }
        return this.addMatch(new Match.WildCard(alias, field, type2, wc));
    }

    public Match addWildCardMatch(String alias, String field, boolean type2, String[] vals) {
        if (vals == null || vals.length == 0) {
            return null;
        }
        if (vals.length > 1) {
            if (this.containsWildCard(vals)) {
                this.matchNotSupported = true;
                return null;
            }
            return this.addListOfStringMatch(alias, field, type2, vals);
        }
        return this.addWildCardMatch(alias, field, type2, vals[0]);
    }

    private boolean containsWildCard(String[] wc) {
        for (int i = 0; i < wc.length; ++i) {
            if (wc[i].indexOf(42) == -1 && wc[i].indexOf(63) == -1) continue;
            return true;
        }
        return false;
    }

    public void addPNMatch(String[] nameFields, boolean type2, boolean icase, String val) {
        PersonName ppn;
        if (val == null || val.length() == 0 || val.equals("*")) {
            return;
        }
        PersonName pn = DcmObjectFactory.getInstance().newPersonName(val);
        String pnalpha = pn.toComponentGroupMatch();
        this.addWildCardMatch(null, nameFields[0], type2, icase ? pnalpha.toUpperCase() : pnalpha);
        PersonName ipn = pn.getIdeographic();
        if (ipn != null) {
            this.addWildCardMatch(null, nameFields[1], type2, ipn.toComponentGroupMatch());
        }
        if ((ppn = pn.getPhonetic()) != null) {
            this.addWildCardMatch(null, nameFields[2], type2, ppn.toComponentGroupMatch());
        }
    }

    public void addPNFuzzyMatch(String[] fields, boolean type2, String val) {
        if (val == null || val.length() == 0 || val.equals("*")) {
            return;
        }
        this.addMatch(new Match.PNFuzzy(fields, type2, DcmObjectFactory.getInstance().newPersonName(val)));
    }

    public boolean isMatchNotSupported() {
        return this.matchNotSupported;
    }

    public Match addRangeMatch(String alias, String field, boolean type2, Date[] range) {
        return this.addMatch(this.getRangeMatch(alias, field, type2, range));
    }

    public Match getRangeMatch(String alias, String field, boolean type2, Date[] range) {
        return new Match.Range(alias, field, type2, range, SqlBuilder.getDatabase() == 4 ? ORA_DATE_FORMAT : DATE_FORMAT);
    }

    public Match addRangeMatch(String alias, String field, boolean type2, String range) {
        if (range == null) {
            return null;
        }
        int hypen = range.indexOf(45);
        if (hypen == -1) {
            return this.addWildCardMatch(alias, field, type2, range);
        }
        return this.addMatch(new Match.StringRange(alias, field, type2, new String[]{hypen != 0 ? range.substring(0, hypen) : null, hypen + 1 < range.length() ? range.substring(hypen + 1) : null}));
    }

    public Match addModalitiesInStudyNestedMatch(String alias, String[] mds) {
        return mds != null && mds.length == 1 ? this.addMatch(new Match.ModalitiesInStudyNestedMatch(alias, mds[0])) : this.addMatch(new Match.ModalitiesInStudyMultiNestedMatch(alias, mds));
    }

    public Match addCallingAETsNestedMatch(boolean privateTables, String[] callingAETs) {
        return this.addMatch(new Match.CallingAETsNestedMatch(privateTables, callingAETs));
    }

    public Match addQueryPermissionNestedMatch(boolean patientLevel, boolean checkForNoStudy, String[] roles) {
        return this.addMatch(new Match.QueryPermissionNestedMatch(patientLevel, checkForNoStudy, roles));
    }

    public Match.Node addNodeMatch(String orORand, boolean invert) {
        Match.Node m = new Match.Node(orORand, invert);
        this.addMatch(m);
        return m;
    }

    public Match addCorrelatedSubquery(SqlBuilder subQuery) {
        return this.addMatch(new Match.Subquery(subQuery, null, null));
    }

    public Match addUncorrelatedSubquery(SqlBuilder subQuery, String field, String alias) {
        return this.addMatch(new Match.Subquery(subQuery, field, alias));
    }

    public String getSql() {
        if (this.select == null) {
            throw new IllegalStateException("select not initalized");
        }
        if (this.from == null) {
            throw new IllegalStateException("from not initalized");
        }
        StringBuffer sb = new StringBuffer("SELECT ");
        if (this.limit > 0 || this.offset > 0) {
            this.appendLimitbeforeFrom(sb);
        } else {
            if (this.distinct) {
                sb.append("DISTINCT ");
            }
            this.appendTo(sb, this.select);
        }
        sb.append(" FROM ");
        this.appendInnerJoinsToFrom(sb);
        this.appendLeftJoinToFrom(sb);
        this.whereOrAnd = WHERE;
        this.appendInnerJoinsToWhere(sb);
        this.appendLeftJoinToWhere(sb);
        this.appendMatchesTo(sb);
        if (!this.orderby.isEmpty()) {
            sb.append(" ORDER BY ");
            this.appendTo(sb, this.orderby.toArray(new String[this.orderby.size()]));
        }
        if (this.limit > 0 || this.offset > 0) {
            this.appendLimitAtEnd(sb);
        }
        if (SqlBuilder.getDatabase() == 3 && !this.subQueryMode) {
            sb.append(" FOR READ ONLY");
        }
        return sb.toString();
    }

    public StringBuffer appendLimitbeforeFrom(StringBuffer sb) {
        if (this.distinct && SqlBuilder.getDatabase() != 6 && SqlBuilder.getDatabase() != 0) {
            sb.append("DISTINCT ");
        }
        switch (SqlBuilder.getDatabase()) {
            case 0: {
                sb.append("LIMIT ");
                sb.append(this.offset);
                sb.append(" ");
                sb.append(this.limit);
                sb.append(" ");
                if (this.distinct) {
                    sb.append("DISTINCT ");
                }
                this.appendTo(sb, this.select);
                break;
            }
            case 3: {
                sb.append("* FROM ( SELECT ");
                this.appendTo(sb, this.select);
                sb.append(", ROW_NUMBER() OVER (ORDER BY ");
                this.appendTo(sb, this.orderby.toArray(new String[this.orderby.size()]));
                sb.append(") AS rownum ");
                break;
            }
            case 4: {
                sb.append("* FROM ( SELECT ");
                this.appendTo(sb, this.selectC1C2CN());
                sb.append(", ROWNUM as r1 FROM ( SELECT ");
                this.appendTo(sb, this.selectAsC1C2CN());
                break;
            }
            case 5: {
                if (!this.orderby.isEmpty()) {
                    sb.append("* FROM ( SELECT TOP ").append(this.limit).append(' ');
                    this.appendTo(sb, this.selectC1C2CN());
                    sb.append(',');
                    this.appendTo(sb, this.selectSort());
                    sb.append(" FROM ( SELECT TOP ").append(this.limit + this.offset).append(' ');
                    this.appendTo(sb, this.selectAsC1C2CN());
                    sb.append(',');
                    this.appendTo(sb, this.selectOrderByAsSort());
                    break;
                }
                throw new IllegalArgumentException("LIMIT OFFSET feature needs order by in MS SQL Server!!");
            }
            case 6: {
                sb.append("FIRST ");
                sb.append(this.limit);
                sb.append(" SKIP ");
                sb.append(this.offset);
                sb.append(" ");
                if (this.distinct) {
                    sb.append("DISTINCT ");
                }
                this.appendTo(sb, this.select);
                break;
            }
            default: {
                this.appendTo(sb, this.select);
            }
        }
        return sb;
    }

    public StringBuffer appendLimitAtEnd(StringBuffer sb) {
        switch (SqlBuilder.getDatabase()) {
            case 1: 
            case 2: {
                sb.append(" LIMIT ");
                sb.append(this.limit);
                sb.append(" OFFSET ");
                sb.append(this.offset);
                break;
            }
            case 3: {
                sb.append(" ) AS foo WHERE rownum > ");
                sb.append(this.offset);
                sb.append(" AND rownum <= ");
                sb.append(this.offset + this.limit);
                break;
            }
            case 4: {
                sb.append(" ) WHERE ROWNUM <= ");
                sb.append(this.offset + this.limit);
                sb.append(" ) WHERE r1 > ");
                sb.append(this.offset);
                break;
            }
            case 5: {
                sb.append(") AS loTemp1 ORDER BY ");
                this.appendTo(sb, this.getOrderByWithSort(true));
                sb.append(") AS loTemp2 ORDER BY ");
                this.appendTo(sb, this.getOrderByWithSort(false));
            }
        }
        return sb;
    }

    private String[] getOrderByWithSort(boolean invert) {
        String[] inverted = new String[this.orderby.size()];
        for (int i = 0; i < inverted.length; ++i) {
            int pos = this.orderby.get(i).lastIndexOf(ASC);
            inverted[i] = "sort" + (i + 1) + (pos == -1 ^ invert ? DESC : ASC);
        }
        return inverted;
    }

    private String[] selectC1C2CN() {
        String[] retval = new String[this.select.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = "c" + (i + 1);
        }
        return retval;
    }

    private String[] selectAsC1C2CN() {
        String[] retval = new String[this.select.length];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = this.select[i] + " AS c" + (i + 1);
        }
        return retval;
    }

    private String[] selectSort() {
        String[] retval = new String[this.orderby.size()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = "sort" + (i + 1);
        }
        return retval;
    }

    private String[] selectOrderByAsSort() {
        String[] retval = new String[this.orderby.size()];
        for (int i = 0; i < retval.length; ++i) {
            String s = this.orderby.get(i);
            retval[i] = s.substring(0, s.lastIndexOf(32)) + " AS sort" + (i + 1);
        }
        return retval;
    }

    private StringBuffer appendTo(StringBuffer sb, String[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(a[i]);
        }
        return sb;
    }

    private void appendLeftJoinToFrom(StringBuffer sb) {
        if (this.leftJoin == null) {
            return;
        }
        int n = this.leftJoin.length / 4;
        for (int i = 0; i < n; ++i) {
            int i4 = 4 * i;
            if (SqlBuilder.getDatabase() == 4) {
                sb.append(", ");
                sb.append(this.leftJoin[i4]);
                if (this.leftJoin[i4 + 1] == null) continue;
                sb.append(" ");
                sb.append(this.leftJoin[i4 + 1]);
                continue;
            }
            sb.append(" LEFT JOIN ");
            sb.append(this.leftJoin[i4]);
            if (this.leftJoin[i4 + 1] != null) {
                sb.append(" AS ");
                sb.append(this.leftJoin[i4 + 1]);
            }
            sb.append(" ON (");
            sb.append(this.leftJoin[i4 + 2]);
            sb.append(" = ");
            sb.append(this.leftJoin[i4 + 3]);
            sb.append(")");
        }
    }

    private void appendLeftJoinToWhere(StringBuffer sb) {
        if (this.leftJoin == null || SqlBuilder.getDatabase() != 4) {
            return;
        }
        int n = this.leftJoin.length / 4;
        for (int i = 0; i < n; ++i) {
            int i4 = 4 * i;
            sb.append(this.whereOrAnd);
            this.whereOrAnd = AND;
            sb.append(this.leftJoin[i4 + 2]);
            sb.append(" = ");
            sb.append(this.leftJoin[i4 + 3]);
            sb.append("(+)");
        }
    }

    private void appendInnerJoinsToFrom(StringBuffer sb) {
        if (this.relations == null || SqlBuilder.getDatabase() == 4) {
            for (int i = 0; i < this.from.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.from[i]);
                if (this.aliases == null || this.aliases[i] == null) continue;
                sb.append(' ').append(this.aliases[i]);
            }
        } else {
            sb.append(this.from[0]);
            int n = this.relations.length / 2;
            for (int i = 0; i < n; ++i) {
                int i2 = 2 * i;
                sb.append(" INNER JOIN ");
                sb.append(this.from[i + 1]);
                sb.append(" ON (");
                sb.append(this.relations[i2]);
                sb.append(" = ");
                sb.append(this.relations[i2 + 1]);
                sb.append(")");
            }
        }
    }

    private void appendInnerJoinsToWhere(StringBuffer sb) {
        if (this.relations == null || SqlBuilder.getDatabase() != 4) {
            return;
        }
        int n = this.relations.length / 2;
        for (int i = 0; i < n; ++i) {
            int i2 = 2 * i;
            sb.append(this.whereOrAnd);
            this.whereOrAnd = AND;
            sb.append(this.relations[i2]);
            sb.append(" = ");
            sb.append(this.relations[i2 + 1]);
        }
    }

    private void appendMatchesTo(StringBuffer sb) {
        if (this.matches == null) {
            return;
        }
        for (int i = 0; i < this.matches.size(); ++i) {
            sb.append(this.whereOrAnd);
            this.whereOrAnd = AND;
            this.matches.get(i).appendTo(sb);
        }
    }

    public static boolean isCodeMatch(Dataset item) {
        return item != null && !item.isEmpty() && (item.containsValue(524544) || item.containsValue(524546) || item.containsValue(524547));
    }

    public boolean addCodeMatch(String alias, Dataset item) {
        if (item == null || item.isEmpty()) {
            return false;
        }
        boolean universalMatch = this.addSingleValueMatch(alias, "Code.codeValue", false, item.getString(524544)) == null;
        universalMatch = this.addSingleValueMatch(alias, "Code.codingSchemeDesignator", false, item.getString(524546)) == null && universalMatch;
        universalMatch = this.addSingleValueMatch(alias, "Code.codingSchemeVersion", false, item.getString(524547)) == null && universalMatch;
        return !universalMatch;
    }

    public void addNestedCodeMatch(String[] parentRelations, String[] tables, String[] relations, Dataset item, boolean type2) {
        if (item == null || item.isEmpty()) {
            return;
        }
        SqlBuilder subQuery = new SqlBuilder();
        subQuery.setSelect1();
        subQuery.setFrom(tables);
        subQuery.setRelations(relations);
        if (!subQuery.addCodeMatch(null, item)) {
            return;
        }
        Match.Subquery match = new Match.Subquery(subQuery, null, null);
        if (!type2) {
            this.addMatch(match);
        } else {
            SqlBuilder subQuery2 = new SqlBuilder();
            subQuery2.setSelect1();
            subQuery2.setFrom(new String[]{tables[0]});
            subQuery2.addFieldValueMatch(null, parentRelations[0], false, null, parentRelations[1]);
            Match.Subquery match2 = new Match.Subquery(subQuery2, null, null);
            Match.Node notNode = new Match.Node(null, true);
            notNode.addMatch(match2);
            Match.Node orMatch = this.addNodeMatch(" OR", false);
            orMatch.addMatch(match);
            orMatch.addMatch(notNode);
        }
    }

    public void addRefSOPMatch(String[] parentRelations, String table, String cuidField, String iuidField, Dataset item, boolean type2) {
        if (item == null || item.isEmpty()) {
            return;
        }
        SqlBuilder subQuery = new SqlBuilder();
        subQuery.setSelect1();
        String[] tables = new String[]{table};
        subQuery.setFrom(tables);
        subQuery.addFieldValueMatch(null, parentRelations[0], false, null, parentRelations[1]);
        boolean universalMatch = subQuery.addSingleValueMatch(null, cuidField, false, item.getString(528720)) == null;
        boolean bl = universalMatch = subQuery.addSingleValueMatch(null, iuidField, false, item.getString(528725)) == null && universalMatch;
        if (universalMatch) {
            return;
        }
        Match.Subquery match = new Match.Subquery(subQuery, null, null);
        if (!type2) {
            this.addMatch(match);
        } else {
            SqlBuilder subQuery2 = new SqlBuilder();
            subQuery2.setSelect1();
            subQuery2.setFrom(tables);
            subQuery2.addFieldValueMatch(null, parentRelations[0], false, null, parentRelations[1]);
            Match.Subquery match2 = new Match.Subquery(subQuery2, null, null);
            Match.Node notNode = new Match.Node(null, true);
            notNode.addMatch(match2);
            Match.Node orMatch = this.addNodeMatch(" OR", false);
            orMatch.addMatch(match);
            orMatch.addMatch(notNode);
        }
    }
}

