/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

public class RetrieveStudyDatesCmd
extends BaseReadCmd {
    public static int transactionIsolationLevel = 0;
    private static final String[] SELECT_ATTRIBUTE = new String[]{"Patient.updatedTime", "Study.updatedTime", "Series.updatedTime", "Instance.updatedTime", "Patient.createdTime", "Study.createdTime", "Series.createdTime", "Instance.createdTime"};
    private static final String[] ENTITY = new String[]{"Patient", "Study", "Series", "Instance"};
    private static final String[] RELATIONS = new String[]{"Patient.pk", "Study.patient_fk", "Study.pk", "Series.study_fk", "Series.pk", "Instance.series_fk"};

    public static RetrieveStudyDatesCmd create(Dataset keys) throws SQLException {
        String qrLevel = keys.getString(524370);
        if (qrLevel == null || qrLevel.length() == 0) {
            throw new IllegalArgumentException("Missing QueryRetrieveLevel");
        }
        if ("IMAGE".equals(qrLevel)) {
            return new RetrieveStudyDatesCmd(new ImageSql(keys).getSql());
        }
        if ("SERIES".equals(qrLevel)) {
            return new RetrieveStudyDatesCmd(new SeriesSql(keys, true).getSql());
        }
        if ("STUDY".equals(qrLevel)) {
            return new RetrieveStudyDatesCmd(new StudySql(keys, true).getSql());
        }
        if ("PATIENT".equals(qrLevel)) {
            return new RetrieveStudyDatesCmd(new PatientSql(keys, true).getSql());
        }
        throw new IllegalArgumentException("QueryRetrieveLevel=" + qrLevel);
    }

    protected RetrieveStudyDatesCmd(String sql) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel, 1004);
        this.execute(sql);
    }

    public Date getMostRecentUpdatedTime() throws SQLException {
        return this.getBoundary(1, 4, false);
    }

    public Date getMostRecentCreatedTime() throws SQLException {
        return this.getBoundary(5, 8, false);
    }

    public Date getEldestUpdatedTime() throws SQLException {
        return this.getBoundary(1, 4, true);
    }

    public Date getEldestCreatedTime() throws SQLException {
        return this.getBoundary(5, 8, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date getBoundary(int startIdx, int endIdx, boolean eldest) throws SQLException {
        try {
            this.rs.beforeFirst();
            if (!this.next()) {
                Date date = null;
                return date;
            }
            ++endIdx;
            Timestamp date = this.rs.getTimestamp(startIdx);
            this.rs.beforeFirst();
            while (this.next()) {
                for (int i = startIdx; i < endIdx; ++i) {
                    Timestamp mrDate = this.rs.getTimestamp(i);
                    date = eldest ? (mrDate.before((Date)date) ? mrDate : date) : (mrDate.after((Date)date) ? mrDate : date);
                }
            }
            Timestamp timestamp = date;
            return timestamp;
        }
        finally {
            this.close();
        }
    }

    public Date[] getUpdatedTimes(int row) throws SQLException {
        this.rs.absolute(row);
        if (this.rs.isAfterLast() || this.rs.isBeforeFirst()) {
            return null;
        }
        Date[] dates = new Date[]{this.rs.getTimestamp(1), this.rs.getTimestamp(2), this.rs.getTimestamp(3), this.rs.getTimestamp(4)};
        return dates;
    }

    public Date[] getCreatedTimes(int row) throws SQLException {
        this.rs.absolute(row);
        if (this.rs.isAfterLast() || this.rs.isBeforeFirst()) {
            return null;
        }
        Date[] dates = new Date[]{this.rs.getTimestamp(5), this.rs.getTimestamp(6), this.rs.getTimestamp(7), this.rs.getTimestamp(8)};
        return dates;
    }

    private static class RefSOPSql
    extends Sql {
        RefSOPSql(DcmElement refSOPSeq) {
            String[] uid = new String[refSOPSeq.countItems()];
            for (int i = 0; i < uid.length; ++i) {
                uid[i] = refSOPSeq.getItem(i).getString(528725);
            }
            this.sqlBuilder.addListOfUidMatch(null, "Instance.sopIuid", false, uid);
        }
    }

    private static class ImageSql
    extends SeriesSql {
        ImageSql(Dataset keys) {
            super(keys, false);
            String[] uid = keys.getStrings(524312);
            if (uid == null || uid.length == 0) {
                throw new IllegalArgumentException("Missing SOPInstanceUID");
            }
            this.sqlBuilder.addListOfUidMatch(null, "Instance.sopIuid", false, uid);
        }
    }

    private static class SeriesSql
    extends StudySql {
        SeriesSql(Dataset keys, boolean seriesRetrieve) {
            super(keys, false);
            String[] uid = keys.getStrings(0x20000E);
            if (uid != null && uid.length != 0) {
                this.sqlBuilder.addListOfUidMatch(null, "Series.seriesIuid", false, uid);
            } else if (seriesRetrieve) {
                throw new IllegalArgumentException("Missing SeriesInstanceUID");
            }
        }
    }

    private static class StudySql
    extends PatientSql {
        StudySql(Dataset keys, boolean studyRetrieve) {
            super(keys, false);
            String[] uid = keys.getStrings(0x20000D);
            if (uid != null && uid.length != 0) {
                this.sqlBuilder.addListOfUidMatch(null, "Study.studyIuid", false, uid);
            } else if (studyRetrieve) {
                throw new IllegalArgumentException("Missing StudyInstanceUID");
            }
        }
    }

    private static class PatientSql
    extends Sql {
        PatientSql(Dataset keys, boolean patientRetrieve) {
            String pid = keys.getString(0x100020);
            if (pid != null) {
                this.sqlBuilder.addWildCardMatch(null, "Patient.patientId", true, pid);
            } else if (patientRetrieve) {
                throw new IllegalArgumentException("Missing PatientID");
            }
        }
    }

    private static class Sql {
        final SqlBuilder sqlBuilder = new SqlBuilder();

        Sql() {
            this.sqlBuilder.setSelect(SELECT_ATTRIBUTE);
            this.sqlBuilder.setFrom(ENTITY);
            this.sqlBuilder.setRelations(RELATIONS);
        }

        public final String getSql() {
            return this.sqlBuilder.getSql();
        }
    }
}

