/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4chex.archive.ejb.jdbc.BaseCmd;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.FileInfo;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.Match;
import org.dcm4chex.archive.ejb.jdbc.QueryCmd;
import org.dcm4chex.archive.ejb.jdbc.QuerySeriesAttrsForRetrieveCmd;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

public class RetrieveCmd
extends BaseReadCmd {
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    public static int seriesBlobAccessType = 2004;
    public static boolean lazyFetchSeriesAttrs = false;
    public static boolean cacheSeriesAttrs = true;
    public static long seriesAttrsCacheCurrencyTimeLimit = 600000L;
    private static int seriesAttrsCacheMaxSize = 100;
    private static Map<String, SeriesAttrsCacheEntry> seriesAttrsCache = Collections.synchronizedMap(new LinkedHashMap<String, SeriesAttrsCacheEntry>(){
        private static final long serialVersionUID = -3342074672179596774L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SeriesAttrsCacheEntry> eldest) {
            if (this.size() >= seriesAttrsCacheMaxSize) {
                if (BaseCmd.log.isDebugEnabled()) {
                    BaseCmd.log.debug((Object)("Remove Series attributes for Series " + eldest.getValue().fileInfo.seriesIUID + " from cache"));
                }
                return true;
            }
            return false;
        }
    });
    public static int maxElementsInUIDMatch = 100;
    private static final String[] ENTITY = new String[]{"Patient", "Study", "Series", "Instance"};
    private static final String[] ENTITY_NO_LEFT_JOIN = new String[]{"Patient", "Study", "Series", "Instance", "File", "FileSystem"};
    private static final String[] LEFT_JOIN = new String[]{"File", null, "Instance.pk", "File.instance_fk", "FileSystem", null, "File.filesystem_fk", "FileSystem.pk"};
    private static final String[] RELATIONS = new String[]{"Patient.pk", "Study.patient_fk", "Study.pk", "Series.study_fk", "Series.pk", "Instance.series_fk"};
    private static final String[] RELATIONS_NO_LEFT_JOIN = new String[]{"Patient.pk", "Study.patient_fk", "Study.pk", "Series.study_fk", "Series.pk", "Instance.series_fk", "Instance.pk", "File.instance_fk", "File.filesystem_fk", "FileSystem.pk"};
    private static String[] entity = ENTITY;
    private static String[] leftJoin = LEFT_JOIN;
    private static String[] relations = RELATIONS;
    private Sql sqlCmd;

    public static boolean isNoLeftJoin() {
        return leftJoin == null;
    }

    public static int getSeriesAttrsCacheMaxSize() {
        return seriesAttrsCacheMaxSize;
    }

    public static void setSeriesAttrsCacheMaxSize(int maxSize) {
        int toRemove = seriesAttrsCache.size() - maxSize;
        if (toRemove > 0) {
            Iterator<Map.Entry<String, SeriesAttrsCacheEntry>> iterator = seriesAttrsCache.entrySet().iterator();
            while (toRemove > 0) {
                iterator.next();
                iterator.remove();
                --toRemove;
            }
        }
        seriesAttrsCacheMaxSize = maxSize;
    }

    public static void setNoLeftJoin(boolean noleftJoin) {
        if (noleftJoin) {
            entity = ENTITY_NO_LEFT_JOIN;
            leftJoin = null;
            relations = RELATIONS_NO_LEFT_JOIN;
        } else {
            entity = ENTITY;
            leftJoin = LEFT_JOIN;
            relations = RELATIONS;
        }
    }

    public static RetrieveCmd create(Dataset keys) throws SQLException {
        String qrLevel = keys.getString(524370);
        if (qrLevel == null || qrLevel.length() == 0) {
            throw new IllegalArgumentException("Missing QueryRetrieveLevel");
        }
        if ("IMAGE".equals(qrLevel)) {
            return RetrieveCmd.createInstanceRetrieve(keys);
        }
        if ("SERIES".equals(qrLevel)) {
            return RetrieveCmd.createSeriesRetrieve(keys);
        }
        if ("STUDY".equals(qrLevel)) {
            return RetrieveCmd.createStudyRetrieve(keys);
        }
        if ("PATIENT".equals(qrLevel)) {
            return RetrieveCmd.createPatientRetrieve(keys);
        }
        throw new IllegalArgumentException("QueryRetrieveLevel=" + qrLevel);
    }

    public static RetrieveCmd createPatientRetrieve(Dataset keys) throws SQLException {
        return new RetrieveCmd(new PatientSql(keys, true));
    }

    public static RetrieveCmd createStudyRetrieve(Dataset keys) throws SQLException {
        return new RetrieveCmd(new StudySql(keys, true));
    }

    public static RetrieveCmd createSeriesRetrieve(Dataset keys) throws SQLException {
        return new RetrieveCmd(new SeriesSql(keys, true));
    }

    public static RetrieveCmd createInstanceRetrieve(Dataset keys) throws SQLException {
        return new ImageRetrieveCmd(new ImageSql(keys), keys.getStrings(524312));
    }

    public static RetrieveCmd create(DcmElement refSOPSeq) throws SQLException {
        return new RetrieveCmd(new RefSOPSql(refSOPSeq));
    }

    protected RetrieveCmd(Sql sql) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel, sql.getSql());
        int[] nArray;
        if (lazyFetchSeriesAttrs) {
            int[] nArray2 = new int[16];
            nArray2[0] = blobAccessType;
            nArray2[1] = 12;
            nArray2[2] = -5;
            nArray2[3] = 12;
            nArray2[4] = 12;
            nArray2[5] = 12;
            nArray2[6] = -5;
            nArray2[7] = 12;
            nArray2[8] = 4;
            nArray2[9] = 12;
            nArray2[10] = 12;
            nArray2[11] = 12;
            nArray2[12] = 12;
            nArray2[13] = 12;
            nArray2[14] = 4;
            nArray = nArray2;
            nArray2[15] = 4;
        } else {
            int[] nArray3 = new int[22];
            nArray3[0] = blobAccessType;
            nArray3[1] = 12;
            nArray3[2] = blobAccessType;
            nArray3[3] = blobAccessType;
            nArray3[4] = blobAccessType;
            nArray3[5] = 12;
            nArray3[6] = 12;
            nArray3[7] = 12;
            nArray3[8] = -5;
            nArray3[9] = 12;
            nArray3[10] = 12;
            nArray3[11] = 12;
            nArray3[12] = -5;
            nArray3[13] = 12;
            nArray3[14] = 4;
            nArray3[15] = 12;
            nArray3[16] = 12;
            nArray3[17] = 12;
            nArray3[18] = 12;
            nArray3[19] = 12;
            nArray3[20] = 4;
            nArray = nArray3;
            nArray3[21] = 4;
        }
        this.defineColumnTypes(nArray);
        this.sqlCmd = sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo[][] getFileInfos() throws SQLException {
        Map result = this.map();
        try {
            PreparedStatement pstmt = (PreparedStatement)this.stmt;
            if (this.fetchSize > 0) {
                pstmt.setFetchSize(this.fetchSize);
            }
            int start = 0;
            String[] fixParams = this.sqlCmd.getFixParams();
            for (int i = 0; i < fixParams.length; ++i) {
                pstmt.setString(i + 1, fixParams[i]);
            }
            int firstListIdx = fixParams.length;
            String[] params = this.sqlCmd.getParams();
            if (params != null) {
                int len = this.sqlCmd.getNumberOfParams();
                while (start < params.length) {
                    int i;
                    if (start + len > params.length) {
                        len = params.length - start;
                        this.sqlCmd.updateUIDMatch(len);
                        pstmt = this.con.prepareStatement(this.sqlCmd.getSql(), this.resultSetType, 1007);
                        if (firstListIdx > 0) {
                            for (i = 0; i < fixParams.length; ++i) {
                                pstmt.setString(i + 1, fixParams[i]);
                            }
                        }
                    }
                    for (i = 1; i <= len; ++i) {
                        pstmt.setString(firstListIdx + i, params[start++]);
                    }
                    this.rs = pstmt.executeQuery();
                    this.addFileInfos(result);
                }
            } else {
                this.rs = pstmt.executeQuery();
                this.addFileInfos(result);
            }
            log.trace((Object)"getFileInfos finished!");
        }
        finally {
            log.trace((Object)"getFileInfos: Close Connection.");
            this.close();
            log.trace((Object)"getFileInfos: Connection closed.");
        }
        return this.toArray(result);
    }

    private void addFileInfos(Map result) throws SQLException {
        while (this.next()) {
            if (lazyFetchSeriesAttrs) {
                this.addFileInfoWithLazyFetchSeriesAttrs(result);
                continue;
            }
            this.addFileInfoWithEagerFetchSeriesAttrs(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileInfoWithLazyFetchSeriesAttrs(Map result) throws SQLException {
        FileInfo info = new FileInfo();
        info.instAttrs = this.rs.getBytes(1);
        info.seriesIUID = this.rs.getString(2);
        long instPk = this.rs.getLong(3);
        info.sopIUID = this.rs.getString(4);
        info.sopCUID = this.rs.getString(5);
        info.extRetrieveAET = this.rs.getString(6);
        info.pk = this.rs.getLong(7);
        info.fileRetrieveAET = this.rs.getString(8);
        info.availability = this.rs.getInt(9);
        info.basedir = this.rs.getString(10);
        info.fsGroupID = this.rs.getString(11);
        info.fileID = this.rs.getString(12);
        info.tsUID = this.rs.getString(13);
        info.md5 = this.rs.getString(14);
        info.size = this.rs.getInt(15);
        info.status = this.rs.getInt(16);
        FileInfo seriesFileInfo = RetrieveCmd.getCachedSeriesAttrs(info.seriesIUID);
        if (seriesFileInfo == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lazy fetch Series attributes for Series " + info.seriesIUID));
            }
            QuerySeriesAttrsForRetrieveCmd seriesQuery = new QuerySeriesAttrsForRetrieveCmd(QueryCmd.transactionIsolationLevel, QueryCmd.seriesBlobAccessType, info.seriesIUID);
            try {
                seriesQuery.execute();
                seriesQuery.next();
                seriesFileInfo = seriesQuery.getFileInfo();
            }
            finally {
                seriesQuery.close();
            }
            seriesAttrsCache.put(info.seriesIUID, new SeriesAttrsCacheEntry(seriesFileInfo));
        }
        info.patAttrs = seriesFileInfo.patAttrs;
        info.studyAttrs = seriesFileInfo.studyAttrs;
        info.seriesAttrs = seriesFileInfo.seriesAttrs;
        info.patID = seriesFileInfo.patID;
        info.patName = seriesFileInfo.patName;
        info.studyIUID = seriesFileInfo.studyIUID;
        this.addFileInfo(result, instPk, info.sopIUID, info);
    }

    private static FileInfo getCachedSeriesAttrs(String seriesIUID) {
        SeriesAttrsCacheEntry cacheEntry = seriesAttrsCache.get(seriesIUID);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.timestamp + seriesAttrsCacheCurrencyTimeLimit < System.currentTimeMillis()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove stale Series attributes for Series " + seriesIUID + " from cache"));
            }
            seriesAttrsCache.remove(seriesIUID);
            return null;
        }
        return cacheEntry.fileInfo;
    }

    public static void removeCachedSeriesAttrs(String seriesIUID) {
        SeriesAttrsCacheEntry cacheEntry = seriesAttrsCache.get(seriesIUID);
        if (cacheEntry == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remove Series attributes for Series " + seriesIUID + " from cache"));
        }
        seriesAttrsCache.remove(seriesIUID);
    }

    private void addFileInfoWithEagerFetchSeriesAttrs(Map result) throws SQLException {
        FileInfo info = new FileInfo();
        info.instAttrs = this.rs.getBytes(1);
        info.seriesIUID = this.rs.getString(2);
        if (cacheSeriesAttrs) {
            FileInfo seriesFileInfo = RetrieveCmd.getCachedSeriesAttrs(info.seriesIUID);
            if (seriesFileInfo == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cache Series attributes for Series " + info.seriesIUID));
                }
                info.patAttrs = this.rs.getBytes(3);
                info.studyAttrs = this.rs.getBytes(4);
                info.seriesAttrs = this.rs.getBytes(5);
                info.patID = this.rs.getString(6);
                info.patName = this.rs.getString(7);
                info.studyIUID = this.rs.getString(8);
                seriesAttrsCache.put(info.seriesIUID, new SeriesAttrsCacheEntry(info));
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Use cached Series attributes for Series " + info.seriesIUID));
                }
                info.patAttrs = seriesFileInfo.patAttrs;
                info.studyAttrs = seriesFileInfo.studyAttrs;
                info.seriesAttrs = seriesFileInfo.seriesAttrs;
                info.patID = seriesFileInfo.patID;
                info.patName = seriesFileInfo.patName;
                info.studyIUID = seriesFileInfo.studyIUID;
            }
        } else {
            info.patAttrs = this.rs.getBytes(3);
            info.studyAttrs = this.rs.getBytes(4);
            info.seriesAttrs = this.rs.getBytes(5);
            info.patID = this.rs.getString(6);
            info.patName = this.rs.getString(7);
            info.studyIUID = this.rs.getString(8);
        }
        long instPk = this.rs.getLong(9);
        info.sopIUID = this.rs.getString(10);
        info.sopCUID = this.rs.getString(11);
        info.extRetrieveAET = this.rs.getString(12);
        info.pk = this.rs.getLong(13);
        info.fileRetrieveAET = this.rs.getString(14);
        info.availability = this.rs.getInt(15);
        info.basedir = this.rs.getString(16);
        info.fsGroupID = this.rs.getString(17);
        info.fileID = this.rs.getString(18);
        info.tsUID = this.rs.getString(19);
        info.md5 = this.rs.getString(20);
        info.size = this.rs.getInt(21);
        info.status = this.rs.getInt(22);
        this.addFileInfo(result, instPk, info.sopIUID, info);
    }

    private void addFileInfo(Map result, long instPk, String sopIUID, FileInfo info) {
        Object key = this.selectKey(instPk, sopIUID);
        ArrayList<FileInfo> list = (ArrayList<FileInfo>)result.get(key);
        if (list == null) {
            list = new ArrayList<FileInfo>();
            result.put(key, list);
        }
        list.add(info);
    }

    protected Map map() {
        return new TreeMap();
    }

    protected Object selectKey(long instPk, String sopIUID) {
        return new Long(instPk);
    }

    protected FileInfo[][] toArray(Map result) {
        FileInfo[][] array = new FileInfo[result.size()][];
        Iterator it = result.values().iterator();
        for (int i = 0; i < array.length; ++i) {
            ArrayList list = (ArrayList)it.next();
            array[i] = list.toArray(new FileInfo[list.size()]);
            Arrays.sort(array[i]);
        }
        return array;
    }

    private static class RefSOPSql
    extends Sql {
        RefSOPSql(DcmElement refSOPSeq) {
            String[] uid = new String[refSOPSeq.countItems()];
            for (int i = 0; i < uid.length; ++i) {
                uid[i] = refSOPSeq.getItem(i).getString(528725);
            }
            this.addUidMatch("Instance.sopIuid", uid);
        }
    }

    private static class ImageSql
    extends SeriesSql {
        ImageSql(Dataset keys) {
            super(keys, false);
            String[] uid = keys.getStrings(524312);
            if (uid == null || uid.length == 0 || "*".equals(uid[0])) {
                throw new IllegalArgumentException("Missing SOPInstanceUID");
            }
            this.addUidMatch("Instance.sopIuid", uid);
        }
    }

    private static class SeriesSql
    extends StudySql {
        SeriesSql(Dataset keys, boolean seriesRetrieve) {
            super(keys, false);
            String[] uid = keys.getStrings(0x20000E);
            if (uid != null && uid.length != 0 && !"*".equals(uid[0])) {
                this.addUidMatch("Series.seriesIuid", uid);
            } else if (seriesRetrieve) {
                throw new IllegalArgumentException("Missing SeriesInstanceUID");
            }
        }
    }

    private static class StudySql
    extends PatientSql {
        StudySql(Dataset keys, boolean studyRetrieve) {
            super(keys, false);
            String[] uid = keys.getStrings(0x20000D);
            if (uid != null && uid.length != 0 && !"*".equals(uid[0])) {
                this.addUidMatch("Study.studyIuid", uid);
            } else if (studyRetrieve) {
                throw new IllegalArgumentException("Missing StudyInstanceUID");
            }
        }
    }

    private static class PatientSql
    extends Sql {
        PatientSql(Dataset keys, boolean patientRetrieve) {
            String pid = keys.getString(0x100020);
            if (pid != null && !"*".equals(pid)) {
                this.sqlBuilder.addLiteralMatch(null, "Patient.patientId", true, "=?");
                this.fixValues.add(pid);
            } else if (patientRetrieve) {
                throw new IllegalArgumentException("Missing PatientID");
            }
        }
    }

    private static class Sql {
        protected String[] params = null;
        int numberOfParams;
        Match.AppendLiteral uidMatch = null;
        final SqlBuilder sqlBuilder = new SqlBuilder();
        ArrayList fixValues = new ArrayList();

        Sql() {
            this.sqlBuilder.setSelect(this.getSelectAttributes());
            this.sqlBuilder.setFrom(entity);
            this.sqlBuilder.setLeftJoin(leftJoin);
            this.sqlBuilder.setRelations(relations);
        }

        private String[] getSelectAttributes() {
            String[] stringArray;
            if (lazyFetchSeriesAttrs) {
                String[] stringArray2 = new String[16];
                stringArray2[0] = "Instance.encodedAttributes";
                stringArray2[1] = "Series.seriesIuid";
                stringArray2[2] = "Instance.pk";
                stringArray2[3] = "Instance.sopIuid";
                stringArray2[4] = "Instance.sopCuid";
                stringArray2[5] = "Instance.externalRetrieveAET";
                stringArray2[6] = "File.pk";
                stringArray2[7] = "FileSystem.retrieveAET";
                stringArray2[8] = "FileSystem.availability";
                stringArray2[9] = "FileSystem.directoryPath";
                stringArray2[10] = "FileSystem.groupID";
                stringArray2[11] = "File.filePath";
                stringArray2[12] = "File.fileTsuid";
                stringArray2[13] = "File.fileMd5Field";
                stringArray2[14] = "File.fileSize";
                stringArray = stringArray2;
                stringArray2[15] = "File.fileStatus";
            } else {
                String[] stringArray3 = new String[22];
                stringArray3[0] = "Instance.encodedAttributes";
                stringArray3[1] = "Series.seriesIuid";
                stringArray3[2] = "Patient.encodedAttributes";
                stringArray3[3] = "Study.encodedAttributes";
                stringArray3[4] = "Series.encodedAttributes";
                stringArray3[5] = "Patient.patientId";
                stringArray3[6] = "Patient.patientName";
                stringArray3[7] = "Study.studyIuid";
                stringArray3[8] = "Instance.pk";
                stringArray3[9] = "Instance.sopIuid";
                stringArray3[10] = "Instance.sopCuid";
                stringArray3[11] = "Instance.externalRetrieveAET";
                stringArray3[12] = "File.pk";
                stringArray3[13] = "FileSystem.retrieveAET";
                stringArray3[14] = "FileSystem.availability";
                stringArray3[15] = "FileSystem.directoryPath";
                stringArray3[16] = "FileSystem.groupID";
                stringArray3[17] = "File.filePath";
                stringArray3[18] = "File.fileTsuid";
                stringArray3[19] = "File.fileMd5Field";
                stringArray3[20] = "File.fileSize";
                stringArray = stringArray3;
                stringArray3[21] = "File.fileStatus";
            }
            return stringArray;
        }

        public final String getSql() {
            return this.sqlBuilder.getSql();
        }

        public String[] getFixParams() {
            return this.fixValues.toArray(new String[this.fixValues.size()]);
        }

        public String[] getParams() {
            return this.params;
        }

        public int getNumberOfParams() {
            return this.numberOfParams;
        }

        public boolean updateUIDMatch(int len) {
            if (this.uidMatch == null) {
                return false;
            }
            this.uidMatch.setLiteral(this.getUIDMatchLiteral(len));
            return true;
        }

        protected void addUidMatch(String column, String[] uid) {
            if (uid.length <= maxElementsInUIDMatch) {
                this.sqlBuilder.addLiteralMatch(null, column, false, this.getUIDMatchLiteral(uid.length));
                for (int i = 0; i < uid.length; ++i) {
                    this.fixValues.add(uid[i]);
                }
            } else {
                if (this.params != null) {
                    throw new IllegalArgumentException("Only one UID list > maxElementsInUIDMatch (" + maxElementsInUIDMatch + ") is allowed in RetrieveCmd!");
                }
                this.params = uid;
                this.numberOfParams = uid.length < maxElementsInUIDMatch ? uid.length : maxElementsInUIDMatch;
                this.uidMatch = (Match.AppendLiteral)this.sqlBuilder.addLiteralMatch(null, column, false, this.getUIDMatchLiteral(this.numberOfParams));
            }
        }

        private String getUIDMatchLiteral(int len) {
            if (len == 1) {
                return "=?";
            }
            StringBuffer sb = new StringBuffer();
            sb.append(" IN (?");
            for (int i = 1; i < len; ++i) {
                sb.append(", ?");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    static class ImageRetrieveCmd
    extends RetrieveCmd {
        final String[] uids;

        ImageRetrieveCmd(Sql sql, String[] uids) throws SQLException {
            super(sql);
            this.uids = uids;
        }

        protected Map map() {
            return new HashMap();
        }

        protected Object selectKey(long instPk, String sopIUID) {
            return sopIUID;
        }
    }

    static class SeriesAttrsCacheEntry {
        public final long timestamp = System.currentTimeMillis();
        public final FileInfo fileInfo;

        public SeriesAttrsCacheEntry(FileInfo fileInfo) {
            this.fileInfo = fileInfo;
        }
    }
}

