/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.auth.Subject;
import org.dcm4chex.archive.common.SecurityUtils;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

public class QueryStudyPermissionCmd
extends BaseReadCmd {
    private static final String[] SELECT_ATTRIBUTE = null;
    public static int transactionIsolationLevel = 0;
    private final SqlBuilder sqlBuilder = new SqlBuilder();

    public QueryStudyPermissionCmd() throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel);
        this.sqlBuilder.setFrom(new String[]{"StudyPermission"});
        this.sqlBuilder.setSelect(new String[]{"StudyPermission.studyIuid", "StudyPermission.action"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getGrantedActionsForStudies(String[] studyIUIDs, Subject subject) throws SQLException {
        HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
        if (studyIUIDs == null || studyIUIDs.length < 1) {
            return result;
        }
        String[] roles = SecurityUtils.rolesOf((Subject)subject);
        this.sqlBuilder.addListOfStringMatch(null, "StudyPermission.studyIuid", false, studyIUIDs);
        this.sqlBuilder.addListOfStringMatch(null, "StudyPermission.role", false, roles);
        try {
            this.execute(this.sqlBuilder.getSql());
            while (this.next()) {
                String suid = this.rs.getString(1);
                HashSet<String> actions = (HashSet<String>)result.get(suid);
                if (actions == null) {
                    actions = new HashSet<String>();
                    result.put(suid, actions);
                }
                actions.add(this.rs.getString(2));
            }
            HashMap<String, HashSet<String>> hashMap = result;
            return hashMap;
        }
        finally {
            this.close();
        }
    }
}

