/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.Availability;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.SecurityUtils;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.Match;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;
import org.dcm4chex.archive.util.Convert;

public class QueryStudiesCmd
extends BaseReadCmd {
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    private static final DcmObjectFactory dof = DcmObjectFactory.getInstance();
    private static final String[] SELECT_ATTRIBUTE = new String[]{"Patient.encodedAttributes", "Study.encodedAttributes", "Patient.pk", "Study.pk", "Study.modalitiesInStudy", "Study.numberOfStudyRelatedSeries", "Study.numberOfStudyRelatedInstances", "Study.retrieveAETs", "Study.availability", "Study.filesetId", "Study.studyStatusId"};
    private static final String[] LEFT_JOIN = new String[]{"Study", null, "Patient.pk", "Study.patient_fk"};
    private static final String[] LEFT_JOIN_WITH_SERIES = new String[]{"Study", null, "Patient.pk", "Study.patient_fk", "Series", null, "Study.pk", "Series.study_fk"};
    private boolean hideMissingStudies;
    private final SqlBuilder sqlBuilder = new SqlBuilder();
    private boolean checkPermissions = true;

    public QueryStudiesCmd(Dataset keys, boolean hideMissingStudies, boolean noMatchForNoValue, Boolean queryHasIssuerOfPID, Subject subject) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel);
        AttributeFilter patAttrFilter = AttributeFilter.getPatientAttributeFilter();
        AttributeFilter studyAttrFilter = AttributeFilter.getStudyAttributeFilter();
        AttributeFilter seriesAttrFilter = AttributeFilter.getSeriesAttributeFilter();
        this.checkPermissions = subject != null;
        boolean type2 = !noMatchForNoValue;
        this.sqlBuilder.setFrom(this.getTables());
        this.sqlBuilder.setLeftJoin(this.getLeftJoin(keys.containsValue(0x20000E) || keys.containsValue(4194933)));
        this.sqlBuilder.setRelations(this.getRelations());
        this.sqlBuilder.addLiteralMatch(null, "Patient.merge_fk", false, "IS NULL");
        this.sqlBuilder.addWildCardMatch(null, "Patient.patientId", type2, patAttrFilter.getStrings(keys, 0x100020));
        String issuer = patAttrFilter.getString(keys, 0x100021);
        if (issuer != null) {
            this.sqlBuilder.addSingleValueMatch(null, "Patient.issuerOfPatientId", type2, issuer);
        } else if (queryHasIssuerOfPID != null) {
            this.sqlBuilder.addNULLValueMatch(null, "Patient.issuerOfPatientId", queryHasIssuerOfPID);
        }
        this.sqlBuilder.addPNMatch(new String[]{"Patient.patientName", "Patient.patientIdeographicName", "Patient.patientPhoneticName"}, type2, patAttrFilter.isICase(0x100010), keys.getString(0x100010));
        this.sqlBuilder.addRangeMatch(null, "Patient.patientBirthDate", type2, keys.getString(0x100030));
        this.sqlBuilder.addWildCardMatch(null, "Study.studyId", type2, studyAttrFilter.getStrings(keys, 0x200010));
        if (keys.containsValue(4194933) && keys.getItem(4194933).containsValue(0x20000D)) {
            Match.Node node0 = this.sqlBuilder.addNodeMatch("OR", false);
            node0.addMatch(new Match.ListOfString(null, "Study.studyIuid", false, keys.getStrings(0x20000D)));
            Dataset rqAttrs = keys.getItem(4194933);
            SqlBuilder subQuery = new SqlBuilder();
            subQuery.setSelect(new String[]{"SeriesRequest.pk"});
            subQuery.setFrom(new String[]{"SeriesRequest"});
            subQuery.addFieldValueMatch(null, "Series.pk", false, null, "SeriesRequest.series_fk");
            subQuery.addListOfUidMatch(null, "SeriesRequest.studyIuid", type2, rqAttrs.getStrings(0x20000D));
            node0.addMatch(new Match.Subquery(subQuery, null, null));
        } else {
            this.sqlBuilder.addListOfStringMatch(null, "Study.studyIuid", false, keys.getStrings(0x20000D));
        }
        this.sqlBuilder.addListOfStringMatch(null, "Series.seriesIuid", false, keys.getStrings(0x20000E));
        this.sqlBuilder.addRangeMatch(null, "Study.studyDateTime", type2, keys.getDateTimeRange(524320, 524336));
        this.sqlBuilder.addWildCardMatch(null, "Study.accessionNumber", type2, studyAttrFilter.getStrings(keys, 524368));
        this.sqlBuilder.addModalitiesInStudyNestedMatch(null, seriesAttrFilter.getStrings(keys, 524385, 524384));
        keys.setPrivateCreatorID("dcm4che/archive");
        this.sqlBuilder.addCallingAETsNestedMatch(false, keys.getStrings(4390932));
        keys.setPrivateCreatorID(null);
        this.hideMissingStudies = hideMissingStudies;
        if (this.hideMissingStudies) {
            this.sqlBuilder.addNULLValueMatch(null, "Study.pk", true);
        }
        if (this.checkPermissions) {
            String[] roles = SecurityUtils.rolesOf((Subject)subject);
            if (roles.length < 1) {
                throw new IllegalArgumentException("User is not in a StudyPermission relevant role");
            }
            this.addStudyPermissionMatch(subject);
        }
    }

    private void addStudyPermissionMatch(Subject subject) {
        if (subject != null) {
            this.sqlBuilder.addQueryPermissionNestedMatch(false, !this.hideMissingStudies, SecurityUtils.rolesOf((Subject)subject));
        }
    }

    protected String[] getTables() {
        return new String[]{"Patient"};
    }

    protected String[] getLeftJoin(boolean withSeries) {
        return withSeries ? LEFT_JOIN_WITH_SERIES : LEFT_JOIN;
    }

    protected String[] getRelations() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() throws SQLException {
        try {
            this.sqlBuilder.setSelectCount(new String[]{"Study.pk"}, true);
            this.execute(this.sqlBuilder.getSql());
            this.next();
            if (this.hideMissingStudies) {
                int n = this.rs.getInt(1);
                return n;
            }
            int studies = this.rs.getInt(1);
            this.rs.close();
            this.rs = null;
            this.sqlBuilder.setSelectCount(new String[]{"Patient.pk"}, true);
            this.sqlBuilder.addNULLValueMatch(null, "Study.pk", false);
            this.execute(this.sqlBuilder.getSql());
            this.next();
            int emptyPatients = this.rs.getInt(1);
            ArrayList<Match> matches = this.sqlBuilder.getMatches();
            matches.remove(matches.size() - 1);
            int n = studies + emptyPatients;
            return n;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(int offset, int limit, boolean latestStudiesFirst) throws SQLException {
        this.defineColumnTypes(new int[]{blobAccessType, blobAccessType, -5, -5, 12, 4, 4, 12, 4, 12, 12});
        this.sqlBuilder.setSelect(SELECT_ATTRIBUTE);
        this.sqlBuilder.addOrderBy("Patient.patientName", " ASC");
        this.sqlBuilder.addOrderBy("Patient.pk", " ASC");
        this.sqlBuilder.addOrderBy("Study.studyDateTime", latestStudiesFirst ? " DESC" : " ASC");
        this.sqlBuilder.setOffset(offset);
        this.sqlBuilder.setLimit(limit);
        try {
            this.setFetchSize(limit);
            this.execute(this.sqlBuilder.getSql());
            ArrayList<Dataset> result = new ArrayList<Dataset>();
            while (this.next()) {
                byte[] patAttrs = this.rs.getBytes(1);
                byte[] styAttrs = this.rs.getBytes(2);
                Dataset ds = dof.newDataset();
                ds.setPrivateCreatorID("dcm4che/archive");
                ds.putOB(4390928, Convert.toBytes((long)this.rs.getLong(3)));
                ds.setPrivateCreatorID(null);
                long studyPk = this.rs.getLong(4);
                DatasetUtils.fromByteArray((byte[])patAttrs, (Dataset)ds);
                if (styAttrs != null) {
                    ds.setPrivateCreatorID("dcm4che/archive");
                    ds.putOB(4390929, Convert.toBytes((long)studyPk));
                    ds.setPrivateCreatorID(null);
                    DatasetUtils.fromByteArray((byte[])styAttrs, (Dataset)ds);
                    ds.putCS(524385, StringUtils.split((String)this.rs.getString(5), (char)'\\'));
                    ds.putIS(2101766, this.rs.getInt(6));
                    ds.putIS(2101768, this.rs.getInt(7));
                    ds.putAE(524372, StringUtils.split((String)this.rs.getString(8), (char)'\\'));
                    ds.putCS(524374, Availability.toString((int)this.rs.getInt(9)));
                    ds.putSH(8913200, this.rs.getString(10));
                    ds.putCS(3276810, this.rs.getString(11));
                }
                result.add(ds);
            }
            ArrayList<Dataset> arrayList = result;
            return arrayList;
        }
        finally {
            this.close();
        }
    }
}

