/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.Match;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;
import org.dcm4chex.archive.util.Convert;

public class QueryPrivateStudiesCmd
extends BaseReadCmd {
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    private static final DcmObjectFactory dof = DcmObjectFactory.getInstance();
    private static final String[] SELECT_ATTRIBUTE = new String[]{"PrivatePatient.encodedAttributes", "PrivateStudy.encodedAttributes", "PrivatePatient.pk", "PrivateStudy.pk"};
    private static final String[] ENTITY = new String[]{"PrivatePatient"};
    private static final String[] LEFT_JOIN = new String[]{"PrivateStudy", null, "PrivatePatient.pk", "PrivateStudy.patient_fk"};
    private boolean hideMissingStudies = false;
    private final SqlBuilder sqlBuilder = new SqlBuilder();

    public QueryPrivateStudiesCmd(Dataset filter, int privateType, boolean hideMissingStudies) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel);
        this.hideMissingStudies = hideMissingStudies;
        this.sqlBuilder.setFrom(ENTITY);
        this.sqlBuilder.setLeftJoin(LEFT_JOIN);
        this.sqlBuilder.addIntValueMatch(null, "PrivatePatient.privateType", false, privateType);
        if (filter != null) {
            this.sqlBuilder.addWildCardMatch(null, "PrivatePatient.patientId", true, filter.getStrings(0x100020));
            this.sqlBuilder.addWildCardMatch(null, "PrivatePatient.patientName", true, QueryPrivateStudiesCmd.toWildcardMatchString(filter.getString(0x100010)));
            this.sqlBuilder.addWildCardMatch(null, "PrivateStudy.accessionNumber", true, filter.getStrings(524368));
            this.sqlBuilder.addListOfStringMatch(null, "PrivateStudy.studyIuid", false, filter.getStrings(0x20000D));
            filter.setPrivateCreatorID("dcm4che/archive");
            this.sqlBuilder.addCallingAETsNestedMatch(true, filter.getStrings(4390932));
            filter.setPrivateCreatorID(null);
        }
        if (this.hideMissingStudies) {
            this.sqlBuilder.addNULLValueMatch(null, "PrivateStudy.encodedAttributes", true);
        }
    }

    private static String toWildcardMatchString(String patientName) {
        if (patientName != null && (patientName = patientName.toUpperCase()).length() > 0 && patientName.indexOf(42) == -1 && patientName.indexOf(63) == -1) {
            patientName = patientName + "*";
        }
        return patientName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() throws SQLException {
        try {
            this.sqlBuilder.setSelectCount(new String[]{"PrivateStudy.pk"}, true);
            this.execute(this.sqlBuilder.getSql());
            this.next();
            if (this.hideMissingStudies) {
                int n = this.rs.getInt(1);
                return n;
            }
            int studies = this.rs.getInt(1);
            this.rs.close();
            this.rs = null;
            this.sqlBuilder.setSelectCount(new String[]{"PrivatePatient.pk"}, true);
            this.sqlBuilder.addNULLValueMatch(null, "PrivateStudy.pk", false);
            this.execute(this.sqlBuilder.getSql());
            this.next();
            int emptyPatients = this.rs.getInt(1);
            ArrayList<Match> matches = this.sqlBuilder.getMatches();
            matches.remove(matches.size() - 1);
            int n = studies + emptyPatients;
            return n;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(int offset, int limit) throws SQLException {
        this.defineColumnTypes(new int[]{blobAccessType, blobAccessType, -5, -5});
        this.sqlBuilder.setSelect(SELECT_ATTRIBUTE);
        this.sqlBuilder.addOrderBy("PrivatePatient.pk", " ASC");
        this.sqlBuilder.setOffset(offset);
        this.sqlBuilder.setLimit(limit);
        try {
            this.setFetchSize(limit);
            this.execute(this.sqlBuilder.getSql());
            ArrayList<Dataset> result = new ArrayList<Dataset>();
            while (this.next()) {
                byte[] patAttrs = this.rs.getBytes(1);
                byte[] styAttrs = this.rs.getBytes(2);
                Dataset ds = dof.newDataset();
                ds.setPrivateCreatorID("dcm4che/archive");
                ds.putOB(4390928, Convert.toBytes((long)this.rs.getLong(3)));
                ds.setPrivateCreatorID(null);
                long studyPk = this.rs.getLong(4);
                DatasetUtils.fromByteArray((byte[])patAttrs, (Dataset)ds);
                if (styAttrs != null) {
                    ds.setPrivateCreatorID("dcm4che/archive");
                    ds.putOB(4390929, Convert.toBytes((long)studyPk));
                    ds.setPrivateCreatorID(null);
                    DatasetUtils.fromByteArray((byte[])styAttrs, (Dataset)ds);
                }
                ds.setPrivateCreatorID(null);
                result.add(ds);
            }
            ArrayList<Dataset> arrayList = result;
            return arrayList;
        }
        finally {
            this.close();
        }
    }
}

