/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4chex.archive.ejb.jdbc.BaseSQLCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryForwardCmd
extends BaseSQLCmd {
    public static int transactionIsolationLevel = 0;
    private long lastSeriesPk = 0L;

    private QueryForwardCmd(String sql, int fetchSize, int limit) throws SQLException {
        super(sql, fetchSize, limit, "SERIES");
    }

    public static QueryForwardCmd getInstance(String sql, int limit, int fetchSize) throws SQLException {
        return new QueryForwardCmd(sql, fetchSize, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getSeriesIUIDs(Long updatedBefore, long lastSeriesPk) throws SQLException {
        if (this.stmt == null) {
            this.open();
        }
        this.setParams(updatedBefore, lastSeriesPk);
        this.execute();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try {
            String lastAet = null;
            ArrayList<String> l = null;
            while (this.next()) {
                String uid = this.rs.getString(1);
                String retrAet = this.rs.getString(2);
                if (retrAet == null) {
                    log.warn((Object)("Series " + uid + " has no RetrieveAET! can't be forwarded!"));
                    continue;
                }
                int pos = retrAet.indexOf(92);
                if (pos != -1) {
                    retrAet = retrAet.substring(0, pos);
                }
                if (!retrAet.equals(lastAet)) {
                    log.debug((Object)"retrAet changed!");
                    l = (List)map.get(retrAet);
                    if (l == null) {
                        log.debug((Object)"create new list for new retrAet!");
                        l = new ArrayList<String>();
                        map.put(retrAet, l);
                        lastAet = retrAet;
                    }
                }
                l.add(uid);
                this.lastSeriesPk = this.rs.getLong(3);
            }
        }
        catch (Exception x) {
            log.error((Object)"QueryForwardCmd failed!", (Throwable)x);
        }
        finally {
            try {
                this.close();
            }
            catch (Exception ignore) {
                log.warn((Object)"Error closing connection!");
            }
        }
        return map;
    }

    public long getLastSeriesPk() {
        return this.lastSeriesPk;
    }
}

