/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.MD5;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryFilesOfSeriesCmd2
extends BaseReadCmd {
    private static final String SQL = "SELECT f.pk, f.filepath, f.file_md5, f.file_status, fs.fs_group_id, fs.dirpath, fs.retrieve_aet, fs.availability, fs.user_info, i.sop_cuid, i.sop_iuid, s.num_instances FROM files f, filesystem fs, instance i, series s WHERE f.filesystem_fk = fs.pk AND f.instance_fk = i.pk AND i.series_fk = s.pk AND s.series_iuid=?";
    public static int transactionIsolationLevel = 0;
    private int numberOfSeriesRelatedInstances = 0;

    public QueryFilesOfSeriesCmd2(String seriuid, int fetchSize) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel, SQL);
        ((PreparedStatement)this.stmt).setString(1, seriuid);
        this.setFetchSize(fetchSize);
        this.execute();
    }

    public int getNumberOfSeriesRelatedInstances() {
        return this.numberOfSeriesRelatedInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<FileDTO>> getFileDTOsByIUID() throws SQLException {
        HashMap<String, List<FileDTO>> map = new HashMap<String, List<FileDTO>>();
        try {
            while (this.next()) {
                FileDTO fileDTO = this.getFileDTO();
                if (fileDTO.getFileStatus() < 0) continue;
                String iuid = fileDTO.getSopInstanceUID();
                ArrayList<FileDTO> list = (ArrayList<FileDTO>)map.get(iuid);
                if (list == null) {
                    list = new ArrayList<FileDTO>();
                    map.put(iuid, list);
                }
                list.add(fileDTO);
            }
        }
        finally {
            this.close();
        }
        return map;
    }

    private FileDTO getFileDTO() throws SQLException {
        FileDTO dto = new FileDTO();
        dto.setPk(this.rs.getLong(1));
        dto.setFilePath(this.rs.getString(2));
        dto.setFileMd5(MD5.toBytes((String)this.rs.getString(3)));
        dto.setFileStatus(this.rs.getInt(4));
        dto.setFileSystemGroupID(this.rs.getString(5));
        dto.setDirectoryPath(this.rs.getString(6));
        dto.setRetrieveAET(this.rs.getString(7));
        dto.setAvailability(this.rs.getInt(8));
        dto.setUserInfo(this.rs.getString(9));
        dto.setSopClassUID(this.rs.getString(10));
        dto.setSopInstanceUID(this.rs.getString(11));
        this.numberOfSeriesRelatedInstances = this.rs.getInt(12);
        return dto;
    }
}

