/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4chex.archive.ejb.interfaces.FileDTO;
import org.dcm4chex.archive.ejb.interfaces.MD5;
import org.dcm4chex.archive.ejb.jdbc.BaseReadCmd;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;

public final class QueryFilesCmd
extends BaseReadCmd {
    private static final String QueryFilesByUIDCmd = "SELECT f.pk, f.filepath, f.file_md5, f.file_status, fs.fs_group_id, fs.dirpath, fs.retrieve_aet, fs.availability, fs.user_info, i.sop_cuid, i.sop_iuid FROM files f, filesystem fs, instance i WHERE f.filesystem_fk = fs.pk AND f.instance_fk = i.pk AND i.sop_iuid=?";
    private static final String QueryLinkedFilesCmd = "SELECT f.pk, f.filepath, f.file_md5, f.file_status, fs.fs_group_id, fs.dirpath, fs.retrieve_aet, fs.availability, fs.user_info, i.sop_cuid, i.sop_iuid FROM files f, filesystem fs, instance i, files f2 WHERE f.filesystem_fk = fs.pk AND f.instance_fk = i.pk AND f.instance_fk = f2.instance_fk and f2.pk=?";
    public static int transactionIsolationLevel = 0;

    public QueryFilesCmd(String iuid) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel, QueryFilesByUIDCmd);
        ((PreparedStatement)this.stmt).setString(1, iuid);
        this.execute();
    }

    public QueryFilesCmd(long filePk) throws SQLException {
        super(JdbcProperties.getInstance().getDataSource(), transactionIsolationLevel, QueryLinkedFilesCmd);
        ((PreparedStatement)this.stmt).setLong(1, filePk);
        this.execute();
    }

    private FileDTO getFileDTO() throws SQLException {
        FileDTO dto = new FileDTO();
        dto.setPk(this.rs.getLong(1));
        dto.setFilePath(this.rs.getString(2));
        dto.setFileMd5(MD5.toBytes((String)this.rs.getString(3)));
        dto.setFileStatus(this.rs.getInt(4));
        dto.setFileSystemGroupID(this.rs.getString(5));
        dto.setDirectoryPath(this.rs.getString(6));
        dto.setRetrieveAET(this.rs.getString(7));
        dto.setAvailability(this.rs.getInt(8));
        dto.setUserInfo(this.rs.getString(9));
        dto.setSopClassUID(this.rs.getString(10));
        dto.setSopInstanceUID(this.rs.getString(11));
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFileDTOs() throws SQLException {
        ArrayList<FileDTO> list = new ArrayList<FileDTO>();
        try {
            while (this.next()) {
                list.add(this.getFileDTO());
            }
        }
        finally {
            this.close();
        }
        Collections.sort(list);
        return list;
    }
}

