/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmElement;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmValueException;
import org.dcm4che.dict.Tags;
import org.dcm4che.net.DcmServiceException;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.common.DatasetUtils;
import org.dcm4chex.archive.common.PIDWithIssuer;
import org.dcm4chex.archive.common.SecurityUtils;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.AdjustPatientID;
import org.dcm4chex.archive.ejb.jdbc.BaseDSQueryCmd;
import org.dcm4chex.archive.ejb.jdbc.Match;
import org.dcm4chex.archive.ejb.jdbc.QuerySeriesAttrsForQueryCmd;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryCmd
extends BaseDSQueryCmd {
    private static final int[] PAT_DEMOGRAPHICS_ATTRS = new int[]{0x100010, 0x100030, 0x100040};
    private static final String[] AVAILABILITY = new String[]{"ONLINE", "NEARLINE", "OFFLINE", "UNAVAILABLE"};
    private static final String SR_CODE = "sr_code";
    private static final String NAME_CODE = "name_code";
    private static final String CONCEPT_CODE = "concept_code";
    public static int transactionIsolationLevel = 0;
    public static int blobAccessType = -4;
    public static int seriesBlobAccessType = 2004;
    public static boolean lazyFetchSeriesAttrsOnImageLevelQuery = false;
    public static boolean cacheSeriesAttrsOnImageLevelQuery = true;
    private final HashMap<String, Dataset> chkPatAttrs = new HashMap();
    protected final Set<PIDWithIssuer> pidWithIssuers;
    protected final Dataset requestedIssuerOfAccessionNumber;
    protected final AdjustPatientID adjustPatientID;
    protected final boolean noMatchWithoutIssuerOfPID;
    protected final boolean fuzzyMatchingOfPN;
    protected final Subject subject;
    protected boolean keyNotSupported;

    public static QueryCmd create(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException, DcmServiceException {
        String qrLevel = keys.getString(524370);
        if ("IMAGE".equals(qrLevel)) {
            return QueryCmd.createInstanceQuery(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
        }
        if ("SERIES".equals(qrLevel)) {
            return QueryCmd.createSeriesQuery(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
        }
        if ("STUDY".equals(qrLevel)) {
            return QueryCmd.createStudyQuery(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
        }
        if ("PATIENT".equals(qrLevel)) {
            return QueryCmd.createPatientQuery(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
        }
        throw new IllegalArgumentException("QueryRetrieveLevel=" + qrLevel);
    }

    public static PatientQueryCmd createPatientQuery(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException, DcmServiceException {
        PatientQueryCmd cmd = new PatientQueryCmd(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
        cmd.init();
        return cmd;
    }

    public static StudyQueryCmd createStudyQuery(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException, DcmServiceException {
        StudyQueryCmd cmd = new StudyQueryCmd(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
        cmd.init();
        return cmd;
    }

    public static SeriesQueryCmd createSeriesQuery(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException, DcmServiceException {
        SeriesQueryCmd cmd = new SeriesQueryCmd(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
        cmd.init();
        return cmd;
    }

    public static ImageQueryCmd createInstanceQuery(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException, DcmServiceException {
        ImageQueryCmd cmd = new ImageQueryCmd(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
        cmd.init();
        return cmd;
    }

    protected QueryCmd(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException {
        super(keys, filterResult, noMatchForNoValue, transactionIsolationLevel);
        this.pidWithIssuers = pidWithIssuers;
        this.fuzzyMatchingOfPN = fuzzyMatchingOfPN;
        this.noMatchWithoutIssuerOfPID = noMatchWithoutIssuerOfPID;
        this.subject = subject;
        if (!keys.contains(524293)) {
            keys.putCS(524293);
        }
        this.adjustPatientID = pidWithIssuers != null ? new AdjustPatientID(keys, pidWithIssuers) : null;
        this.requestedIssuerOfAccessionNumber = keys.getItem(524369);
    }

    protected void addAdditionalReturnKeys() {
        this.keys.putAE(524372);
        this.keys.putSH(8913200);
        this.keys.putUI(8913216);
        this.keys.putCS(524374);
    }

    protected void init() throws DcmServiceException {
        this.sqlBuilder.setSelect(this.getSelectAttributes());
        this.sqlBuilder.setFrom(this.getTables());
        this.sqlBuilder.setLeftJoin(this.getLeftJoin());
        this.sqlBuilder.setRelations(this.getRelations());
        for (DcmElement key : this.keys) {
            if (this.isAdditionalKey(key) || this.isKeySupported(key)) continue;
            this.setKeyNotSupported(key);
        }
    }

    private void setKeyNotSupported(DcmElement key) {
        log.warn((Object)(key + " not supported for existence and/or matching"));
        this.keyNotSupported = true;
    }

    private void setKeyNotSupported(DcmElement key, DcmElement seq) {
        log.warn((Object)(key + " in item of " + seq + " not supported for  matching"));
        this.keyNotSupported = true;
    }

    private boolean isAdditionalKey(DcmElement key) {
        switch (key.tag()) {
            case 524293: 
            case 524370: 
            case 524372: 
            case 524374: 
            case 8913200: 
            case 8913216: {
                return true;
            }
        }
        return false;
    }

    protected abstract boolean isKeySupported(DcmElement var1) throws DcmServiceException;

    protected abstract String[] getSelectAttributes();

    protected abstract String[] getTables();

    protected String[] getLeftJoin() {
        return null;
    }

    protected String[] getRelations() {
        return null;
    }

    public boolean isKeyNotSupported() {
        return this.keyNotSupported || this.sqlBuilder.isMatchNotSupported();
    }

    protected boolean isSupportedKey(DcmElement key, AttributeFilter filter) {
        int tag = key.tag();
        for (int fieldTag : filter.getFieldTags()) {
            if (tag != fieldTag) continue;
            return true;
        }
        return key.isEmpty() && filter.hasTag(tag);
    }

    protected boolean isSupportedPatientKey(DcmElement key) throws DcmServiceException {
        switch (key.tag()) {
            case 0x100010: 
            case 0x100020: 
            case 0x100021: 
            case 0x100040: {
                return true;
            }
            case 0x100030: {
                this.checkDateRange(key);
                return true;
            }
        }
        return this.isSupportedKey(key, AttributeFilter.getPatientAttributeFilter());
    }

    private void checkDateRange(DcmElement key) throws DcmServiceException {
        try {
            key.getDateRange();
        }
        catch (DcmValueException e) {
            throw new DcmServiceException(43264, Tags.toString((int)key.tag()) + " contains invalid date range");
        }
    }

    protected void addPatientMatch() throws DcmServiceException {
        AttributeFilter filter = AttributeFilter.getPatientAttributeFilter();
        this.sqlBuilder.addLiteralMatch(null, "Patient.merge_fk", false, "IS NULL");
        if (this.pidWithIssuers != null) {
            Match.Node n = this.sqlBuilder.addNodeMatch("OR", false);
            for (PIDWithIssuer pwi : this.pidWithIssuers) {
                Match.Node n1 = new Match.Node("AND", false);
                n1.addMatch(new Match.SingleValue(null, "Patient.patientId", this.type2, pwi.pid));
                n1.addMatch(new Match.SingleValue(null, "Patient.issuerOfPatientId", this.type2, pwi.issuer));
                n.addMatch(n1);
            }
        } else {
            String[] pid = filter.getStrings(this.keys, 0x100020);
            String issuer = filter.getString(this.keys, 0x100021);
            Match matchPID = this.sqlBuilder.addWildCardMatch(null, "Patient.patientId", this.type2, pid);
            if (matchPID != null && issuer != null) {
                this.sqlBuilder.addSingleValueMatch(null, "Patient.issuerOfPatientId", this.type2, issuer);
            } else if (this.noMatchWithoutIssuerOfPID) {
                this.sqlBuilder.addNULLValueMatch(null, "Patient.issuerOfPatientId", true);
            }
        }
        if (this.fuzzyMatchingOfPN) {
            try {
                this.sqlBuilder.addPNFuzzyMatch(new String[]{"Patient.patientFamilyNameSoundex", "Patient.patientGivenNameSoundex"}, this.type2, this.keys.getString(0x100010));
            }
            catch (IllegalArgumentException ex) {
                throw new DcmServiceException(43264, ex.getMessage() + ": " + this.keys.get(0x100010));
            }
        } else {
            this.sqlBuilder.addPNMatch(new String[]{"Patient.patientName", "Patient.patientIdeographicName", "Patient.patientPhoneticName"}, this.type2, filter.isICase(0x100010), this.keys.getString(0x100010));
        }
        this.sqlBuilder.addRangeMatch(null, "Patient.patientBirthDate", this.type2, this.keys.getString(0x100030));
        this.sqlBuilder.addWildCardMatch(null, "Patient.patientSex", this.type2, filter.getStrings(this.keys, 0x100040));
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            this.sqlBuilder.addWildCardMatch(null, "Patient." + filter.getField(fieldTags[i]), this.type2, filter.getStrings(this.keys, fieldTags[i]));
        }
    }

    protected boolean isSupportedStudyKey(DcmElement key) throws DcmServiceException {
        switch (key.tag()) {
            case 524368: 
            case 524385: 
            case 524432: 
            case 528432: 
            case 0x20000D: 
            case 0x200010: 
            case 3276810: 
            case 4390928: 
            case 4395028: {
                return true;
            }
            case 524320: 
            case 524336: {
                this.checkDateRange(key);
                return true;
            }
            case 524369: {
                this.checkIssuerOfAccessionNumberSeq(key);
                return true;
            }
            case 524386: 
            case 2101766: 
            case 2101768: {
                return key.isEmpty();
            }
        }
        return this.isSupportedKey(key, AttributeFilter.getStudyAttributeFilter());
    }

    private void checkOnlyOneItem(DcmElement seq) throws DcmServiceException {
        int n = seq.countItems();
        if (n > 1) {
            throw new DcmServiceException(43264, Tags.toString((int)seq.tag()) + " contains " + n + " items");
        }
    }

    private void checkIssuerOfAccessionNumberSeq(DcmElement seq) throws DcmServiceException {
        this.checkOnlyOneItem(seq);
        Dataset item = seq.getItem();
        if (item != null) {
            for (DcmElement key : item) {
                if (this.isIssuerOfAccessionNumberKeySupported(key)) continue;
                this.setKeyNotSupported(key, seq);
            }
        }
    }

    private boolean isIssuerOfAccessionNumberKeySupported(DcmElement key) {
        switch (key.tag()) {
            case 4194353: 
            case 4194354: 
            case 0x400033: {
                return true;
            }
        }
        return key.isEmpty();
    }

    protected void addStudyMatch() throws DcmServiceException {
        Dataset issuer;
        AttributeFilter filter = AttributeFilter.getStudyAttributeFilter();
        this.sqlBuilder.addListOfUidMatch(null, "Study.studyIuid", false, this.keys.getStrings(0x20000D));
        this.sqlBuilder.addWildCardMatch(null, "Study.studyId", this.type2, filter.getStrings(this.keys, 0x200010));
        this.sqlBuilder.addRangeMatch(null, "Study.studyDateTime", this.type2, this.keys.getDateTimeRange(524320, 524336));
        if (this.sqlBuilder.addWildCardMatch(null, "Study.accessionNumber", this.type2, filter.getStrings(this.keys, 524368)) != null && QueryCmd.isMatchIssuer(issuer = this.keys.getItem(524369))) {
            SqlBuilder subQuery = new SqlBuilder();
            subQuery.setSelect(new String[]{"Issuer.pk"});
            subQuery.setFrom(new String[]{"Issuer"});
            subQuery.addFieldValueMatch(null, "Issuer.pk", false, null, "Study.accno_issuer_fk");
            subQuery.addSingleValueMatch(null, "Issuer.localNamespaceEntityID", this.type2, issuer.getString(4194353));
            subQuery.addSingleValueMatch(null, "Issuer.universalEntityID", this.type2, issuer.getString(4194354));
            subQuery.addSingleValueMatch(null, "Issuer.universalEntityIDType", this.type2, issuer.getString(0x400033));
            Match.Node node0 = this.sqlBuilder.addNodeMatch("OR", false);
            node0.addMatch(new Match.Subquery(subQuery, null, null));
        }
        if (this.fuzzyMatchingOfPN) {
            try {
                this.sqlBuilder.addPNFuzzyMatch(new String[]{"Study.referringPhysicianFamilyNameSoundex", "Study.referringPhysicianGivenNameSoundex"}, this.type2, this.keys.getString(524432));
            }
            catch (IllegalArgumentException ex) {
                throw new DcmServiceException(43264, ex.getMessage() + ": " + this.keys.get(524432));
            }
        } else {
            this.sqlBuilder.addPNMatch(new String[]{"Study.referringPhysicianName", "Study.referringPhysicianIdeographicName", "Study.referringPhysicianPhoneticName"}, this.type2, filter.isICase(524432), this.keys.getString(524432));
        }
        this.sqlBuilder.addWildCardMatch(null, "Study.studyDescription", this.type2, filter.getStrings(this.keys, 528432));
        this.sqlBuilder.addListOfStringMatch(null, "Study.studyStatusId", this.type2, filter.getStrings(this.keys, 3276810));
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            this.sqlBuilder.addWildCardMatch(null, "Study." + filter.getField(fieldTags[i]), this.type2, filter.getStrings(this.keys, fieldTags[i]));
        }
    }

    protected void addStudyPermissionMatch(boolean patientLevel) {
        if (this.subject != null) {
            this.sqlBuilder.addQueryPermissionNestedMatch(patientLevel, false, SecurityUtils.rolesOf((Subject)this.subject));
        }
    }

    protected void addNestedSeriesMatch() {
        this.sqlBuilder.addModalitiesInStudyNestedMatch(null, this.keys.getStrings(524385));
        this.sqlBuilder.addCallingAETsNestedMatch(false, this.getCallingAETs(this.keys));
    }

    private String[] getCallingAETs(Dataset ds) {
        ds.setPrivateCreatorID("dcm4che/archive");
        ByteBuffer bb = ds.getByteBuffer(4390932);
        ds.setPrivateCreatorID(null);
        try {
            if (bb != null) {
                return StringUtils.split((String)new String(bb.array(), "UTF-8").trim(), (char)'\\');
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new String[0];
    }

    protected boolean isSupportedSeriesKey(DcmElement key) throws DcmServiceException {
        switch (key.tag()) {
            case 524384: 
            case 524416: 
            case 528400: 
            case 528446: 
            case 528448: 
            case 528464: 
            case 1572885: 
            case 0x20000E: 
            case 0x200011: 
            case 0x200060: {
                return true;
            }
            case 0x400244: 
            case 4194885: {
                this.checkDateRange(key);
                return true;
            }
            case 4194933: {
                this.checkRequestAttributesSeq(key);
                return true;
            }
            case 524418: {
                this.checkCodeSeq(key);
                return true;
            }
            case 2101769: {
                return key.isEmpty();
            }
        }
        return this.isSupportedKey(key, AttributeFilter.getSeriesAttributeFilter());
    }

    private void checkRequestAttributesSeq(DcmElement seq) throws DcmServiceException {
        this.checkOnlyOneItem(seq);
        Dataset item = seq.getItem();
        if (item != null) {
            for (DcmElement key : item) {
                if (this.isRequestAttributesKeySupported(key)) continue;
                this.setKeyNotSupported(key, seq);
            }
        }
    }

    private boolean isRequestAttributesKeySupported(DcmElement key) throws DcmServiceException {
        switch (key.tag()) {
            case 524368: 
            case 0x20000D: 
            case 3280946: 
            case 3280947: 
            case 0x400009: 
            case 0x401001: {
                return true;
            }
            case 524369: {
                this.checkIssuerOfAccessionNumberSeq(key);
                return true;
            }
        }
        return key.isEmpty();
    }

    private void checkCodeSeq(DcmElement seq) throws DcmServiceException {
        this.checkOnlyOneItem(seq);
        Dataset item = seq.getItem();
        if (item != null) {
            for (DcmElement key : item) {
                if (this.isCodeKeySupported(key)) continue;
                this.setKeyNotSupported(key, seq);
            }
        }
    }

    private boolean isCodeKeySupported(DcmElement key) {
        switch (key.tag()) {
            case 524544: 
            case 524546: 
            case 524547: {
                return true;
            }
        }
        return key.isEmpty();
    }

    protected void addSeriesMatch() throws DcmServiceException {
        Dataset code;
        Match.Node node0;
        AttributeFilter filter = AttributeFilter.getSeriesAttributeFilter();
        this.sqlBuilder.addListOfUidMatch(null, "Series.seriesIuid", false, this.keys.getStrings(0x20000E));
        this.sqlBuilder.addWildCardMatch(null, "Series.seriesNumber", this.type2, filter.getStrings(this.keys, 0x200011));
        this.sqlBuilder.addWildCardMatch(null, "Series.modality", this.type2, filter.getStrings(this.keys, 524384));
        this.sqlBuilder.addWildCardMatch(null, "Series.bodyPartExamined", this.type2, filter.getStrings(this.keys, 1572885));
        this.sqlBuilder.addWildCardMatch(null, "Series.laterality", this.type2, filter.getStrings(this.keys, 0x200060));
        this.sqlBuilder.addWildCardMatch(null, "Series.institutionName", this.type2, filter.getStrings(this.keys, 524416));
        this.sqlBuilder.addWildCardMatch(null, "Series.stationName", this.type2, filter.getStrings(this.keys, 528400));
        this.sqlBuilder.addWildCardMatch(null, "Series.seriesDescription", this.type2, filter.getStrings(this.keys, 528446));
        this.sqlBuilder.addWildCardMatch(null, "Series.institutionalDepartmentName", this.type2, filter.getStrings(this.keys, 528448));
        if (this.fuzzyMatchingOfPN) {
            try {
                this.sqlBuilder.addPNFuzzyMatch(new String[]{"Series.performingPhysicianFamilyNameSoundex", "Series.performingPhysicianGivenNameSoundex"}, this.type2, this.keys.getString(528464));
            }
            catch (IllegalArgumentException ex) {
                throw new DcmServiceException(43264, ex.getMessage() + ": " + this.keys.get(528464));
            }
        } else {
            this.sqlBuilder.addPNMatch(new String[]{"Series.performingPhysicianName", "Series.performingPhysicianIdeographicName", "Series.performingPhysicianPhoneticName"}, this.type2, filter.isICase(528464), this.keys.getString(528464));
        }
        this.sqlBuilder.addRangeMatch(null, "Series.ppsStartDateTime", this.type2, this.keys.getDateTimeRange(0x400244, 4194885));
        this.sqlBuilder.addListOfStringMatch(null, "Series.sourceAET", this.type2, this.getCallingAETs(this.keys));
        if (this.isMatchRequestAttributes()) {
            Dataset issuer;
            SqlBuilder subQuery = new SqlBuilder();
            subQuery.setSelect(new String[]{"SeriesRequest.pk"});
            subQuery.setFrom(new String[]{"SeriesRequest"});
            subQuery.addFieldValueMatch(null, "Series.pk", false, null, "SeriesRequest.series_fk");
            Dataset rqAttrs = this.keys.getItem(4194933);
            subQuery.addListOfUidMatch(null, "SeriesRequest.studyIuid", this.type2, rqAttrs.getStrings(0x20000D));
            subQuery.addWildCardMatch(null, "SeriesRequest.requestedProcedureId", false, filter.getStrings(rqAttrs, 0x401001));
            subQuery.addWildCardMatch(null, "SeriesRequest.spsId", false, filter.getStrings(rqAttrs, 0x400009));
            subQuery.addWildCardMatch(null, "SeriesRequest.requestingService", this.type2, filter.getStrings(rqAttrs, 3280947));
            if (this.fuzzyMatchingOfPN) {
                try {
                    subQuery.addPNFuzzyMatch(new String[]{"SeriesRequest.requestingPhysicianFamilyNameSoundex", "SeriesRequest.requestingPhysicianGivenNameSoundex"}, this.type2, rqAttrs.getString(3280946));
                }
                catch (IllegalArgumentException ex) {
                    throw new DcmServiceException(43264, ex.getMessage() + ": " + rqAttrs.get(3280946));
                }
            } else {
                subQuery.addPNMatch(new String[]{"SeriesRequest.requestingPhysician", "SeriesRequest.requestingPhysicianIdeographicName", "SeriesRequest.requestingPhysicianPhoneticName"}, this.type2, filter.isICase(3280946), rqAttrs.getString(3280946));
            }
            if (subQuery.addWildCardMatch(null, "SeriesRequest.accessionNumber", this.type2, filter.getStrings(rqAttrs, 524368)) != null && QueryCmd.isMatchIssuer(issuer = rqAttrs.getItem(524369))) {
                SqlBuilder subQuery2 = new SqlBuilder();
                subQuery2.setSelect(new String[]{"Issuer.pk"});
                subQuery2.setFrom(new String[]{"Issuer"});
                subQuery2.addFieldValueMatch(null, "Issuer.pk", false, null, "SeriesRequest.accno_issuer_fk");
                subQuery2.addSingleValueMatch(null, "Issuer.localNamespaceEntityID", this.type2, issuer.getString(4194353));
                subQuery2.addSingleValueMatch(null, "Issuer.universalEntityID", this.type2, issuer.getString(4194354));
                subQuery2.addSingleValueMatch(null, "Issuer.universalEntityIDType", this.type2, issuer.getString(0x400033));
                subQuery.addNodeMatch("OR", false).addMatch(new Match.Subquery(subQuery2, null, null));
            }
            node0 = this.sqlBuilder.addNodeMatch("OR", false);
            node0.addMatch(new Match.Subquery(subQuery, null, null));
        }
        if (QueryCmd.isMatchCode(code = this.keys.getItem(524418))) {
            SqlBuilder subQuery = new SqlBuilder();
            subQuery.setSelect(new String[]{"Code.pk"});
            subQuery.setFrom(new String[]{"Code"});
            subQuery.addFieldValueMatch(null, "Code.pk", false, null, "Series.inst_code_fk");
            subQuery.addSingleValueMatch(null, "Code.codeValue", this.type2, code.getString(524544));
            subQuery.addSingleValueMatch(null, "Code.codingSchemeDesignator", this.type2, code.getString(524546));
            subQuery.addSingleValueMatch(null, "Code.codingSchemeVersion", this.type2, code.getString(524547));
            node0 = this.sqlBuilder.addNodeMatch("OR", false);
            node0.addMatch(new Match.Subquery(subQuery, null, null));
        }
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            this.sqlBuilder.addWildCardMatch(null, "Series." + filter.getField(fieldTags[i]), this.type2, filter.getStrings(this.keys, fieldTags[i]));
        }
    }

    protected boolean isSupportedInstanceKey(DcmElement key) throws DcmServiceException {
        switch (key.tag()) {
            case 524310: 
            case 524312: 
            case 2097171: 
            case 4236433: 
            case 4236435: {
                return true;
            }
            case 524323: 
            case 524339: {
                this.checkDateRange(key);
                return true;
            }
            case 4235331: {
                this.checkCodeSeq(key);
                return true;
            }
            case 4235379: {
                this.checkVerifyingObserverSeq(key);
                return true;
            }
            case 4237104: {
                this.checkContentSeq(key);
                return true;
            }
        }
        return this.isSupportedKey(key, AttributeFilter.getInstanceAttributeFilter(null));
    }

    private void checkVerifyingObserverSeq(DcmElement seq) throws DcmServiceException {
        this.checkOnlyOneItem(seq);
        Dataset item = seq.getItem();
        if (item != null) {
            for (DcmElement key : item) {
                if (this.isVerifyingObserverKeySupported(key)) continue;
                this.setKeyNotSupported(key, seq);
            }
        }
    }

    private boolean isVerifyingObserverKeySupported(DcmElement key) throws DcmServiceException {
        switch (key.tag()) {
            case 4235312: {
                this.checkDateRange(key);
            }
            case 4235381: {
                return true;
            }
        }
        return key.isEmpty();
    }

    private void checkContentSeq(DcmElement seq) throws DcmServiceException {
        int n = seq.countItems();
        for (int i = 0; i < n; ++i) {
            Dataset item = seq.getItem(i);
            for (DcmElement key : item) {
                if (this.isContentKeySupported(key)) continue;
                this.setKeyNotSupported(key, seq);
            }
        }
    }

    private boolean isContentKeySupported(DcmElement key) throws DcmServiceException {
        switch (key.tag()) {
            case 4235280: 
            case 4235616: {
                return true;
            }
            case 4235331: 
            case 4235624: {
                this.checkCodeSeq(key);
                return true;
            }
        }
        return false;
    }

    protected void addInstanceMatch() throws DcmServiceException {
        DcmElement contentSeq;
        AttributeFilter filter = AttributeFilter.getInstanceAttributeFilter(null);
        this.sqlBuilder.addListOfUidMatch(null, "Instance.sopIuid", false, this.keys.getStrings(524312));
        this.sqlBuilder.addListOfUidMatch(null, "Instance.sopCuid", false, this.keys.getStrings(524310));
        this.sqlBuilder.addWildCardMatch(null, "Instance.instanceNumber", this.type2, filter.getStrings(this.keys, 2097171));
        this.sqlBuilder.addRangeMatch(null, "Instance.contentDateTime", this.type2, this.keys.getDateTimeRange(524323, 524339));
        this.sqlBuilder.addSingleValueMatch(null, "Instance.srCompletionFlag", this.type2, filter.getString(this.keys, 4236433));
        this.sqlBuilder.addSingleValueMatch(null, "Instance.srVerificationFlag", this.type2, filter.getString(this.keys, 4236435));
        Dataset code = this.keys.getItem(4235331);
        if (code != null) {
            this.sqlBuilder.addSingleValueMatch(SR_CODE, "Code.codeValue", this.type2, code.getString(524544));
            this.sqlBuilder.addSingleValueMatch(SR_CODE, "Code.codingSchemeDesignator", this.type2, code.getString(524546));
            this.sqlBuilder.addSingleValueMatch(SR_CODE, "Code.codingSchemeVersion", this.type2, code.getString(524547));
        }
        if (this.isMatchVerifyingObserver()) {
            Dataset voAttrs = this.keys.getItem(4235379);
            SqlBuilder subQuery = new SqlBuilder();
            subQuery.setSelect(new String[]{"VerifyingObserver.pk"});
            subQuery.setFrom(new String[]{"VerifyingObserver"});
            subQuery.addFieldValueMatch(null, "Instance.pk", false, null, "VerifyingObserver.instance_fk");
            subQuery.addRangeMatch(null, "VerifyingObserver.verificationDateTime", false, voAttrs.getDateRange(4235312));
            if (this.fuzzyMatchingOfPN) {
                try {
                    subQuery.addPNFuzzyMatch(new String[]{"VerifyingObserver.verifyingObserverFamilyNameSoundex", "VerifyingObserver.verifyingObserverGivenNameSoundex"}, false, voAttrs.getString(4235381));
                }
                catch (IllegalArgumentException ex) {
                    throw new DcmServiceException(43264, ex.getMessage() + ": " + voAttrs.get(4235381));
                }
            } else {
                subQuery.addPNMatch(new String[]{"VerifyingObserver.verifyingObserverName", "VerifyingObserver.verifyingObserverIdeographicName", "VerifyingObserver.verifyingObserverPhoneticName"}, false, filter.isICase(4235381), voAttrs.getString(4235381));
            }
            Match.Node node0 = this.sqlBuilder.addNodeMatch("OR", false);
            node0.addMatch(new Match.Subquery(subQuery, null, null));
        }
        if ((contentSeq = this.keys.get(4237104)) != null) {
            Match.Node node0 = null;
            int n = contentSeq.countItems();
            for (int i = 0; i < n; ++i) {
                String[] entities;
                Dataset conceptCode;
                Dataset item = contentSeq.getItem(i);
                String relType = item.getString(4235280);
                String textValue = filter.getString(item, 4235616);
                Dataset conceptName = item.getItem(4235331);
                if (!QueryCmd.isMatchCode(conceptName)) {
                    conceptName = null;
                }
                if (!QueryCmd.isMatchCode(conceptCode = item.getItem(4235624))) {
                    conceptCode = null;
                }
                if (conceptName == null && conceptCode == null && textValue == null && relType == null) continue;
                String[] aliases = null;
                if (conceptName != null) {
                    if (conceptCode != null) {
                        entities = new String[]{"ContentItem", "Code", "Code"};
                        aliases = new String[]{null, NAME_CODE, CONCEPT_CODE};
                    } else {
                        entities = new String[]{"ContentItem", "Code"};
                        aliases = new String[]{null, NAME_CODE};
                    }
                } else if (conceptCode != null) {
                    entities = new String[]{"ContentItem", "Code"};
                    aliases = new String[]{null, CONCEPT_CODE};
                } else {
                    entities = new String[]{"ContentItem"};
                }
                SqlBuilder subQuery = new SqlBuilder();
                subQuery.setSelect(new String[]{"ContentItem.pk"});
                subQuery.setFrom(entities);
                subQuery.setAliases(aliases);
                subQuery.addFieldValueMatch(null, "Instance.pk", false, null, "ContentItem.instance_fk");
                subQuery.addSingleValueMatch(null, "ContentItem.relationshipType", false, relType);
                subQuery.addWildCardMatch(null, "ContentItem.textValue", false, textValue);
                if (conceptName != null) {
                    subQuery.addFieldValueMatch(NAME_CODE, "Code.pk", false, null, "ContentItem.name_fk");
                    subQuery.addCodeMatch(NAME_CODE, conceptName);
                }
                if (conceptCode != null) {
                    subQuery.addFieldValueMatch(CONCEPT_CODE, "Code.pk", false, null, "ContentItem.code_fk");
                    subQuery.addCodeMatch(CONCEPT_CODE, conceptCode);
                }
                if (node0 == null) {
                    node0 = this.sqlBuilder.addNodeMatch("AND", false);
                }
                node0.addMatch(new Match.Subquery(subQuery, null, null));
            }
        }
        int[] fieldTags = filter.getFieldTags();
        for (int i = 0; i < fieldTags.length; ++i) {
            this.sqlBuilder.addWildCardMatch(null, "Instance." + filter.getField(fieldTags[i]), this.type2, filter.getStrings(this.keys, fieldTags[i]));
        }
    }

    public Dataset getDataset() throws SQLException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        this.fillDataset(ds);
        if (this.pidWithIssuers != null) {
            this.checkForDiffPatientDemographics(ds);
        }
        if (this.adjustPatientID != null) {
            this.adjustPatientID.adjust(ds);
        }
        this.adjustAccessionNumber(ds);
        this.adjustDataset(ds, this.keys);
        return this.filterResult ? ds.subSet(this.keys) : ds;
    }

    private void adjustAccessionNumber(Dataset ds) {
        if (this.requestedIssuerOfAccessionNumber == null) {
            return;
        }
        Dataset issuer = ds.getItem(524369);
        if (issuer == null || issuer.match(this.requestedIssuerOfAccessionNumber, false, true)) {
            return;
        }
        ds.putSQ(524369).addItem(this.requestedIssuerOfAccessionNumber);
        if (ds.contains(524368)) {
            ds.putSH(524368);
        }
    }

    private void checkForDiffPatientDemographics(Dataset ds) {
        String patId = this.getPatIdString(ds);
        if (!this.chkPatAttrs.containsKey(patId)) {
            for (Map.Entry<String, Dataset> entry : this.chkPatAttrs.entrySet()) {
                String patId2 = entry.getKey();
                Dataset ds2 = entry.getValue();
                for (int tag : PAT_DEMOGRAPHICS_ATTRS) {
                    DcmElement elem = ds.get(tag);
                    DcmElement elem2 = ds2.get(tag);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("compare:" + elem + " with " + elem2));
                    }
                    if (elem == null || elem2 == null || this.checkAttr(elem, elem2)) continue;
                    log.warn((Object)("Different patient attribute found! " + patId + elem + " <-> " + patId2 + elem2));
                }
            }
            this.chkPatAttrs.put(patId, ds);
        }
    }

    private boolean checkAttr(DcmElement elem, DcmElement elem1) {
        if (elem.isEmpty() && elem1.isEmpty()) {
            return true;
        }
        if (elem.vr() == 20558) {
            return this.getFnGn(elem).equals(this.getFnGn(elem1));
        }
        return elem.equals(elem1);
    }

    private String getFnGn(DcmElement el) {
        try {
            String pn = el.getString(null);
            if (pn == null) {
                return "";
            }
            int pos = pn.indexOf(61);
            if (pos != -1) {
                pn = pn.substring(0, pos);
            }
            if ((pos = pn.indexOf(94)) != -1) {
                return (pos = pn.indexOf(94, pos)) != -1 ? pn.substring(0, pos) : pn;
            }
            return pn;
        }
        catch (DcmValueException x) {
            log.error((Object)("Cant get family and given name value of " + el), (Throwable)x);
            return "";
        }
    }

    private String getPatIdString(Dataset ds) {
        return ds.getString(0x100020) + "^" + ds.getString(0x100021);
    }

    protected abstract void fillDataset(Dataset var1) throws SQLException;

    protected void fillDataset(Dataset ds, int column) throws SQLException {
        DatasetUtils.fromByteArray((byte[])this.rs.getBytes(column), (Dataset)ds);
    }

    private static boolean isMatchCode(Dataset code) {
        return code != null && (code.containsValue(524544) || code.containsValue(524546));
    }

    private static boolean isMatchIssuer(Dataset issuer) {
        return issuer != null && (issuer.containsValue(4194353) || issuer.containsValue(4194354));
    }

    protected boolean isMatchRequestAttributes() {
        Dataset rqAttrs = this.keys.getItem(4194933);
        return rqAttrs != null && (rqAttrs.containsValue(0x401001) || rqAttrs.containsValue(0x400009) || rqAttrs.containsValue(3280947) || rqAttrs.containsValue(3280946) || rqAttrs.containsValue(0x20000D) || rqAttrs.containsValue(524368));
    }

    protected boolean isMatchVerifyingObserver() {
        Dataset item = this.keys.getItem(4235379);
        return item != null && (item.containsValue(4235312) || item.containsValue(4235381));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ImageQueryCmd
    extends QueryCmd {
        HashMap<String, Dataset> seriesAttrsCache = new HashMap();

        protected ImageQueryCmd(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException {
            super(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
            int[] nArray;
            if (lazyFetchSeriesAttrsOnImageLevelQuery) {
                int[] nArray2 = new int[8];
                nArray2[0] = blobAccessType;
                nArray2[1] = 12;
                nArray2[2] = 12;
                nArray2[3] = 4;
                nArray2[4] = 93;
                nArray2[5] = 12;
                nArray2[6] = 12;
                nArray = nArray2;
                nArray2[7] = 12;
            } else {
                int[] nArray3 = new int[18];
                nArray3[0] = blobAccessType;
                nArray3[1] = 12;
                nArray3[2] = blobAccessType;
                nArray3[3] = blobAccessType;
                nArray3[4] = blobAccessType;
                nArray3[5] = 12;
                nArray3[6] = 12;
                nArray3[7] = 12;
                nArray3[8] = 4;
                nArray3[9] = 4;
                nArray3[10] = 4;
                nArray3[11] = 12;
                nArray3[12] = 12;
                nArray3[13] = 12;
                nArray3[14] = 4;
                nArray3[15] = 93;
                nArray3[16] = 12;
                nArray = nArray3;
                nArray3[17] = 12;
            }
            this.defineColumnTypes(nArray);
            this.addAdditionalReturnKeys();
        }

        @Override
        protected void init() throws DcmServiceException {
            super.init();
            this.addPatientMatch();
            this.addStudyMatch();
            this.addStudyPermissionMatch(false);
            this.addNestedSeriesMatch();
            this.addSeriesMatch();
            this.addInstanceMatch();
        }

        @Override
        protected String[] getSelectAttributes() {
            String[] stringArray;
            if (lazyFetchSeriesAttrsOnImageLevelQuery) {
                String[] stringArray2 = new String[8];
                stringArray2[0] = "Instance.encodedAttributes";
                stringArray2[1] = "Instance.retrieveAETs";
                stringArray2[2] = "Instance.externalRetrieveAET";
                stringArray2[3] = "Instance.availability";
                stringArray2[4] = "Instance.updatedTime";
                stringArray2[5] = "Series.seriesIuid";
                stringArray2[6] = "Media.filesetId";
                stringArray = stringArray2;
                stringArray2[7] = "Media.filesetIuid";
            } else {
                String[] stringArray3 = new String[18];
                stringArray3[0] = "Instance.encodedAttributes";
                stringArray3[1] = "Series.seriesIuid";
                stringArray3[2] = "Patient.encodedAttributes";
                stringArray3[3] = "Study.encodedAttributes";
                stringArray3[4] = "Series.encodedAttributes";
                stringArray3[5] = "Study.modalitiesInStudy";
                stringArray3[6] = "Study.sopClassesInStudy";
                stringArray3[7] = "Study.studyStatusId";
                stringArray3[8] = "Study.numberOfStudyRelatedSeries";
                stringArray3[9] = "Study.numberOfStudyRelatedInstances";
                stringArray3[10] = "Series.numberOfSeriesRelatedInstances";
                stringArray3[11] = "Series.sourceAET";
                stringArray3[12] = "Instance.retrieveAETs";
                stringArray3[13] = "Instance.externalRetrieveAET";
                stringArray3[14] = "Instance.availability";
                stringArray3[15] = "Instance.updatedTime";
                stringArray3[16] = "Media.filesetId";
                stringArray = stringArray3;
                stringArray3[17] = "Media.filesetIuid";
            }
            return stringArray;
        }

        @Override
        protected String[] getTables() {
            return new String[]{"Patient", "Study", "Series", "Instance"};
        }

        @Override
        protected String[] getLeftJoin() {
            String[] stringArray;
            if (QueryCmd.isMatchCode(this.keys.getItem(4235331))) {
                String[] stringArray2 = new String[8];
                stringArray2[0] = "Code";
                stringArray2[1] = QueryCmd.SR_CODE;
                stringArray2[2] = "Instance.srcode_fk";
                stringArray2[3] = "Code.pk";
                stringArray2[4] = "Media";
                stringArray2[5] = null;
                stringArray2[6] = "Instance.media_fk";
                stringArray = stringArray2;
                stringArray2[7] = "Media.pk";
            } else {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "Media";
                stringArray3[1] = null;
                stringArray3[2] = "Instance.media_fk";
                stringArray = stringArray3;
                stringArray3[3] = "Media.pk";
            }
            return stringArray;
        }

        @Override
        protected String[] getRelations() {
            return new String[]{"Patient.pk", "Study.patient_fk", "Study.pk", "Series.study_fk", "Series.pk", "Instance.series_fk"};
        }

        @Override
        protected boolean isKeySupported(DcmElement key) throws DcmServiceException {
            return this.isSupportedPatientKey(key) || this.isSupportedStudyKey(key) || this.isSupportedSeriesKey(key) || this.isSupportedInstanceKey(key);
        }

        @Override
        protected void fillDataset(Dataset ds) throws SQLException {
            if (lazyFetchSeriesAttrsOnImageLevelQuery) {
                this.fillDatasetWithLazyFetchSeriesAttrs(ds);
            } else {
                this.fillDatasetWithEagerFetchSeriesAttrs(ds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillDatasetWithLazyFetchSeriesAttrs(Dataset ds) throws SQLException {
            this.fillDataset(ds, 1);
            DatasetUtils.putRetrieveAET((Dataset)ds, (String)this.rs.getString(2), (String)this.rs.getString(3));
            ds.putCS(524374, AVAILABILITY[this.rs.getInt(4)]);
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putDT(4390934, (Date)this.rs.getTimestamp(5));
            ds.setPrivateCreatorID(null);
            String seriesIuid = this.rs.getString(6);
            ds.putSH(8913200, this.rs.getString(7));
            ds.putUI(8913216, this.rs.getString(8));
            Dataset seriesAttrs = this.seriesAttrsCache.get(seriesIuid);
            if (seriesAttrs == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Lazy fetch Series attributes for Series " + seriesIuid));
                }
                QuerySeriesAttrsForQueryCmd seriesQuery = new QuerySeriesAttrsForQueryCmd(transactionIsolationLevel, seriesBlobAccessType, seriesIuid);
                try {
                    seriesQuery.execute();
                    seriesQuery.next();
                    seriesAttrs = seriesQuery.getDataset();
                }
                finally {
                    seriesQuery.close();
                }
                this.seriesAttrsCache.put(seriesIuid, seriesAttrs);
            }
            ds.putAll((DcmObject)seriesAttrs);
            ds.putCS(524370, "IMAGE");
        }

        private void fillDatasetWithEagerFetchSeriesAttrs(Dataset ds) throws SQLException {
            this.fillDataset(ds, 1);
            if (cacheSeriesAttrsOnImageLevelQuery) {
                String seriesIuid = this.rs.getString(2);
                Dataset seriesAttrs = this.seriesAttrsCache.get(seriesIuid);
                if (seriesAttrs == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Cache Series attributes for Series " + seriesIuid));
                    }
                    seriesAttrs = DcmObjectFactory.getInstance().newDataset();
                    this.fillDataset(seriesAttrs, 3);
                    this.fillDataset(seriesAttrs, 4);
                    this.fillDataset(seriesAttrs, 5);
                    this.seriesAttrsCache.put(seriesIuid, seriesAttrs);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Use cached Series attributes for Series " + seriesIuid));
                }
                ds.putAll((DcmObject)seriesAttrs);
            } else {
                this.fillDataset(ds, 3);
                this.fillDataset(ds, 4);
                this.fillDataset(ds, 5);
            }
            ds.putCS(524385, StringUtils.split((String)this.rs.getString(6), (char)'\\'));
            ds.putUI(524386, StringUtils.split((String)this.rs.getString(7), (char)'\\'));
            ds.putCS(3276810, this.rs.getString(8));
            ds.putIS(2101766, this.rs.getInt(9));
            ds.putIS(2101768, this.rs.getInt(10));
            ds.putIS(2101769, this.rs.getInt(11));
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putSH(4390932, this.rs.getString(12));
            DatasetUtils.putRetrieveAET((Dataset)ds, (String)this.rs.getString(13), (String)this.rs.getString(14));
            ds.putCS(524374, AVAILABILITY[this.rs.getInt(15)]);
            ds.putDT(4390934, (Date)this.rs.getTimestamp(16));
            ds.setPrivateCreatorID(null);
            ds.putSH(8913200, this.rs.getString(17));
            ds.putUI(8913216, this.rs.getString(18));
            ds.putCS(524370, "IMAGE");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SeriesQueryCmd
    extends QueryCmd {
        protected SeriesQueryCmd(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException {
            super(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
            this.defineColumnTypes(new int[]{blobAccessType, blobAccessType, blobAccessType, 12, 12, 12, 4, 4, 4, 12, 12, 12, 12, 12, 4});
            this.addAdditionalReturnKeys();
        }

        @Override
        protected void init() throws DcmServiceException {
            super.init();
            this.addPatientMatch();
            this.addStudyMatch();
            this.addStudyPermissionMatch(false);
            this.addNestedSeriesMatch();
            this.addSeriesMatch();
        }

        @Override
        protected String[] getSelectAttributes() {
            return new String[]{"Patient.encodedAttributes", "Study.encodedAttributes", "Series.encodedAttributes", "Study.modalitiesInStudy", "Study.sopClassesInStudy", "Study.studyStatusId", "Study.numberOfStudyRelatedSeries", "Study.numberOfStudyRelatedInstances", "Series.numberOfSeriesRelatedInstances", "Series.filesetId", "Series.filesetIuid", "Series.retrieveAETs", "Series.externalRetrieveAET", "Series.sourceAET", "Series.availability"};
        }

        @Override
        protected String[] getTables() {
            return new String[]{"Patient", "Study", "Series"};
        }

        @Override
        protected String[] getRelations() {
            return new String[]{"Patient.pk", "Study.patient_fk", "Study.pk", "Series.study_fk"};
        }

        @Override
        protected String[] getLeftJoin() {
            return null;
        }

        @Override
        protected boolean isKeySupported(DcmElement key) throws DcmServiceException {
            return this.isSupportedPatientKey(key) || this.isSupportedStudyKey(key) || this.isSupportedSeriesKey(key);
        }

        @Override
        protected void fillDataset(Dataset ds) throws SQLException {
            this.fillDataset(ds, 1);
            this.fillDataset(ds, 2);
            this.fillDataset(ds, 3);
            ds.putCS(524385, StringUtils.split((String)this.rs.getString(4), (char)'\\'));
            ds.putUI(524386, StringUtils.split((String)this.rs.getString(5), (char)'\\'));
            ds.putCS(3276810, this.rs.getString(6));
            ds.putIS(2101766, this.rs.getInt(7));
            ds.putIS(2101768, this.rs.getInt(8));
            ds.putIS(2101769, this.rs.getInt(9));
            ds.putSH(8913200, this.rs.getString(10));
            ds.putUI(8913216, this.rs.getString(11));
            DatasetUtils.putRetrieveAET((Dataset)ds, (String)this.rs.getString(12), (String)this.rs.getString(13));
            ds.setPrivateCreatorID("dcm4che/archive");
            ds.putSH(4390932, this.rs.getString(14));
            ds.setPrivateCreatorID(null);
            ds.putCS(524374, AVAILABILITY[this.rs.getInt(15)]);
            ds.putCS(524370, "SERIES");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StudyQueryCmd
    extends QueryCmd {
        protected StudyQueryCmd(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException {
            super(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
            this.defineColumnTypes(new int[]{blobAccessType, blobAccessType, 12, 12, 12, 4, 4, 12, 12, 12, 12, 4});
            this.addAdditionalReturnKeys();
        }

        @Override
        protected void init() throws DcmServiceException {
            super.init();
            this.addPatientMatch();
            this.addStudyMatch();
            this.addStudyPermissionMatch(false);
            this.addNestedSeriesMatch();
        }

        @Override
        protected String[] getSelectAttributes() {
            return new String[]{"Patient.encodedAttributes", "Study.encodedAttributes", "Study.modalitiesInStudy", "Study.sopClassesInStudy", "Study.studyStatusId", "Study.numberOfStudyRelatedSeries", "Study.numberOfStudyRelatedInstances", "Study.filesetId", "Study.filesetIuid", "Study.retrieveAETs", "Study.externalRetrieveAET", "Study.availability"};
        }

        @Override
        protected String[] getTables() {
            return new String[]{"Patient", "Study"};
        }

        @Override
        protected String[] getRelations() {
            return new String[]{"Patient.pk", "Study.patient_fk"};
        }

        @Override
        protected boolean isKeySupported(DcmElement key) throws DcmServiceException {
            return this.isSupportedPatientKey(key) || this.isSupportedStudyKey(key);
        }

        @Override
        protected void fillDataset(Dataset ds) throws SQLException {
            this.fillDataset(ds, 1);
            this.fillDataset(ds, 2);
            ds.putCS(524385, StringUtils.split((String)this.rs.getString(3), (char)'\\'));
            ds.putUI(524386, StringUtils.split((String)this.rs.getString(4), (char)'\\'));
            ds.putCS(3276810, this.rs.getString(5));
            ds.putIS(2101766, this.rs.getInt(6));
            ds.putIS(2101768, this.rs.getInt(7));
            ds.putSH(8913200, this.rs.getString(8));
            ds.putUI(8913216, this.rs.getString(9));
            DatasetUtils.putRetrieveAET((Dataset)ds, (String)this.rs.getString(10), (String)this.rs.getString(11));
            ds.putCS(524374, AVAILABILITY[this.rs.getInt(12)]);
            ds.putCS(524370, "STUDY");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PatientQueryCmd
    extends QueryCmd {
        protected PatientQueryCmd(Dataset keys, Set<PIDWithIssuer> pidWithIssuers, boolean filterResult, boolean fuzzyMatchingOfPN, boolean noMatchForNoValue, boolean noMatchWithoutIssuerOfPID, Subject subject) throws SQLException {
            super(keys, pidWithIssuers, filterResult, fuzzyMatchingOfPN, noMatchForNoValue, noMatchWithoutIssuerOfPID, subject);
            this.defineColumnTypes(new int[]{blobAccessType});
        }

        @Override
        protected void init() throws DcmServiceException {
            super.init();
            this.addPatientMatch();
            this.addStudyPermissionMatch(true);
        }

        @Override
        protected boolean isKeySupported(DcmElement key) throws DcmServiceException {
            return this.isSupportedPatientKey(key);
        }

        @Override
        protected void fillDataset(Dataset ds) throws SQLException {
            this.fillDataset(ds, 1);
            ds.putCS(524370, "PATIENT");
        }

        @Override
        protected String[] getSelectAttributes() {
            return new String[]{"Patient.encodedAttributes"};
        }

        @Override
        protected String[] getTables() {
            return new String[]{"Patient"};
        }
    }
}

