/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.jdbc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dcm4che.data.PersonName;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.ejb.jdbc.JdbcProperties;
import org.dcm4chex.archive.ejb.jdbc.SqlBuilder;

abstract class Match {
    protected String column;
    protected final boolean type2;

    protected Match() {
        this.type2 = false;
    }

    protected Match(String alias, String field, boolean type2) {
        this.column = Match.formatColumn(alias, field);
        this.type2 = type2;
    }

    private static String formatColumn(String alias, String field) {
        String col = JdbcProperties.getInstance().getProperty(field);
        if (col == null) {
            throw new IllegalArgumentException("field: " + field);
        }
        if (alias != null) {
            col = alias + col.substring(col.indexOf(46));
        }
        return col;
    }

    public boolean appendTo(StringBuffer sb) {
        if (this.isUniveralMatch()) {
            return false;
        }
        sb.append('(');
        if (this.type2) {
            sb.append(this.column);
            sb.append(" IS NULL OR ");
        }
        this.appendBodyTo(sb);
        sb.append(')');
        return true;
    }

    public abstract boolean isUniveralMatch();

    protected abstract void appendBodyTo(StringBuffer var1);

    public static class PNFuzzy
    extends Match {
        private final boolean type_2;
        private final String[] columns;
        private final String[] soundex;

        public PNFuzzy(String[] fields, boolean type2, PersonName pn) {
            this.type_2 = type2;
            this.columns = JdbcProperties.getInstance().getProperties(fields);
            this.soundex = new String[]{AttributeFilter.toSoundexWithLike((PersonName)pn, (int)0), AttributeFilter.toSoundexWithLike((PersonName)pn, (int)1)};
        }

        private static String like(String soundex) {
            return soundex != null && soundex.endsWith("%") ? " LIKE '" : " = '";
        }

        protected void appendBodyTo(StringBuffer sb) {
            if (this.soundex[0] != null && this.soundex[1] != null) {
                String[] like = new String[]{PNFuzzy.like(this.soundex[0]), PNFuzzy.like(this.soundex[1])};
                if (this.type_2) {
                    sb.append('(').append(this.columns[0]).append(like[0]).append(this.soundex[0]).append("' OR ").append(this.columns[0]).append(" = '*') AND (").append(this.columns[1]).append(like[1]).append(this.soundex[1]).append("' OR ").append(this.columns[1]).append(" = '*') OR (").append(this.columns[0]).append(like[1]).append(this.soundex[1]).append("' OR ").append(this.columns[0]).append(" = '*') AND (").append(this.columns[1]).append(like[0]).append(this.soundex[0]).append("' OR ").append(this.columns[1]).append(" = '*')");
                } else {
                    sb.append(this.columns[0]).append(like[0]).append(this.soundex[0]).append("' AND ").append(this.columns[1]).append(like[1]).append(this.soundex[1]).append("' OR ").append(this.columns[0]).append(like[1]).append(this.soundex[1]).append("' AND ").append(this.columns[1]).append(like[0]).append(this.soundex[0]).append("'");
                }
            } else {
                String soundex0 = this.soundex[this.soundex[0] != null ? 0 : 1];
                String like0 = PNFuzzy.like(soundex0);
                sb.append(this.columns[0]).append(like0).append(soundex0).append("' OR ").append(this.columns[1]).append(like0).append(soundex0);
                if (this.type_2) {
                    sb.append("' OR (").append(this.columns[0]).append(" = '*' AND ").append(this.columns[1]).append(" = '*')");
                } else {
                    sb.append("'");
                }
            }
        }

        public boolean isUniveralMatch() {
            return this.soundex[0] == null && this.soundex[1] == null;
        }
    }

    static class Subquery
    extends Match {
        private final String subQueryStr;

        public Subquery(SqlBuilder subQuery, String field, String alias) {
            subQuery.setSubQueryMode(true);
            StringBuffer sb = new StringBuffer();
            if (field == null) {
                sb.append("EXISTS (");
            } else {
                String column = JdbcProperties.getInstance().getProperty(field);
                if (column == null) {
                    throw new IllegalArgumentException("field for uncorrelated subquery does not exist: " + field);
                }
                if (alias != null) {
                    column = alias + column.substring(column.indexOf(46));
                }
                sb.append(column).append(" IN ");
            }
            sb.append(subQuery.getSql());
            sb.append(")");
            this.subQueryStr = sb.toString();
        }

        public boolean isUniveralMatch() {
            return false;
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.subQueryStr);
        }
    }

    static class Node
    extends Match {
        private List<Match> matches = new ArrayList<Match>();
        private final String orORand;
        private final boolean invert;

        public Node(String orORand, boolean invert) {
            this.orORand = orORand;
            this.invert = invert;
        }

        public void addMatch(Match match) {
            this.matches.add(match);
        }

        public boolean isUniveralMatch() {
            return false;
        }

        protected void appendBodyTo(StringBuffer sb) {
            if (this.invert) {
                sb.append(" NOT");
            }
            sb.append(" ( ");
            Iterator<Match> iter = this.matches.iterator();
            iter.next().appendTo(sb);
            while (iter.hasNext()) {
                sb.append(this.orORand);
                iter.next().appendTo(sb);
            }
            sb.append(" )");
        }

        public boolean appendTo(StringBuffer sb) {
            if (this.matches.isEmpty()) {
                return false;
            }
            this.appendBodyTo(sb);
            return true;
        }
    }

    static class QueryPermissionNestedMatch
    extends Match {
        private final String[] roles;
        private final boolean patientLevel;
        private final boolean checkForNoStudy;

        public QueryPermissionNestedMatch(boolean patientLevel, boolean checkForNoStudy, String[] roles) {
            super(null, "StudyPermission.role", false);
            this.roles = roles;
            this.patientLevel = patientLevel;
            this.checkForNoStudy = checkForNoStudy;
        }

        public boolean isUniveralMatch() {
            return false;
        }

        protected void appendBodyTo(StringBuffer sb) {
            JdbcProperties jp = JdbcProperties.getInstance();
            if (this.checkForNoStudy) {
                sb.append('(');
                sb.append(jp.getProperty("Study.pk"));
                sb.append(" IS NULL OR ");
            }
            sb.append("EXISTS (SELECT 1 FROM ");
            if (this.patientLevel) {
                sb.append(jp.getProperty("Study"));
                sb.append(", ");
            }
            sb.append(jp.getProperty("StudyPermission"));
            sb.append(" WHERE ");
            if (this.patientLevel) {
                sb.append(jp.getProperty("Patient.pk"));
                sb.append(" = ");
                sb.append(jp.getProperty("Study.patient_fk"));
                sb.append(" AND ");
            }
            sb.append(jp.getProperty("Study.studyIuid"));
            sb.append(" = ");
            sb.append(jp.getProperty("StudyPermission.studyIuid"));
            sb.append(" AND ");
            sb.append(jp.getProperty("StudyPermission.action"));
            sb.append(" = 'Q' AND ");
            sb.append(this.column);
            if (this.roles.length == 1) {
                sb.append(" = '").append(this.roles[0]).append('\'');
            } else {
                sb.append(" IN ('").append(this.roles[0]);
                for (int i = 1; i < this.roles.length; ++i) {
                    sb.append("', '").append(this.roles[i]);
                }
                sb.append("')");
            }
            sb.append(')');
            if (this.checkForNoStudy) {
                sb.append(')');
            }
        }
    }

    static class CallingAETsNestedMatch
    extends Match {
        private final String[] callingAETs;
        private final boolean privTables;

        public CallingAETsNestedMatch(boolean privTables, String[] callingAETs) {
            super(null, privTables ? "PrivateSeries.sourceAET" : "Series.sourceAET", false);
            this.privTables = privTables;
            this.callingAETs = callingAETs != null ? (String[])callingAETs.clone() : new String[]{};
        }

        public boolean isUniveralMatch() {
            return this.callingAETs.length == 0;
        }

        protected void appendBodyTo(StringBuffer sb) {
            JdbcProperties jp = JdbcProperties.getInstance();
            sb.append("EXISTS (SELECT 1 FROM ");
            sb.append(jp.getProperty(this.privTables ? "PrivateSeries" : "Series"));
            sb.append(" WHERE ");
            sb.append(jp.getProperty(this.privTables ? "PrivateSeries.study_fk" : "Series.study_fk"));
            sb.append(" = ");
            sb.append(jp.getProperty(this.privTables ? "PrivateStudy.pk" : "Study.pk"));
            sb.append(" AND ");
            sb.append(this.column);
            if (this.callingAETs.length == 1) {
                sb.append(" = '").append(this.callingAETs[0]).append('\'');
            } else {
                sb.append(" IN ('").append(this.callingAETs[0]);
                for (int i = 1; i < this.callingAETs.length; ++i) {
                    sb.append("', '").append(this.callingAETs[i]);
                }
                sb.append("')");
            }
            sb.append(" )");
        }
    }

    static class ModalitiesInStudyNestedMatch
    extends Match {
        private final char[] wc;

        public ModalitiesInStudyNestedMatch(String alias, String md) {
            super(alias, "Series.modality", false);
            this.wc = md != null ? md.toCharArray() : new char[]{};
        }

        public boolean isUniveralMatch() {
            int i = this.wc.length;
            while (--i >= 0) {
                if (this.wc[i] == '*') continue;
                return false;
            }
            return true;
        }

        public boolean isLike() {
            int i = this.wc.length;
            while (--i >= 0) {
                if (this.wc[i] != '*' && this.wc[i] != '?') continue;
                return true;
            }
            return false;
        }

        protected void appendBodyTo(StringBuffer sb) {
            JdbcProperties jp = JdbcProperties.getInstance();
            sb.append("exists (SELECT 1 FROM ");
            sb.append(jp.getProperty("Series"));
            sb.append(" WHERE ");
            sb.append(jp.getProperty("Series.study_fk"));
            sb.append(" = ");
            sb.append(jp.getProperty("Study.pk"));
            sb.append(" AND ");
            sb.append(this.column);
            boolean like = this.isLike();
            sb.append(like ? " LIKE '" : " = '");
            for (int i = 0; i < this.wc.length; ++i) {
                char c = this.wc[i];
                switch (c) {
                    case '?': {
                        c = '_';
                        break;
                    }
                    case '*': {
                        c = '%';
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '%': 
                    case '_': {
                        if (!like) break;
                        sb.append('\\');
                    }
                }
                sb.append(c);
            }
            sb.append("')");
        }
    }

    static class ModalitiesInStudyMultiNestedMatch
    extends Match {
        private final String[] mds;

        public ModalitiesInStudyMultiNestedMatch(String alias, String[] mds) {
            super(alias, "Series.modality", false);
            this.mds = mds != null ? mds : new String[]{};
        }

        public boolean isUniveralMatch() {
            return this.mds.length == 0;
        }

        protected void appendBodyTo(StringBuffer sb) {
            JdbcProperties jp = JdbcProperties.getInstance();
            sb.append("EXISTS (SELECT 1 FROM ");
            sb.append(jp.getProperty("Series"));
            sb.append(" WHERE ");
            sb.append(jp.getProperty("Series.study_fk"));
            sb.append(" = ");
            sb.append(jp.getProperty("Study.pk"));
            sb.append(" AND ");
            sb.append(this.column);
            if (this.mds.length == 1) {
                sb.append(" = '").append(this.mds[0]).append('\'');
            } else {
                sb.append(" IN ('").append(this.mds[0]);
                for (int i = 1; i < this.mds.length; ++i) {
                    sb.append("', '").append(this.mds[i]);
                }
                sb.append("')");
            }
            sb.append(')');
        }
    }

    static class StringRange
    extends Match {
        private final String[] range;

        public StringRange(String alias, String field, boolean type2, String[] range) {
            super(alias, field, type2);
            this.range = range != null ? (String[])range.clone() : null;
        }

        public boolean isUniveralMatch() {
            return this.range == null;
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            if (this.range[0] != null) {
                sb.append(" >= '");
                sb.append(this.range[0]);
                if (this.range[1] != null) {
                    sb.append("' AND ");
                    sb.append(this.column);
                }
            }
            if (this.range[1] != null) {
                sb.append(" <= '");
                sb.append(this.range[1]);
            }
            sb.append('\'');
        }
    }

    static class Range
    extends Match {
        private final Date[] range;
        private final String format;

        public Range(String alias, String field, boolean type2, Date[] range, String format) {
            super(alias, field, type2);
            this.range = range != null ? (Date[])range.clone() : null;
            this.format = format;
        }

        public boolean isUniveralMatch() {
            return this.range == null;
        }

        protected void appendBodyTo(StringBuffer sb) {
            SimpleDateFormat df = new SimpleDateFormat(this.format);
            sb.append(this.column);
            if (this.range[0] == null) {
                sb.append(" <= ");
                sb.append(df.format(this.range[1]));
            } else if (this.range[1] == null) {
                sb.append(" >= ");
                sb.append(df.format(this.range[0]));
            } else {
                sb.append(" BETWEEN ");
                sb.append(df.format(this.range[0]));
                sb.append(" AND ");
                sb.append(df.format(this.range[1]));
            }
        }
    }

    static class WildCard
    extends Match {
        private final char[] wc;

        public WildCard(String alias, String field, boolean type2, String wc) {
            super(alias, field, type2);
            this.wc = wc != null ? wc.toCharArray() : new char[]{};
        }

        public boolean isUniveralMatch() {
            int i = this.wc.length;
            while (--i >= 0) {
                if (this.wc[i] == '*') continue;
                return false;
            }
            return true;
        }

        public boolean isLike() {
            int i = this.wc.length;
            while (--i >= 0) {
                if (this.wc[i] != '*' && this.wc[i] != '?') continue;
                return true;
            }
            return false;
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            boolean like = this.isLike();
            sb.append(like ? " LIKE '" : " = '");
            boolean escape = false;
            for (int i = 0; i < this.wc.length; ++i) {
                char c = this.wc[i];
                switch (c) {
                    case '?': {
                        c = '_';
                        break;
                    }
                    case '*': {
                        c = '%';
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '%': 
                    case '_': {
                        if (!like) break;
                        sb.append('\\');
                        escape = true;
                    }
                }
                sb.append(c);
            }
            sb.append('\'');
            if (escape) {
                sb.append(JdbcProperties.getInstance().getEscape());
            }
        }
    }

    static class ListOfString
    extends Match {
        private final String[] strings;

        public ListOfString(String alias, String field, boolean type2, String[] strings) {
            super(alias, field, type2);
            this.strings = strings != null ? (String[])strings.clone() : new String[]{};
        }

        public boolean isUniveralMatch() {
            return this.strings.length == 0 || this.strings[0].equals("*");
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            if (this.strings.length == 1) {
                sb.append(" = '").append(this.strings[0]).append('\'');
            } else {
                sb.append(" IN ('").append(this.strings[0]);
                for (int i = 1; i < this.strings.length; ++i) {
                    sb.append("', '").append(this.strings[i]);
                }
                sb.append("')");
            }
        }
    }

    static class AppendLiteral
    extends Match {
        private String literal;

        public AppendLiteral(String alias, String field, boolean type2, String literal) {
            super(alias, field, type2);
            this.literal = literal;
        }

        public boolean isUniveralMatch() {
            return false;
        }

        public void setLiteral(String s) {
            this.literal = s;
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            sb.append(" ");
            sb.append(this.literal);
        }
    }

    static class ListOfInt
    extends Match {
        private final int[] ints;

        public ListOfInt(String alias, String field, boolean type2, int[] ints) {
            super(alias, field, type2);
            this.ints = ints != null ? (int[])ints.clone() : new int[]{};
        }

        public boolean isUniveralMatch() {
            return this.ints.length == 0;
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            if (this.ints.length == 1) {
                sb.append(" = ").append(this.ints[0]);
            } else {
                sb.append(" IN (").append(this.ints[0]);
                for (int i = 1; i < this.ints.length; ++i) {
                    sb.append(", ").append(this.ints[i]);
                }
                sb.append(")");
            }
        }
    }

    static class IntValue
    extends Match {
        private final int value;

        public IntValue(String alias, String field, boolean type2, int value) {
            super(alias, field, type2);
            this.value = value;
        }

        public boolean isUniveralMatch() {
            return false;
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            sb.append(" = ");
            sb.append(this.value);
        }
    }

    static class FieldValue
    extends Match {
        private final String column1;

        public FieldValue(String alias1, String field1, boolean type2, String alias2, String field2) {
            super(alias1, field1, type2);
            this.column1 = Match.formatColumn(alias2, field2);
        }

        public boolean isUniveralMatch() {
            return this.column1 == null || this.column1.length() == 0;
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            sb.append(" = ");
            sb.append(this.column1);
        }
    }

    static class SingleValue
    extends Match {
        private final String value;

        public SingleValue(String alias, String field, boolean type2, String value) {
            super(alias, field, type2);
            this.value = value;
        }

        public boolean isUniveralMatch() {
            return this.value == null || this.value.length() == 0 || this.value.equals("*");
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            sb.append(" = '");
            sb.append(this.value == null ? this.value : this.value.replaceAll("'", "''"));
            sb.append('\'');
        }
    }

    static class NULLValue
    extends Match {
        private boolean inverter;

        public NULLValue(String alias, String field, boolean inverter) {
            super(alias, field, false);
            this.inverter = inverter;
        }

        public boolean isUniveralMatch() {
            return false;
        }

        protected void appendBodyTo(StringBuffer sb) {
            sb.append(this.column);
            sb.append(" IS");
            if (this.inverter) {
                sb.append(" NOT");
            }
            sb.append(" NULL");
        }
    }
}

